/* Copyright (c) 1987, 1988  Stanley T. Shebs. */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact. */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <strings.h>
#include <time.h>
#include <unistd.h>

/* Random definitions useful for nearly any C program. */

#define PATH_MAX 1023
#define NAME_MAX 255
#define LINEMAX 1024

/* If some system tries to redefine bool, we're screwed. */

#define bool int

/* Some systems define TRUE and FALSE themselves. */

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif

#define abs(x) (((x) < 0) ? (0 - (x)) : (x))

#define min(x,y) (((x) < (y)) ? (x) : (y))

#define max(x,y) (((x) > (y)) ? (x) : (y))

#define between(lo,n,hi) ((lo) <= (n) && (n) <= (hi))

#define flip_coin() (lrand48() % 2)

#define avg(a,b) (((a) + (b)) / 2)

#define iswhite(c) ((c) == ' ' || (c) == '\n' || (c) == '\t')

#define lowercase(c) (isupper(c) ? tolower(c) : (c))

#define uppercase(c) (islower(c) ? toupper(c) : (c))

#define RANDOM(m) (lrand48()%(m))

#ifndef DEBUG 

#define PROCSTACKSIZE 30
extern char *procedure_executing[PROCSTACKSIZE], *routine_executing;
extern int procedure_stack_ptr;
#define enter_procedure(x) {procedure_stack_ptr =\
 (procedure_stack_ptr + 1) % PROCSTACKSIZE; \
   procedure_executing[procedure_stack_ptr] = x;}
#define exit_procedure() {procedure_stack_ptr =\
(procedure_stack_ptr == 0 ? PROCSTACKSIZE - 1 : (procedure_stack_ptr - 1));}
#define cur_procedure() procedure_executing[procedure_stack_ptr]
#define routine(x) routine_executing = x

#else

#define enter_procedure(x)
#define exit_procedure()
#define cur_procedure()
#define routine(x)

#endif

/* Miscellaneous declarations. */

extern char spbuf[];
extern int splen;
extern char tmpbuf[];

extern bool Debug;
extern bool Build;
extern bool Freeze;
extern bool Cheat;

extern int numfiles;
extern int numgivens;
extern int numhumans;
extern int nummaps;

extern bool givenseen;
extern int givenwidth;
extern int givenheight;
extern char *xconqlib;

extern bool humans[];
extern char *rawfilenames[];
extern char *hosts[];

/* util */
extern int dirx[];
extern int diry[];
extern void make_pathname (char *path, char *name, char *extn, char *pathbuf);
extern void remove_saved_game();
extern void init_random();
extern int probability(int prob);
extern char *read_line(FILE *fp);
extern char *copy_string(char *str);
extern int distance(int x1, int y1, int x2, int y2);
extern int find_dir(int dx, int dy);
extern char *ordinal(int n);
extern char *plural_form(char *word);
extern int iindex(char ch, char *str);
extern void case_panic(char *str, int var);
extern int isqrt(int i);
