/* Copyright (c) 1987, 1988  Stanley T. Shebs. */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact. */
   

#include "config.h"
#include "misc.h"
#include "dir.h"
#include "period.h"
#include "side.h"
#include "unit.h"
#include "map.h"
#include "mplay.h"
#include "Motif.h"
#include "global.h"


int ask_unit_type(Side *side, short *possibles) {

    int numtypes = 0, u, last, type;

    for_all_unit_types(u) {
        side->unitslist[u].bvec = FALSE;
        if (possibles == NULL || possibles[u]) {
            side->unitslist[u].bvec = TRUE;
            last = u;
            numtypes++;
        }
    }
    if (numtypes == 0) {
        type = NOTHING;
    } else if (numtypes == 1) {
        type = last;
    } else {
        type = -1;
    }
    return type;
}

/* This is called when production is to be set or changed.  Note that since */
/* the user has a pretty dull choice if there is only one possible type of */
/* unit to build, in such cases we can bypass requests altogether. */

void request_new_product(Unit *unit) {

    int u;
    Side *us = unit->side;
       
    if (humanside(us)) {
        sprintf(spbuf, "%s will build: ", unit_handle(us, unit));
        u = ask_unit_type(us, utypes[unit->type].make);
        if (u < 0) {
            remove_move_callbacks(us);
            create_unit_dialog(us, spbuf, unit->product, x_product);
            make_current(us, unit);
        } else {
          if (u != unit->product) {
            set_product(unit, u);
            set_schedule(unit);
            show_product(us, unit);
          }
        }
    }
    else {
        set_product(unit, machine_product(unit));
        set_schedule(unit);
    }
}
