; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -fp-contract=fast -verify-machineinstrs | FileCheck %s
; RUN: %if ptxas %{ llc < %s -mtriple=nvptx64 -mcpu=sm_20 -fp-contract=fast -verify-machineinstrs | %ptxas-verify %}

declare float @dummy_f32(float, float) #0
declare double @dummy_f64(double, double) #0

define ptx_device float @t1_f32(float %x, float %y, float %z) {
; CHECK-LABEL: t1_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [t1_f32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [t1_f32_param_1];
; CHECK-NEXT:    ld.param.b32 %r3, [t1_f32_param_2];
; CHECK-NEXT:    fma.rn.f32 %r4, %r1, %r2, %r3;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-NEXT:    ret;
  %a = fmul float %x, %y
  %b = fadd float %a, %z
  ret float %b
}

define ptx_device float @t2_f32(float %x, float %y, float %z, float %w) {
; CHECK-LABEL: t2_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<9>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [t2_f32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [t2_f32_param_1];
; CHECK-NEXT:    ld.param.b32 %r3, [t2_f32_param_2];
; CHECK-NEXT:    fma.rn.f32 %r4, %r1, %r2, %r3;
; CHECK-NEXT:    ld.param.b32 %r5, [t2_f32_param_3];
; CHECK-NEXT:    fma.rn.f32 %r6, %r1, %r2, %r5;
; CHECK-NEXT:    { // callseq 0, 0
; CHECK-NEXT:    .param .b32 param0;
; CHECK-NEXT:    st.param.b32 [param0], %r4;
; CHECK-NEXT:    .param .b32 param1;
; CHECK-NEXT:    st.param.b32 [param1], %r6;
; CHECK-NEXT:    .param .b32 retval0;
; CHECK-NEXT:    call.uni (retval0), dummy_f32, (param0, param1);
; CHECK-NEXT:    ld.param.b32 %r7, [retval0];
; CHECK-NEXT:    } // callseq 0
; CHECK-NEXT:    st.param.b32 [func_retval0], %r7;
; CHECK-NEXT:    ret;
  %a = fmul float %x, %y
  %b = fadd float %a, %z
  %c = fadd float %a, %w
  %d = call float @dummy_f32(float %b, float %c)
  ret float %d
}

define ptx_device double @t1_f64(double %x, double %y, double %z) {
; CHECK-LABEL: t1_f64(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [t1_f64_param_0];
; CHECK-NEXT:    ld.param.b64 %rd2, [t1_f64_param_1];
; CHECK-NEXT:    ld.param.b64 %rd3, [t1_f64_param_2];
; CHECK-NEXT:    fma.rn.f64 %rd4, %rd1, %rd2, %rd3;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd4;
; CHECK-NEXT:    ret;
  %a = fmul double %x, %y
  %b = fadd double %a, %z
  ret double %b
}

define ptx_device double @t2_f64(double %x, double %y, double %z, double %w) {
; CHECK-LABEL: t2_f64(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<9>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [t2_f64_param_0];
; CHECK-NEXT:    ld.param.b64 %rd2, [t2_f64_param_1];
; CHECK-NEXT:    ld.param.b64 %rd3, [t2_f64_param_2];
; CHECK-NEXT:    fma.rn.f64 %rd4, %rd1, %rd2, %rd3;
; CHECK-NEXT:    ld.param.b64 %rd5, [t2_f64_param_3];
; CHECK-NEXT:    fma.rn.f64 %rd6, %rd1, %rd2, %rd5;
; CHECK-NEXT:    { // callseq 1, 0
; CHECK-NEXT:    .param .b64 param0;
; CHECK-NEXT:    st.param.b64 [param0], %rd4;
; CHECK-NEXT:    .param .b64 param1;
; CHECK-NEXT:    st.param.b64 [param1], %rd6;
; CHECK-NEXT:    .param .b64 retval0;
; CHECK-NEXT:    call.uni (retval0), dummy_f64, (param0, param1);
; CHECK-NEXT:    ld.param.b64 %rd7, [retval0];
; CHECK-NEXT:    } // callseq 1
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd7;
; CHECK-NEXT:    ret;
  %a = fmul double %x, %y
  %b = fadd double %a, %z
  %c = fadd double %a, %w
  %d = call double @dummy_f64(double %b, double %c)
  ret double %d
}

define ptx_device float @f32_iir(float %x) {
; CHECK-LABEL: f32_iir(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [f32_iir_param_0];
; CHECK-NEXT:    fma.rn.f32 %r2, 0f52E8D4A5, 0f4A52FC54, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %r = call float @llvm.fma.f32(float 499999997952.0, float 3456789.0, float %x)
  ret float %r
}

define ptx_device float @f32_iii(float %x) {
; CHECK-LABEL: f32_iii(
; CHECK:       {
; CHECK-EMPTY:
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    st.param.b32 [func_retval0], 1092616192;
; CHECK-NEXT:    ret;
  %r = call float @llvm.fma.f32(float 2.0, float 3.0, float 4.0)
  ret float %r
}
