// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-real-true16 -show-encoding %s | FileCheck --check-prefixes=GFX11 %s
// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64,-real-true16 -show-encoding %s | FileCheck --check-prefixes=GFX11 %s

v_cmpx_class_f16_dpp v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0xfa,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_class_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0xfa,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_class_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0xfa,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_class_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0xfc,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_class_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0xfc,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_class_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0xfd,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_eq_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x04,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_eq_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x04,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_eq_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x04,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_eq_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x24,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_eq_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x24,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_eq_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x25,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_eq_i16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x64,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_eq_i16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x64,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_eq_i16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x64,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_eq_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x84,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_eq_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x84,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_eq_i32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x85,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_eq_u16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x74,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_eq_u16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x74,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_eq_u16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x74,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_eq_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x94,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_eq_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x94,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_eq_u32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x95,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_f_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x00,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_f_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x00,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_f_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x00,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_f_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x20,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_f_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x20,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_f_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x21,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_f_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x80,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_f_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x80,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_f_i32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x81,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_f_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x90,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_f_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x90,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_f_u32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x91,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_ge_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x0c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ge_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x0c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ge_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x0c,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_ge_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x2c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ge_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x2c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ge_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x2d,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_ge_i16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x6c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ge_i16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x6c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ge_i16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x6c,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_ge_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x8c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ge_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x8c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ge_i32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x8d,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_ge_u16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x7c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ge_u16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x7c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ge_u16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x7c,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_ge_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x9c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ge_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x9c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ge_u32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x9d,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_gt_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x08,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_gt_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x08,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_gt_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x08,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_gt_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x28,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_gt_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x28,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_gt_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x29,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_gt_i16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x68,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_gt_i16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x68,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_gt_i16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x68,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_gt_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x88,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_gt_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x88,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_gt_i32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x89,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_gt_u16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x78,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_gt_u16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x78,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_gt_u16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x78,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_gt_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x98,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_gt_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x98,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_gt_u32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x99,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_le_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x06,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_le_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x06,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_le_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x06,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_le_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x26,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_le_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x26,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_le_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x27,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_le_i16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x66,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_le_i16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x66,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_le_i16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x66,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_le_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x86,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_le_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x86,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_le_i32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x87,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_le_u16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x76,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_le_u16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x76,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_le_u16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x76,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_le_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x96,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_le_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x96,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_le_u32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x97,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_lg_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x0a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lg_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x0a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lg_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x0a,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_lg_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x2a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lg_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x2a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lg_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x2b,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_lt_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x02,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lt_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x02,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lt_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x02,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_lt_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x22,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lt_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x22,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lt_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x23,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_lt_i16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x62,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lt_i16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x62,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lt_i16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x62,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_lt_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x82,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lt_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x82,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lt_i32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x83,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_lt_u16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x72,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lt_u16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x72,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lt_u16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x72,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_lt_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x92,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lt_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x92,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_lt_u32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x93,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_ne_i16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x6a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ne_i16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x6a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ne_i16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x6a,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_ne_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x8a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ne_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x8a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ne_i32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x8b,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_ne_u16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x7a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ne_u16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x7a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ne_u16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x7a,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_ne_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x9a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ne_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x9a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ne_u32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x9b,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_neq_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x1a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_neq_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x1a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_neq_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x1a,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_neq_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x3a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_neq_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x3a,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_neq_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x3b,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_nge_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x12,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nge_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x12,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nge_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x12,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_nge_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x32,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nge_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x32,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nge_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x33,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_ngt_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x16,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ngt_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x16,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ngt_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x16,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_ngt_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x36,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ngt_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x36,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_ngt_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x37,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_nle_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x18,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nle_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x18,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nle_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x18,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_nle_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x38,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nle_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x38,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nle_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x39,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_nlg_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x14,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nlg_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x14,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nlg_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x14,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_nlg_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x34,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nlg_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x34,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nlg_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x35,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_nlt_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x1c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nlt_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x1c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nlt_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x1c,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_nlt_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x3c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nlt_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x3c,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_nlt_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x3d,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_o_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x0e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_o_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x0e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_o_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x0e,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_o_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x2e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_o_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x2e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_o_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x2f,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_t_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x1e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_t_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x1e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_t_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x1e,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_t_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x3e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_t_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x3e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_t_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x3f,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_t_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x8e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_t_i32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x8e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_t_i32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x8f,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_t_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x9e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_t_u32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x9e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_t_u32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x9f,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_tru_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x1e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_tru_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x1e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_tru_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x1e,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_tru_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x3e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_tru_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x3e,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_tru_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x3f,0x7d,0xff,0x00,0x00,0x00]

v_cmpx_u_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x10,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_u_f16 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x10,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_u_f16 v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x10,0x7d,0x7f,0x00,0x00,0x00]

v_cmpx_u_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: encoding: [0xe9,0x04,0x30,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_u_f32 v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX11: encoding: [0xea,0x04,0x30,0x7d,0x01,0x77,0x39,0x05]

v_cmpx_u_f32 v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX11: encoding: [0xe9,0xfe,0x31,0x7d,0xff,0x00,0x00,0x00]
