; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zfh \
; RUN:   -verify-machineinstrs -target-abi ilp32f | \
; RUN:   FileCheck -check-prefixes=CHECKIZFH,RV32IZFH,RV32IFZFH %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zfh \
; RUN:   -verify-machineinstrs -target-abi lp64f | \
; RUN:   FileCheck -check-prefixes=CHECKIZFH,RV64IZFH,RV64IFZFH %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zhinx \
; RUN:   -verify-machineinstrs -target-abi ilp32 | \
; RUN:   FileCheck -check-prefixes=CHECKIZHINX,RV32IZHINX %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zhinx \
; RUN:   -verify-machineinstrs -target-abi lp64 | \
; RUN:   FileCheck -check-prefixes=CHECKIZHINX,RV64IZHINX %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+d \
; RUN:   -mattr=+zfh -verify-machineinstrs -target-abi ilp32d | \
; RUN:   FileCheck -check-prefixes=CHECKIZFH,RV32IZFH,RV32IDZFH %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+d \
; RUN:   -mattr=+zfh -verify-machineinstrs -target-abi lp64d | \
; RUN:   FileCheck -check-prefixes=CHECKIZFH,RV64IZFH,RV64IDZFH %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zdinx \
; RUN:   -mattr=+zhinx -verify-machineinstrs -target-abi ilp32 | \
; RUN:   FileCheck -check-prefixes=CHECKIZHINX,RV32IZHINX %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zdinx \
; RUN:   -mattr=+zhinx -verify-machineinstrs -target-abi lp64 | \
; RUN:   FileCheck -check-prefixes=CHECKIZHINX,RV64IZHINX %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 \
; RUN:   -verify-machineinstrs | \
; RUN:   FileCheck -check-prefix=RV32I %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 \
; RUN:   -verify-machineinstrs | \
; RUN:   FileCheck -check-prefix=RV64I %s

; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zfhmin \
; RUN:   -verify-machineinstrs -target-abi ilp32f | \
; RUN:   FileCheck -check-prefixes=CHECKIZFHMIN,RV32IZFHMIN,RV32IFZFHMIN %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zfhmin \
; RUN:   -verify-machineinstrs -target-abi lp64f | \
; RUN:   FileCheck -check-prefixes=CHECKIZFHMIN,RV64IZFHMIN,RV64IFZFHMIN %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+d \
; RUN:   -mattr=+zfhmin -verify-machineinstrs -target-abi ilp32d | \
; RUN:   FileCheck -check-prefixes=CHECKIZFHMIN,RV32IZFHMIN,RV32IDZFHMIN %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+d \
; RUN:   -mattr=+zfhmin -verify-machineinstrs -target-abi lp64d | \
; RUN:   FileCheck -check-prefixes=CHECKIZFHMIN,RV64IZFHMIN,RV64IDZFHMIN %s

; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zhinxmin \
; RUN:   -verify-machineinstrs -target-abi ilp32 | \
; RUN:   FileCheck -check-prefixes=CHECKIZHINXMIN,RV32IZHINXMIN %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zhinxmin \
; RUN:   -verify-machineinstrs -target-abi lp64 | \
; RUN:   FileCheck -check-prefixes=CHECKIZHINXMIN,RV64IZHINXMIN %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zdinx \
; RUN:   -mattr=+zhinxmin -verify-machineinstrs -target-abi ilp32 | \
; RUN:   FileCheck -check-prefixes=CHECKIZHINXMIN,RV32IZHINXMIN %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zdinx \
; RUN:   -mattr=+zhinxmin -verify-machineinstrs -target-abi lp64 | \
; RUN:   FileCheck -check-prefixes=CHECKIZHINXMIN,RV64IZHINXMIN %s

declare half @llvm.sqrt.f16(half)

define half @sqrt_f16(half %a) nounwind {
; CHECKIZFH-LABEL: sqrt_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fsqrt.h fa0, fa0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: sqrt_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fsqrt.h a0, a0
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: sqrt_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call sqrtf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: sqrt_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call sqrtf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: sqrt_f16:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    fsqrt.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: sqrt_f16:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fsqrt.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call half @llvm.sqrt.f16(half %a)
  ret half %1
}

declare half @llvm.powi.f16.i32(half, i32)

define half @powi_f16(half %a, i32 %b) nounwind {
; RV32IZFH-LABEL: powi_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call __powisf2
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: powi_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    sext.w a0, a0
; RV64IZFH-NEXT:    call __powisf2
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: powi_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call __powisf2
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: powi_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    sext.w a1, a1
; RV64IZHINX-NEXT:    call __powisf2
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: powi_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __powisf2
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: powi_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    sext.w a1, s0
; RV64I-NEXT:    call __powisf2
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: powi_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call __powisf2
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: powi_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    sext.w a0, a0
; RV64IZFHMIN-NEXT:    call __powisf2
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: powi_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call __powisf2
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: powi_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    sext.w a1, a1
; RV64IZHINXMIN-NEXT:    call __powisf2
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.powi.f16.i32(half %a, i32 %b)
  ret half %1
}

declare half @llvm.sin.f16(half)

define half @sin_f16(half %a) nounwind {
; RV32IZFH-LABEL: sin_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call sinf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: sin_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call sinf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: sin_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call sinf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: sin_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call sinf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: sin_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call sinf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: sin_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call sinf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: sin_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call sinf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: sin_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call sinf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: sin_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call sinf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: sin_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call sinf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.sin.f16(half %a)
  ret half %1
}

declare half @llvm.cos.f16(half)

define half @cos_f16(half %a) nounwind {
; RV32IZFH-LABEL: cos_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call cosf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: cos_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call cosf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: cos_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call cosf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: cos_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call cosf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: cos_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call cosf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cos_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call cosf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: cos_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call cosf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: cos_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call cosf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: cos_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call cosf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: cos_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call cosf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.cos.f16(half %a)
  ret half %1
}

; The sin+cos combination results in an FSINCOS SelectionDAG node.
define half @sincos_f16(half %a) nounwind {
; RV32IFZFH-LABEL: sincos_f16:
; RV32IFZFH:       # %bb.0:
; RV32IFZFH-NEXT:    addi sp, sp, -16
; RV32IFZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFZFH-NEXT:    fsw fs0, 8(sp) # 4-byte Folded Spill
; RV32IFZFH-NEXT:    fsw fs1, 4(sp) # 4-byte Folded Spill
; RV32IFZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IFZFH-NEXT:    fmv.s fa0, fs0
; RV32IFZFH-NEXT:    call sinf
; RV32IFZFH-NEXT:    fcvt.h.s fs1, fa0
; RV32IFZFH-NEXT:    fmv.s fa0, fs0
; RV32IFZFH-NEXT:    call cosf
; RV32IFZFH-NEXT:    fcvt.h.s fa5, fa0
; RV32IFZFH-NEXT:    fadd.h fa0, fs1, fa5
; RV32IFZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFZFH-NEXT:    flw fs0, 8(sp) # 4-byte Folded Reload
; RV32IFZFH-NEXT:    flw fs1, 4(sp) # 4-byte Folded Reload
; RV32IFZFH-NEXT:    addi sp, sp, 16
; RV32IFZFH-NEXT:    ret
;
; RV64IFZFH-LABEL: sincos_f16:
; RV64IFZFH:       # %bb.0:
; RV64IFZFH-NEXT:    addi sp, sp, -16
; RV64IFZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV64IFZFH-NEXT:    fsw fs1, 0(sp) # 4-byte Folded Spill
; RV64IFZFH-NEXT:    fcvt.s.h fs0, fa0
; RV64IFZFH-NEXT:    fmv.s fa0, fs0
; RV64IFZFH-NEXT:    call sinf
; RV64IFZFH-NEXT:    fcvt.h.s fs1, fa0
; RV64IFZFH-NEXT:    fmv.s fa0, fs0
; RV64IFZFH-NEXT:    call cosf
; RV64IFZFH-NEXT:    fcvt.h.s fa5, fa0
; RV64IFZFH-NEXT:    fadd.h fa0, fs1, fa5
; RV64IFZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV64IFZFH-NEXT:    flw fs1, 0(sp) # 4-byte Folded Reload
; RV64IFZFH-NEXT:    addi sp, sp, 16
; RV64IFZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: sincos_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call sinf
; RV32IZHINX-NEXT:    fcvt.h.s s1, a0
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call cosf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    fadd.h a0, s1, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: sincos_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -32
; RV64IZHINX-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h s0, a0
; RV64IZHINX-NEXT:    mv a0, s0
; RV64IZHINX-NEXT:    call sinf
; RV64IZHINX-NEXT:    fcvt.h.s s1, a0
; RV64IZHINX-NEXT:    mv a0, s0
; RV64IZHINX-NEXT:    call cosf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    fadd.h a0, s1, a0
; RV64IZHINX-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 32
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: sincos_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    addi sp, sp, -32
; RV32IDZFH-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IDZFH-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; RV32IDZFH-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; RV32IDZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IDZFH-NEXT:    fmv.s fa0, fs0
; RV32IDZFH-NEXT:    call sinf
; RV32IDZFH-NEXT:    fcvt.h.s fs1, fa0
; RV32IDZFH-NEXT:    fmv.s fa0, fs0
; RV32IDZFH-NEXT:    call cosf
; RV32IDZFH-NEXT:    fcvt.h.s fa5, fa0
; RV32IDZFH-NEXT:    fadd.h fa0, fs1, fa5
; RV32IDZFH-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IDZFH-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; RV32IDZFH-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; RV32IDZFH-NEXT:    addi sp, sp, 32
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: sincos_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    addi sp, sp, -32
; RV64IDZFH-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64IDZFH-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; RV64IDZFH-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; RV64IDZFH-NEXT:    fcvt.s.h fs0, fa0
; RV64IDZFH-NEXT:    fmv.s fa0, fs0
; RV64IDZFH-NEXT:    call sinf
; RV64IDZFH-NEXT:    fcvt.h.s fs1, fa0
; RV64IDZFH-NEXT:    fmv.s fa0, fs0
; RV64IDZFH-NEXT:    call cosf
; RV64IDZFH-NEXT:    fcvt.h.s fa5, fa0
; RV64IDZFH-NEXT:    fadd.h fa0, fs1, fa5
; RV64IDZFH-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64IDZFH-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; RV64IDZFH-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; RV64IDZFH-NEXT:    addi sp, sp, 32
; RV64IDZFH-NEXT:    ret
;
; RV32I-LABEL: sincos_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi s2, a1, -1
; RV32I-NEXT:    and a0, a0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    call sinf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call cosf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    and a0, s1, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    and a0, s0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: sincos_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addi s2, a1, -1
; RV64I-NEXT:    and a0, a0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    call sinf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call cosf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    and a0, s1, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    and a0, s0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV32IFZFHMIN-LABEL: sincos_f16:
; RV32IFZFHMIN:       # %bb.0:
; RV32IFZFHMIN-NEXT:    addi sp, sp, -16
; RV32IFZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFZFHMIN-NEXT:    fsw fs0, 8(sp) # 4-byte Folded Spill
; RV32IFZFHMIN-NEXT:    fsw fs1, 4(sp) # 4-byte Folded Spill
; RV32IFZFHMIN-NEXT:    fcvt.s.h fs0, fa0
; RV32IFZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IFZFHMIN-NEXT:    call sinf
; RV32IFZFHMIN-NEXT:    fcvt.h.s fs1, fa0
; RV32IFZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IFZFHMIN-NEXT:    call cosf
; RV32IFZFHMIN-NEXT:    fcvt.h.s fa5, fa0
; RV32IFZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IFZFHMIN-NEXT:    fcvt.s.h fa4, fs1
; RV32IFZFHMIN-NEXT:    fadd.s fa5, fa4, fa5
; RV32IFZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV32IFZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFZFHMIN-NEXT:    flw fs0, 8(sp) # 4-byte Folded Reload
; RV32IFZFHMIN-NEXT:    flw fs1, 4(sp) # 4-byte Folded Reload
; RV32IFZFHMIN-NEXT:    addi sp, sp, 16
; RV32IFZFHMIN-NEXT:    ret
;
; RV64IFZFHMIN-LABEL: sincos_f16:
; RV64IFZFHMIN:       # %bb.0:
; RV64IFZFHMIN-NEXT:    addi sp, sp, -16
; RV64IFZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV64IFZFHMIN-NEXT:    fsw fs1, 0(sp) # 4-byte Folded Spill
; RV64IFZFHMIN-NEXT:    fcvt.s.h fs0, fa0
; RV64IFZFHMIN-NEXT:    fmv.s fa0, fs0
; RV64IFZFHMIN-NEXT:    call sinf
; RV64IFZFHMIN-NEXT:    fcvt.h.s fs1, fa0
; RV64IFZFHMIN-NEXT:    fmv.s fa0, fs0
; RV64IFZFHMIN-NEXT:    call cosf
; RV64IFZFHMIN-NEXT:    fcvt.h.s fa5, fa0
; RV64IFZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IFZFHMIN-NEXT:    fcvt.s.h fa4, fs1
; RV64IFZFHMIN-NEXT:    fadd.s fa5, fa4, fa5
; RV64IFZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV64IFZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV64IFZFHMIN-NEXT:    flw fs1, 0(sp) # 4-byte Folded Reload
; RV64IFZFHMIN-NEXT:    addi sp, sp, 16
; RV64IFZFHMIN-NEXT:    ret
;
; RV32IDZFHMIN-LABEL: sincos_f16:
; RV32IDZFHMIN:       # %bb.0:
; RV32IDZFHMIN-NEXT:    addi sp, sp, -32
; RV32IDZFHMIN-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IDZFHMIN-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; RV32IDZFHMIN-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; RV32IDZFHMIN-NEXT:    fcvt.s.h fs0, fa0
; RV32IDZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IDZFHMIN-NEXT:    call sinf
; RV32IDZFHMIN-NEXT:    fcvt.h.s fs1, fa0
; RV32IDZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IDZFHMIN-NEXT:    call cosf
; RV32IDZFHMIN-NEXT:    fcvt.h.s fa5, fa0
; RV32IDZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IDZFHMIN-NEXT:    fcvt.s.h fa4, fs1
; RV32IDZFHMIN-NEXT:    fadd.s fa5, fa4, fa5
; RV32IDZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV32IDZFHMIN-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IDZFHMIN-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; RV32IDZFHMIN-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; RV32IDZFHMIN-NEXT:    addi sp, sp, 32
; RV32IDZFHMIN-NEXT:    ret
;
; RV64IDZFHMIN-LABEL: sincos_f16:
; RV64IDZFHMIN:       # %bb.0:
; RV64IDZFHMIN-NEXT:    addi sp, sp, -32
; RV64IDZFHMIN-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64IDZFHMIN-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; RV64IDZFHMIN-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; RV64IDZFHMIN-NEXT:    fcvt.s.h fs0, fa0
; RV64IDZFHMIN-NEXT:    fmv.s fa0, fs0
; RV64IDZFHMIN-NEXT:    call sinf
; RV64IDZFHMIN-NEXT:    fcvt.h.s fs1, fa0
; RV64IDZFHMIN-NEXT:    fmv.s fa0, fs0
; RV64IDZFHMIN-NEXT:    call cosf
; RV64IDZFHMIN-NEXT:    fcvt.h.s fa5, fa0
; RV64IDZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IDZFHMIN-NEXT:    fcvt.s.h fa4, fs1
; RV64IDZFHMIN-NEXT:    fadd.s fa5, fa4, fa5
; RV64IDZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV64IDZFHMIN-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64IDZFHMIN-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; RV64IDZFHMIN-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; RV64IDZFHMIN-NEXT:    addi sp, sp, 32
; RV64IDZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: sincos_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call sinf
; RV32IZHINXMIN-NEXT:    fcvt.h.s s1, a0
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call cosf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a1, s1
; RV32IZHINXMIN-NEXT:    fadd.s a0, a1, a0
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: sincos_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -32
; RV64IZHINXMIN-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV64IZHINXMIN-NEXT:    mv a0, s0
; RV64IZHINXMIN-NEXT:    call sinf
; RV64IZHINXMIN-NEXT:    fcvt.h.s s1, a0
; RV64IZHINXMIN-NEXT:    mv a0, s0
; RV64IZHINXMIN-NEXT:    call cosf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a1, s1
; RV64IZHINXMIN-NEXT:    fadd.s a0, a1, a0
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 32
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.sin.f16(half %a)
  %2 = call half @llvm.cos.f16(half %a)
  %3 = fadd half %1, %2
  ret half %3
}

declare half @llvm.pow.f16(half, half)

define half @pow_f16(half %a, half %b) nounwind {
; RV32IZFH-LABEL: pow_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    fcvt.s.h fa1, fa1
; RV32IZFH-NEXT:    call powf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: pow_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    fcvt.s.h fa1, fa1
; RV64IZFH-NEXT:    call powf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: pow_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    fcvt.s.h a1, a1
; RV32IZHINX-NEXT:    call powf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: pow_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    fcvt.s.h a1, a1
; RV64IZHINX-NEXT:    call powf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: pow_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi s2, a1, -1
; RV32I-NEXT:    and a0, a0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    and a0, s0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call powf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: pow_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addi s2, a1, -1
; RV64I-NEXT:    and a0, a0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    and a0, s0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call powf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: pow_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    fcvt.s.h fa1, fa1
; RV32IZFHMIN-NEXT:    call powf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: pow_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    fcvt.s.h fa1, fa1
; RV64IZFHMIN-NEXT:    call powf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: pow_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a1, a1
; RV32IZHINXMIN-NEXT:    call powf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: pow_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a1, a1
; RV64IZHINXMIN-NEXT:    call powf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.pow.f16(half %a, half %b)
  ret half %1
}

declare half @llvm.exp.f16(half)

define half @exp_f16(half %a) nounwind {
; RV32IZFH-LABEL: exp_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call expf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: exp_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call expf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: exp_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call expf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: exp_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call expf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: exp_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call expf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: exp_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call expf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: exp_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call expf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: exp_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call expf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: exp_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call expf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: exp_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call expf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.exp.f16(half %a)
  ret half %1
}

declare half @llvm.exp2.f16(half)

define half @exp2_f16(half %a) nounwind {
; RV32IZFH-LABEL: exp2_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call exp2f
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: exp2_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call exp2f
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: exp2_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call exp2f
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: exp2_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call exp2f
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: exp2_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call exp2f
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: exp2_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call exp2f
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: exp2_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call exp2f
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: exp2_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call exp2f
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: exp2_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call exp2f
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: exp2_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call exp2f
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.exp2.f16(half %a)
  ret half %1
}

define half @exp10_f16(half %a) nounwind {
; RV32IZFH-LABEL: exp10_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call exp10f
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: exp10_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call exp10f
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: exp10_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call exp10f
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: exp10_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call exp10f
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: exp10_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call exp10f
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: exp10_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call exp10f
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: exp10_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call exp10f
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: exp10_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call exp10f
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: exp10_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call exp10f
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: exp10_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call exp10f
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.exp10.f16(half %a)
  ret half %1
}

declare half @llvm.log.f16(half)

define half @log_f16(half %a) nounwind {
; RV32IZFH-LABEL: log_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call logf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: log_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call logf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: log_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call logf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: log_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call logf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: log_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call logf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: log_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call logf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: log_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call logf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: log_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call logf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: log_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call logf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: log_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call logf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.log.f16(half %a)
  ret half %1
}

declare half @llvm.log10.f16(half)

define half @log10_f16(half %a) nounwind {
; RV32IZFH-LABEL: log10_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call log10f
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: log10_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call log10f
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: log10_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call log10f
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: log10_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call log10f
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: log10_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call log10f
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: log10_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call log10f
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: log10_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call log10f
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: log10_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call log10f
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: log10_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call log10f
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: log10_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call log10f
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.log10.f16(half %a)
  ret half %1
}

declare half @llvm.log2.f16(half)

define half @log2_f16(half %a) nounwind {
; RV32IZFH-LABEL: log2_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call log2f
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: log2_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call log2f
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: log2_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call log2f
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: log2_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call log2f
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: log2_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call log2f
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: log2_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call log2f
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: log2_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call log2f
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: log2_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call log2f
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: log2_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call log2f
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: log2_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call log2f
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.log2.f16(half %a)
  ret half %1
}

declare half @llvm.fma.f16(half, half, half)

define half @fma_f16(half %a, half %b, half %c) nounwind {
; CHECKIZFH-LABEL: fma_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fma_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fmadd.h a0, a0, a1, a2
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: fma_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a2
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi s3, a1, -1
; RV32I-NEXT:    and a0, a0, s3
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    and a0, s1, s3
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    and a0, s0, s3
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv a2, a0
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call fmaf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fma_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a2
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addi s3, a1, -1
; RV64I-NEXT:    and a0, a0, s3
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    and a0, s1, s3
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    and a0, s0, s3
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv a2, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call fmaf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fma_f16:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa2
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa4, fa1
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa3, fa0
; CHECKIZFHMIN-NEXT:    fmadd.s fa5, fa3, fa4, fa5
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fma_f16:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a2, a2
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fmadd.s a0, a0, a1, a2
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call half @llvm.fma.f16(half %a, half %b, half %c)
  ret half %1
}

declare half @llvm.fmuladd.f16(half, half, half)

define half @fmuladd_f16(half %a, half %b, half %c) nounwind {
; CHECKIZFH-LABEL: fmuladd_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fmuladd_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fmadd.h a0, a0, a1, a2
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: fmuladd_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a2
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi s3, a1, -1
; RV32I-NEXT:    and a0, a0, s3
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    and a0, s1, s3
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    call __mulsf3
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    and a0, s0, s3
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    and a0, s1, s3
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmuladd_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a2
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addi s3, a1, -1
; RV64I-NEXT:    and a0, a0, s3
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    and a0, s1, s3
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __mulsf3
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    and a0, s0, s3
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    and a0, s1, s3
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fmuladd_f16:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa4, fa0
; CHECKIZFHMIN-NEXT:    fmul.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa4, fa2
; CHECKIZFHMIN-NEXT:    fadd.s fa5, fa5, fa4
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fmuladd_f16:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fmul.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a2
; CHECKIZHINXMIN-NEXT:    fadd.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call half @llvm.fmuladd.f16(half %a, half %b, half %c)
  ret half %1
}

declare half @llvm.fabs.f16(half)

define half @fabs_f16(half %a) nounwind {
; CHECKIZFH-LABEL: fabs_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fabs.h fa0, fa0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fabs_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fabs.h a0, a0
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: fabs_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 17
; RV32I-NEXT:    srli a0, a0, 17
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fabs_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 49
; RV64I-NEXT:    srli a0, a0, 49
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: fabs_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fmv.x.h a0, fa0
; RV32IZFHMIN-NEXT:    slli a0, a0, 17
; RV32IZFHMIN-NEXT:    srli a0, a0, 17
; RV32IZFHMIN-NEXT:    fmv.h.x fa0, a0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: fabs_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fmv.x.h a0, fa0
; RV64IZFHMIN-NEXT:    slli a0, a0, 49
; RV64IZFHMIN-NEXT:    srli a0, a0, 49
; RV64IZFHMIN-NEXT:    fmv.h.x fa0, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: fabs_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    # kill: def $x10_h killed $x10_h def $x10
; RV32IZHINXMIN-NEXT:    slli a0, a0, 17
; RV32IZHINXMIN-NEXT:    srli a0, a0, 17
; RV32IZHINXMIN-NEXT:    # kill: def $x10_h killed $x10_h killed $x10
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: fabs_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    # kill: def $x10_h killed $x10_h def $x10
; RV64IZHINXMIN-NEXT:    slli a0, a0, 49
; RV64IZHINXMIN-NEXT:    srli a0, a0, 49
; RV64IZHINXMIN-NEXT:    # kill: def $x10_h killed $x10_h killed $x10
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.fabs.f16(half %a)
  ret half %1
}

declare half @llvm.minnum.f16(half, half)

define half @minnum_f16(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: minnum_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fmin.h fa0, fa0, fa1
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: minnum_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fmin.h a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: minnum_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi s2, a1, -1
; RV32I-NEXT:    and a0, a0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    and a0, s0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call fminf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: minnum_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addi s2, a1, -1
; RV64I-NEXT:    and a0, a0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    and a0, s0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call fminf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: minnum_f16:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa4, fa0
; CHECKIZFHMIN-NEXT:    fmin.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: minnum_f16:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fmin.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call half @llvm.minnum.f16(half %a, half %b)
  ret half %1
}

declare half @llvm.maxnum.f16(half, half)

define half @maxnum_f16(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: maxnum_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fmax.h fa0, fa0, fa1
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: maxnum_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fmax.h a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: maxnum_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi s2, a1, -1
; RV32I-NEXT:    and a0, a0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    and a0, s0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call fmaxf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: maxnum_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addi s2, a1, -1
; RV64I-NEXT:    and a0, a0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    and a0, s0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call fmaxf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: maxnum_f16:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa4, fa0
; CHECKIZFHMIN-NEXT:    fmax.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: maxnum_f16:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fmax.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call half @llvm.maxnum.f16(half %a, half %b)
  ret half %1
}

declare half @llvm.copysign.f16(half, half)

define half @copysign_f16(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: copysign_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fsgnj.h fa0, fa0, fa1
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: copysign_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fsgnj.h a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: copysign_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 1048568
; RV32I-NEXT:    slli a0, a0, 17
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 17
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: copysign_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a2, 1048568
; RV64I-NEXT:    slli a0, a0, 49
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    srli a0, a0, 49
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: copysign_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fmv.x.h a0, fa1
; RV32IZFHMIN-NEXT:    lui a1, 1048568
; RV32IZFHMIN-NEXT:    and a0, a0, a1
; RV32IZFHMIN-NEXT:    fmv.x.h a1, fa0
; RV32IZFHMIN-NEXT:    slli a1, a1, 17
; RV32IZFHMIN-NEXT:    srli a1, a1, 17
; RV32IZFHMIN-NEXT:    or a0, a1, a0
; RV32IZFHMIN-NEXT:    fmv.h.x fa0, a0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: copysign_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fmv.x.h a0, fa1
; RV64IZFHMIN-NEXT:    lui a1, 1048568
; RV64IZFHMIN-NEXT:    and a0, a0, a1
; RV64IZFHMIN-NEXT:    fmv.x.h a1, fa0
; RV64IZFHMIN-NEXT:    slli a1, a1, 49
; RV64IZFHMIN-NEXT:    srli a1, a1, 49
; RV64IZFHMIN-NEXT:    or a0, a1, a0
; RV64IZFHMIN-NEXT:    fmv.h.x fa0, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: copysign_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    # kill: def $x11_h killed $x11_h def $x11
; RV32IZHINXMIN-NEXT:    # kill: def $x10_h killed $x10_h def $x10
; RV32IZHINXMIN-NEXT:    lui a2, 1048568
; RV32IZHINXMIN-NEXT:    slli a0, a0, 17
; RV32IZHINXMIN-NEXT:    and a1, a1, a2
; RV32IZHINXMIN-NEXT:    srli a0, a0, 17
; RV32IZHINXMIN-NEXT:    or a0, a0, a1
; RV32IZHINXMIN-NEXT:    # kill: def $x10_h killed $x10_h killed $x10
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: copysign_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    # kill: def $x11_h killed $x11_h def $x11
; RV64IZHINXMIN-NEXT:    # kill: def $x10_h killed $x10_h def $x10
; RV64IZHINXMIN-NEXT:    lui a2, 1048568
; RV64IZHINXMIN-NEXT:    slli a0, a0, 49
; RV64IZHINXMIN-NEXT:    and a1, a1, a2
; RV64IZHINXMIN-NEXT:    srli a0, a0, 49
; RV64IZHINXMIN-NEXT:    or a0, a0, a1
; RV64IZHINXMIN-NEXT:    # kill: def $x10_h killed $x10_h killed $x10
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.copysign.f16(half %a, half %b)
  ret half %1
}

declare half @llvm.floor.f16(half)

define half @floor_f16(half %a) nounwind {
; CHECKIZFH-LABEL: floor_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    lui a0, %hi(.LCPI18_0)
; CHECKIZFH-NEXT:    flh fa5, %lo(.LCPI18_0)(a0)
; CHECKIZFH-NEXT:    fabs.h fa4, fa0
; CHECKIZFH-NEXT:    flt.h a0, fa4, fa5
; CHECKIZFH-NEXT:    beqz a0, .LBB18_2
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; CHECKIZFH-NEXT:    fcvt.h.w fa5, a0, rdn
; CHECKIZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; CHECKIZFH-NEXT:  .LBB18_2:
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: floor_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB18_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB18_2:
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: floor_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call floorf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: floor_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call floorf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: floor_f16:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB18_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB18_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: floor_f16:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB18_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB18_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call half @llvm.floor.f16(half %a)
  ret half %1
}

declare half @llvm.ceil.f16(half)

define half @ceil_f16(half %a) nounwind {
; CHECKIZFH-LABEL: ceil_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    lui a0, %hi(.LCPI19_0)
; CHECKIZFH-NEXT:    flh fa5, %lo(.LCPI19_0)(a0)
; CHECKIZFH-NEXT:    fabs.h fa4, fa0
; CHECKIZFH-NEXT:    flt.h a0, fa4, fa5
; CHECKIZFH-NEXT:    beqz a0, .LBB19_2
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rup
; CHECKIZFH-NEXT:    fcvt.h.w fa5, a0, rup
; CHECKIZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; CHECKIZFH-NEXT:  .LBB19_2:
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: ceil_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB19_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rup
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rup
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB19_2:
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: ceil_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call ceilf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ceil_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call ceilf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: ceil_f16:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB19_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB19_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: ceil_f16:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB19_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB19_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call half @llvm.ceil.f16(half %a)
  ret half %1
}

declare half @llvm.trunc.f16(half)

define half @trunc_f16(half %a) nounwind {
; CHECKIZFH-LABEL: trunc_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    lui a0, %hi(.LCPI20_0)
; CHECKIZFH-NEXT:    flh fa5, %lo(.LCPI20_0)(a0)
; CHECKIZFH-NEXT:    fabs.h fa4, fa0
; CHECKIZFH-NEXT:    flt.h a0, fa4, fa5
; CHECKIZFH-NEXT:    beqz a0, .LBB20_2
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; CHECKIZFH-NEXT:    fcvt.h.w fa5, a0, rtz
; CHECKIZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; CHECKIZFH-NEXT:  .LBB20_2:
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: trunc_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB20_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB20_2:
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: trunc_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call truncf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: trunc_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call truncf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: trunc_f16:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB20_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB20_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: trunc_f16:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB20_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB20_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call half @llvm.trunc.f16(half %a)
  ret half %1
}

declare half @llvm.rint.f16(half)

define half @rint_f16(half %a) nounwind {
; CHECKIZFH-LABEL: rint_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    lui a0, %hi(.LCPI21_0)
; CHECKIZFH-NEXT:    flh fa5, %lo(.LCPI21_0)(a0)
; CHECKIZFH-NEXT:    fabs.h fa4, fa0
; CHECKIZFH-NEXT:    flt.h a0, fa4, fa5
; CHECKIZFH-NEXT:    beqz a0, .LBB21_2
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0
; CHECKIZFH-NEXT:    fcvt.h.w fa5, a0
; CHECKIZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; CHECKIZFH-NEXT:  .LBB21_2:
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: rint_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB21_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB21_2:
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: rint_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call rintf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rint_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call rintf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: rint_f16:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB21_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB21_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: rint_f16:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB21_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB21_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call half @llvm.rint.f16(half %a)
  ret half %1
}

declare half @llvm.nearbyint.f16(half)

define half @nearbyint_f16(half %a) nounwind {
; RV32IZFH-LABEL: nearbyint_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call nearbyintf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: nearbyint_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call nearbyintf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: nearbyint_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call nearbyintf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: nearbyint_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call nearbyintf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: nearbyint_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call nearbyintf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: nearbyint_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call nearbyintf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: nearbyint_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call nearbyintf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: nearbyint_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call nearbyintf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: nearbyint_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call nearbyintf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: nearbyint_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call nearbyintf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.nearbyint.f16(half %a)
  ret half %1
}

declare half @llvm.round.f16(half)

define half @round_f16(half %a) nounwind {
; CHECKIZFH-LABEL: round_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    lui a0, %hi(.LCPI23_0)
; CHECKIZFH-NEXT:    flh fa5, %lo(.LCPI23_0)(a0)
; CHECKIZFH-NEXT:    fabs.h fa4, fa0
; CHECKIZFH-NEXT:    flt.h a0, fa4, fa5
; CHECKIZFH-NEXT:    beqz a0, .LBB23_2
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; CHECKIZFH-NEXT:    fcvt.h.w fa5, a0, rmm
; CHECKIZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; CHECKIZFH-NEXT:  .LBB23_2:
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: round_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB23_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB23_2:
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: round_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call roundf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: round_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call roundf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: round_f16:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB23_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB23_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: round_f16:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB23_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB23_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call half @llvm.round.f16(half %a)
  ret half %1
}

declare half @llvm.roundeven.f16(half)

define half @roundeven_f16(half %a) nounwind {
; CHECKIZFH-LABEL: roundeven_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    lui a0, %hi(.LCPI24_0)
; CHECKIZFH-NEXT:    flh fa5, %lo(.LCPI24_0)(a0)
; CHECKIZFH-NEXT:    fabs.h fa4, fa0
; CHECKIZFH-NEXT:    flt.h a0, fa4, fa5
; CHECKIZFH-NEXT:    beqz a0, .LBB24_2
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rne
; CHECKIZFH-NEXT:    fcvt.h.w fa5, a0, rne
; CHECKIZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; CHECKIZFH-NEXT:  .LBB24_2:
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: roundeven_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB24_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rne
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rne
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB24_2:
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: roundeven_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call roundevenf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: roundeven_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call roundevenf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: roundeven_f16:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB24_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB24_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: roundeven_f16:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB24_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB24_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call half @llvm.roundeven.f16(half %a)
  ret half %1
}

declare i1 @llvm.is.fpclass.f16(half, i32)
define i1 @isnan_d_fpclass(half %x) {
; CHECKIZFH-LABEL: isnan_d_fpclass:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fclass.h a0, fa0
; CHECKIZFH-NEXT:    andi a0, a0, 768
; CHECKIZFH-NEXT:    snez a0, a0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: isnan_d_fpclass:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fclass.h a0, a0
; CHECKIZHINX-NEXT:    andi a0, a0, 768
; CHECKIZHINX-NEXT:    snez a0, a0
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: isnan_d_fpclass:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 17
; RV32I-NEXT:    li a1, 31
; RV32I-NEXT:    srli a0, a0, 17
; RV32I-NEXT:    slli a1, a1, 10
; RV32I-NEXT:    slt a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: isnan_d_fpclass:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 49
; RV64I-NEXT:    li a1, 31
; RV64I-NEXT:    srli a0, a0, 49
; RV64I-NEXT:    slli a1, a1, 10
; RV64I-NEXT:    slt a0, a1, a0
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: isnan_d_fpclass:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fmv.x.h a0, fa0
; RV32IZFHMIN-NEXT:    li a1, 31
; RV32IZFHMIN-NEXT:    slli a0, a0, 17
; RV32IZFHMIN-NEXT:    srli a0, a0, 17
; RV32IZFHMIN-NEXT:    slli a1, a1, 10
; RV32IZFHMIN-NEXT:    slt a0, a1, a0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: isnan_d_fpclass:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fmv.x.h a0, fa0
; RV64IZFHMIN-NEXT:    li a1, 31
; RV64IZFHMIN-NEXT:    slli a0, a0, 49
; RV64IZFHMIN-NEXT:    srli a0, a0, 49
; RV64IZFHMIN-NEXT:    slli a1, a1, 10
; RV64IZFHMIN-NEXT:    slt a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: isnan_d_fpclass:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    # kill: def $x10_h killed $x10_h def $x10
; RV32IZHINXMIN-NEXT:    slli a0, a0, 17
; RV32IZHINXMIN-NEXT:    li a1, 31
; RV32IZHINXMIN-NEXT:    srli a0, a0, 17
; RV32IZHINXMIN-NEXT:    slli a1, a1, 10
; RV32IZHINXMIN-NEXT:    slt a0, a1, a0
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: isnan_d_fpclass:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    # kill: def $x10_h killed $x10_h def $x10
; RV64IZHINXMIN-NEXT:    slli a0, a0, 49
; RV64IZHINXMIN-NEXT:    li a1, 31
; RV64IZHINXMIN-NEXT:    srli a0, a0, 49
; RV64IZHINXMIN-NEXT:    slli a1, a1, 10
; RV64IZHINXMIN-NEXT:    slt a0, a1, a0
; RV64IZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.is.fpclass.f16(half %x, i32 3)  ; nan
  ret i1 %1
}

declare half @llvm.tan.f16(half)

define half @tan_f16(half %a) nounwind {
; RV32IZFH-LABEL: tan_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call tanf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: tan_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call tanf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: tan_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call tanf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: tan_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call tanf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: tan_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call tanf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: tan_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call tanf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: tan_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call tanf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: tan_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call tanf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: tan_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call tanf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: tan_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call tanf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.tan.f16(half %a)
  ret half %1
}

declare half @llvm.maximumnum.f16(half, half)

define half @maximumnum_half(half %x, half %y) {
; CHECKIZFH-LABEL: maximumnum_half:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fmax.h fa0, fa0, fa1
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: maximumnum_half:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fmax.h a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: maximumnum_half:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    .cfi_offset s0, -8
; RV32I-NEXT:    .cfi_offset s1, -12
; RV32I-NEXT:    .cfi_offset s2, -16
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi s2, a1, -1
; RV32I-NEXT:    and a0, a0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    and a0, s0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call fmaximum_numf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    .cfi_restore s0
; RV32I-NEXT:    .cfi_restore s1
; RV32I-NEXT:    .cfi_restore s2
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: maximumnum_half:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    .cfi_def_cfa_offset 32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    .cfi_offset s0, -16
; RV64I-NEXT:    .cfi_offset s1, -24
; RV64I-NEXT:    .cfi_offset s2, -32
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addi s2, a1, -1
; RV64I-NEXT:    and a0, a0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    and a0, s0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call fmaximum_numf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    .cfi_restore s0
; RV64I-NEXT:    .cfi_restore s1
; RV64I-NEXT:    .cfi_restore s2
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: maximumnum_half:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa4, fa0
; CHECKIZFHMIN-NEXT:    fmax.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: maximumnum_half:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fmax.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %z = call half @llvm.maximumnum.f16(half %x, half %y)
  ret half %z
}

declare half @llvm.minimumnum.f16(half, half)

define half @minimumnum_half(half %x, half %y) {
; CHECKIZFH-LABEL: minimumnum_half:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fmin.h fa0, fa0, fa1
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: minimumnum_half:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fmin.h a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; RV32I-LABEL: minimumnum_half:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    .cfi_offset s0, -8
; RV32I-NEXT:    .cfi_offset s1, -12
; RV32I-NEXT:    .cfi_offset s2, -16
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi s2, a1, -1
; RV32I-NEXT:    and a0, a0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    and a0, s0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call fminimum_numf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    .cfi_restore s0
; RV32I-NEXT:    .cfi_restore s1
; RV32I-NEXT:    .cfi_restore s2
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: minimumnum_half:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    .cfi_def_cfa_offset 32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    .cfi_offset s0, -16
; RV64I-NEXT:    .cfi_offset s1, -24
; RV64I-NEXT:    .cfi_offset s2, -32
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addi s2, a1, -1
; RV64I-NEXT:    and a0, a0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    and a0, s0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call fminimum_numf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    .cfi_restore s0
; RV64I-NEXT:    .cfi_restore s1
; RV64I-NEXT:    .cfi_restore s2
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: minimumnum_half:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa4, fa0
; CHECKIZFHMIN-NEXT:    fmin.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: minimumnum_half:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fmin.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %z = call half @llvm.minimumnum.f16(half %x, half %y)
  ret half %z
}

define half @ldexp_half(half %x, i32 signext %y) nounwind {
; RV32IZFH-LABEL: ldexp_half:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call ldexpf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: ldexp_half:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call ldexpf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: ldexp_half:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call ldexpf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: ldexp_half:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call ldexpf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: ldexp_half:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call ldexpf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ldexp_half:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call ldexpf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: ldexp_half:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call ldexpf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: ldexp_half:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call ldexpf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: ldexp_half:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call ldexpf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: ldexp_half:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call ldexpf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %z = call half @llvm.ldexp.f16.i32(half %x, i32 %y)
  ret half %z
}

define {half, i32} @frexp_half(half %x) nounwind {
; RV32IZFH-LABEL: frexp_half:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    addi a0, sp, 8
; RV32IZFH-NEXT:    call frexpf
; RV32IZFH-NEXT:    lw a0, 8(sp)
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: frexp_half:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    mv a0, sp
; RV64IZFH-NEXT:    call frexpf
; RV64IZFH-NEXT:    ld a0, 0(sp)
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: frexp_half:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    addi a1, sp, 8
; RV32IZHINX-NEXT:    call frexpf
; RV32IZHINX-NEXT:    lw a1, 8(sp)
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: frexp_half:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    mv a1, sp
; RV64IZHINX-NEXT:    call frexpf
; RV64IZHINX-NEXT:    ld a1, 0(sp)
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: frexp_half:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    call frexpf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw a1, 8(sp)
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: frexp_half:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    addi a1, sp, 4
; RV64I-NEXT:    call frexpf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    lw a1, 4(sp)
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: frexp_half:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    addi a0, sp, 8
; RV32IZFHMIN-NEXT:    call frexpf
; RV32IZFHMIN-NEXT:    lw a0, 8(sp)
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: frexp_half:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    mv a0, sp
; RV64IZFHMIN-NEXT:    call frexpf
; RV64IZFHMIN-NEXT:    ld a0, 0(sp)
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: frexp_half:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    addi a1, sp, 8
; RV32IZHINXMIN-NEXT:    call frexpf
; RV32IZHINXMIN-NEXT:    lw a1, 8(sp)
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: frexp_half:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    mv a1, sp
; RV64IZHINXMIN-NEXT:    call frexpf
; RV64IZHINXMIN-NEXT:    ld a1, 0(sp)
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %a = call {half, i32} @llvm.frexp.f16.i32(half %x)
  ret {half, i32} %a
}

define half @asin_f16(half %a) nounwind {
; RV32IZFH-LABEL: asin_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call asinf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: asin_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call asinf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: asin_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call asinf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: asin_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call asinf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: asin_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call asinf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: asin_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call asinf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: asin_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call asinf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: asin_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call asinf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: asin_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call asinf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: asin_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call asinf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.asin.f16(half %a)
  ret half %1
}

define half @acos_f16(half %a) nounwind {
; RV32IZFH-LABEL: acos_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call acosf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: acos_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call acosf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: acos_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call acosf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: acos_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call acosf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: acos_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call acosf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: acos_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call acosf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: acos_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call acosf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: acos_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call acosf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: acos_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call acosf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: acos_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call acosf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.acos.f16(half %a)
  ret half %1
}

define half @atan_f16(half %a) nounwind {
; RV32IZFH-LABEL: atan_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call atanf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: atan_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call atanf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: atan_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call atanf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: atan_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call atanf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: atan_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call atanf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: atan_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call atanf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: atan_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call atanf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: atan_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call atanf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: atan_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call atanf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: atan_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call atanf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.atan.f16(half %a)
  ret half %1
}

define half @atan2_f16(half %a, half %b) nounwind {
; RV32IZFH-LABEL: atan2_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    fcvt.s.h fa1, fa1
; RV32IZFH-NEXT:    call atan2f
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: atan2_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    fcvt.s.h fa1, fa1
; RV64IZFH-NEXT:    call atan2f
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: atan2_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    fcvt.s.h a1, a1
; RV32IZHINX-NEXT:    call atan2f
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: atan2_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    fcvt.s.h a1, a1
; RV64IZHINX-NEXT:    call atan2f
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: atan2_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi s2, a1, -1
; RV32I-NEXT:    and a0, a0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    and a0, s0, s2
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call atan2f
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: atan2_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addi s2, a1, -1
; RV64I-NEXT:    and a0, a0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    and a0, s0, s2
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call atan2f
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: atan2_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    fcvt.s.h fa1, fa1
; RV32IZFHMIN-NEXT:    call atan2f
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: atan2_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    fcvt.s.h fa1, fa1
; RV64IZFHMIN-NEXT:    call atan2f
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: atan2_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a1, a1
; RV32IZHINXMIN-NEXT:    call atan2f
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: atan2_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a1, a1
; RV64IZHINXMIN-NEXT:    call atan2f
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.atan2.f16(half %a, half %b)
  ret half %1
}

define half @sinh_f16(half %a) nounwind {
; RV32IZFH-LABEL: sinh_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call sinhf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: sinh_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call sinhf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: sinh_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call sinhf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: sinh_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call sinhf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: sinh_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call sinhf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: sinh_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call sinhf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: sinh_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call sinhf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: sinh_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call sinhf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: sinh_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call sinhf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: sinh_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call sinhf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.sinh.f16(half %a)
  ret half %1
}

define half @cosh_f16(half %a) nounwind {
; RV32IZFH-LABEL: cosh_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call coshf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: cosh_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call coshf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: cosh_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call coshf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: cosh_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call coshf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: cosh_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call coshf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cosh_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call coshf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: cosh_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call coshf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: cosh_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call coshf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: cosh_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call coshf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: cosh_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call coshf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.cosh.f16(half %a)
  ret half %1
}

define half @tanh_f16(half %a) nounwind {
; RV32IZFH-LABEL: tanh_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call tanhf
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: tanh_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call tanhf
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: tanh_f16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call tanhf
; RV32IZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: tanh_f16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call tanhf
; RV64IZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32I-LABEL: tanh_f16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    call __extendhfsf2
; RV32I-NEXT:    call tanhf
; RV32I-NEXT:    call __truncsfhf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: tanh_f16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    call __extendhfsf2
; RV64I-NEXT:    call tanhf
; RV64I-NEXT:    call __truncsfhf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32IZFHMIN-LABEL: tanh_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFHMIN-NEXT:    call tanhf
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: tanh_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFHMIN-NEXT:    call tanhf
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: tanh_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    call tanhf
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: tanh_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    addi sp, sp, -16
; RV64IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    call tanhf
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINXMIN-NEXT:    addi sp, sp, 16
; RV64IZHINXMIN-NEXT:    ret
  %1 = call half @llvm.tanh.f16(half %a)
  ret half %1
}
