; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=AVX512,AVX512DQ

define i32 @reduce_i64(i32 %arg) {
; SSE2-LABEL: 'reduce_i64'
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.mul.v1i64(<1 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:12 Lat:12 SizeLat:12 for: %V2 = call i64 @llvm.vector.reduce.mul.v2i64(<2 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:22 Lat:22 SizeLat:22 for: %V4 = call i64 @llvm.vector.reduce.mul.v4i64(<4 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:42 Lat:42 SizeLat:42 for: %V8 = call i64 @llvm.vector.reduce.mul.v8i64(<8 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:58 CodeSize:82 Lat:82 SizeLat:82 for: %V16 = call i64 @llvm.vector.reduce.mul.v16i64(<16 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'reduce_i64'
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.mul.v1i64(<1 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:12 Lat:12 SizeLat:12 for: %V2 = call i64 @llvm.vector.reduce.mul.v2i64(<2 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:22 Lat:22 SizeLat:22 for: %V4 = call i64 @llvm.vector.reduce.mul.v4i64(<4 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:42 Lat:42 SizeLat:42 for: %V8 = call i64 @llvm.vector.reduce.mul.v8i64(<8 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:58 CodeSize:82 Lat:82 SizeLat:82 for: %V16 = call i64 @llvm.vector.reduce.mul.v16i64(<16 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'reduce_i64'
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.mul.v1i64(<1 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:12 SizeLat:12 for: %V2 = call i64 @llvm.vector.reduce.mul.v2i64(<2 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:22 Lat:22 SizeLat:22 for: %V4 = call i64 @llvm.vector.reduce.mul.v4i64(<4 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:42 Lat:42 SizeLat:42 for: %V8 = call i64 @llvm.vector.reduce.mul.v8i64(<8 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:50 CodeSize:82 Lat:82 SizeLat:82 for: %V16 = call i64 @llvm.vector.reduce.mul.v16i64(<16 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'reduce_i64'
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.mul.v1i64(<1 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:12 SizeLat:12 for: %V2 = call i64 @llvm.vector.reduce.mul.v2i64(<2 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:23 Lat:23 SizeLat:23 for: %V4 = call i64 @llvm.vector.reduce.mul.v4i64(<4 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:42 Lat:38 SizeLat:43 for: %V8 = call i64 @llvm.vector.reduce.mul.v8i64(<8 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:80 Lat:68 SizeLat:83 for: %V16 = call i64 @llvm.vector.reduce.mul.v16i64(<16 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'reduce_i64'
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.mul.v1i64(<1 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:12 SizeLat:10 for: %V2 = call i64 @llvm.vector.reduce.mul.v2i64(<2 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:19 Lat:23 SizeLat:19 for: %V4 = call i64 @llvm.vector.reduce.mul.v4i64(<4 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:27 Lat:33 SizeLat:32 for: %V8 = call i64 @llvm.vector.reduce.mul.v8i64(<8 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:43 Lat:53 SizeLat:58 for: %V16 = call i64 @llvm.vector.reduce.mul.v16i64(<16 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'reduce_i64'
; AVX512F-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.mul.v1i64(<1 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:14 SizeLat:10 for: %V2 = call i64 @llvm.vector.reduce.mul.v2i64(<2 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:19 Lat:25 SizeLat:19 for: %V4 = call i64 @llvm.vector.reduce.mul.v4i64(<4 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:28 Lat:36 SizeLat:33 for: %V8 = call i64 @llvm.vector.reduce.mul.v8i64(<8 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:36 Lat:45 SizeLat:41 for: %V16 = call i64 @llvm.vector.reduce.mul.v16i64(<16 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'reduce_i64'
; AVX512BW-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.mul.v1i64(<1 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:14 SizeLat:10 for: %V2 = call i64 @llvm.vector.reduce.mul.v2i64(<2 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:19 Lat:25 SizeLat:19 for: %V4 = call i64 @llvm.vector.reduce.mul.v4i64(<4 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:28 Lat:36 SizeLat:33 for: %V8 = call i64 @llvm.vector.reduce.mul.v8i64(<8 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:36 Lat:45 SizeLat:41 for: %V16 = call i64 @llvm.vector.reduce.mul.v16i64(<16 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'reduce_i64'
; AVX512DQ-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.mul.v1i64(<1 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:19 SizeLat:5 for: %V2 = call i64 @llvm.vector.reduce.mul.v2i64(<2 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:35 SizeLat:9 for: %V4 = call i64 @llvm.vector.reduce.mul.v4i64(<4 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:7 Lat:51 SizeLat:13 for: %V8 = call i64 @llvm.vector.reduce.mul.v8i64(<8 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:8 Lat:66 SizeLat:16 for: %V16 = call i64 @llvm.vector.reduce.mul.v16i64(<16 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %V1  = call i64 @llvm.vector.reduce.mul.v1i64(<1 x i64> undef)
  %V2  = call i64 @llvm.vector.reduce.mul.v2i64(<2 x i64> undef)
  %V4  = call i64 @llvm.vector.reduce.mul.v4i64(<4 x i64> undef)
  %V8  = call i64 @llvm.vector.reduce.mul.v8i64(<8 x i64> undef)
  %V16 = call i64 @llvm.vector.reduce.mul.v16i64(<16 x i64> undef)
  ret i32 undef
}

define i32 @reduce_i32(i32 %arg) {
; SSE2-LABEL: 'reduce_i32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:9 Lat:10 SizeLat:9 for: %V2 = call i32 @llvm.vector.reduce.mul.v2i32(<2 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:17 Lat:19 SizeLat:17 for: %V4 = call i32 @llvm.vector.reduce.mul.v4i32(<4 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:24 Lat:27 SizeLat:24 for: %V8 = call i32 @llvm.vector.reduce.mul.v8i32(<8 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:38 Lat:43 SizeLat:38 for: %V16 = call i32 @llvm.vector.reduce.mul.v16i32(<16 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:57 CodeSize:66 Lat:75 SizeLat:66 for: %V32 = call i32 @llvm.vector.reduce.mul.v32i32(<32 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'reduce_i32'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:9 Lat:10 SizeLat:9 for: %V2 = call i32 @llvm.vector.reduce.mul.v2i32(<2 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:17 Lat:19 SizeLat:17 for: %V4 = call i32 @llvm.vector.reduce.mul.v4i32(<4 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:24 Lat:27 SizeLat:24 for: %V8 = call i32 @llvm.vector.reduce.mul.v8i32(<8 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:38 Lat:43 SizeLat:38 for: %V16 = call i32 @llvm.vector.reduce.mul.v16i32(<16 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:57 CodeSize:66 Lat:75 SizeLat:66 for: %V32 = call i32 @llvm.vector.reduce.mul.v32i32(<32 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'reduce_i32'
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:13 SizeLat:3 for: %V2 = call i32 @llvm.vector.reduce.mul.v2i32(<2 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:25 SizeLat:5 for: %V4 = call i32 @llvm.vector.reduce.mul.v4i32(<4 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:6 Lat:36 SizeLat:6 for: %V8 = call i32 @llvm.vector.reduce.mul.v8i32(<8 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:8 Lat:58 SizeLat:8 for: %V16 = call i32 @llvm.vector.reduce.mul.v16i32(<16 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:12 Lat:102 SizeLat:12 for: %V32 = call i32 @llvm.vector.reduce.mul.v32i32(<32 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'reduce_i32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:5 for: %V2 = call i32 @llvm.vector.reduce.mul.v2i32(<2 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:13 SizeLat:9 for: %V4 = call i32 @llvm.vector.reduce.mul.v4i32(<4 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:7 Lat:19 SizeLat:13 for: %V8 = call i32 @llvm.vector.reduce.mul.v8i32(<8 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:12 Lat:27 SizeLat:23 for: %V16 = call i32 @llvm.vector.reduce.mul.v16i32(<16 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:25 CodeSize:22 Lat:43 SizeLat:43 for: %V32 = call i32 @llvm.vector.reduce.mul.v32i32(<32 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'reduce_i32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:12 SizeLat:4 for: %V2 = call i32 @llvm.vector.reduce.mul.v2i32(<2 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:23 SizeLat:7 for: %V4 = call i32 @llvm.vector.reduce.mul.v4i32(<4 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:7 Lat:34 SizeLat:10 for: %V8 = call i32 @llvm.vector.reduce.mul.v8i32(<8 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:8 Lat:44 SizeLat:12 for: %V16 = call i32 @llvm.vector.reduce.mul.v16i32(<16 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:10 Lat:64 SizeLat:16 for: %V32 = call i32 @llvm.vector.reduce.mul.v32i32(<32 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'reduce_i32'
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:14 SizeLat:4 for: %V2 = call i32 @llvm.vector.reduce.mul.v2i32(<2 x i32> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:27 SizeLat:7 for: %V4 = call i32 @llvm.vector.reduce.mul.v4i32(<4 x i32> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:38 SizeLat:10 for: %V8 = call i32 @llvm.vector.reduce.mul.v8i32(<8 x i32> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:49 SizeLat:13 for: %V16 = call i32 @llvm.vector.reduce.mul.v16i32(<16 x i32> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:59 SizeLat:15 for: %V32 = call i32 @llvm.vector.reduce.mul.v32i32(<32 x i32> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %V2  = call i32 @llvm.vector.reduce.mul.v2i32(<2 x i32> undef)
  %V4  = call i32 @llvm.vector.reduce.mul.v4i32(<4 x i32> undef)
  %V8  = call i32 @llvm.vector.reduce.mul.v8i32(<8 x i32> undef)
  %V16 = call i32 @llvm.vector.reduce.mul.v16i32(<16 x i32> undef)
  %V32 = call i32 @llvm.vector.reduce.mul.v32i32(<32 x i32> undef)
  ret i32 undef
}

define i32 @reduce_i16(i32 %arg) {
; SSE-LABEL: 'reduce_i16'
; SSE-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V2 = call i16 @llvm.vector.reduce.mul.v2i16(<2 x i16> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:13 SizeLat:5 for: %V4 = call i16 @llvm.vector.reduce.mul.v4i16(<4 x i16> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:19 SizeLat:7 for: %V8 = call i16 @llvm.vector.reduce.mul.v8i16(<8 x i16> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:24 SizeLat:8 for: %V16 = call i16 @llvm.vector.reduce.mul.v16i16(<16 x i16> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:34 SizeLat:10 for: %V32 = call i16 @llvm.vector.reduce.mul.v32i16(<32 x i16> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:54 SizeLat:14 for: %V64 = call i16 @llvm.vector.reduce.mul.v64i16(<64 x i16> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'reduce_i16'
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:8 SizeLat:3 for: %V2 = call i16 @llvm.vector.reduce.mul.v2i16(<2 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:14 SizeLat:5 for: %V4 = call i16 @llvm.vector.reduce.mul.v4i16(<4 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:20 SizeLat:7 for: %V8 = call i16 @llvm.vector.reduce.mul.v8i16(<8 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:26 SizeLat:9 for: %V16 = call i16 @llvm.vector.reduce.mul.v16i16(<16 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:14 Lat:34 SizeLat:15 for: %V32 = call i16 @llvm.vector.reduce.mul.v32i16(<32 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:24 Lat:50 SizeLat:27 for: %V64 = call i16 @llvm.vector.reduce.mul.v64i16(<64 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'reduce_i16'
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V2 = call i16 @llvm.vector.reduce.mul.v2i16(<2 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:13 SizeLat:5 for: %V4 = call i16 @llvm.vector.reduce.mul.v4i16(<4 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:19 SizeLat:7 for: %V8 = call i16 @llvm.vector.reduce.mul.v8i16(<8 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:25 SizeLat:9 for: %V16 = call i16 @llvm.vector.reduce.mul.v16i16(<16 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:10 Lat:30 SizeLat:11 for: %V32 = call i16 @llvm.vector.reduce.mul.v32i16(<32 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:12 Lat:40 SizeLat:15 for: %V64 = call i16 @llvm.vector.reduce.mul.v64i16(<64 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'reduce_i16'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V2 = call i16 @llvm.vector.reduce.mul.v2i16(<2 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:15 SizeLat:5 for: %V4 = call i16 @llvm.vector.reduce.mul.v4i16(<4 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:23 SizeLat:7 for: %V8 = call i16 @llvm.vector.reduce.mul.v8i16(<8 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:29 SizeLat:9 for: %V16 = call i16 @llvm.vector.reduce.mul.v16i16(<16 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:11 Lat:35 SizeLat:12 for: %V32 = call i16 @llvm.vector.reduce.mul.v32i16(<32 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:12 Lat:36 SizeLat:13 for: %V64 = call i16 @llvm.vector.reduce.mul.v64i16(<64 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'reduce_i16'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V2 = call i16 @llvm.vector.reduce.mul.v2i16(<2 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:15 SizeLat:5 for: %V4 = call i16 @llvm.vector.reduce.mul.v4i16(<4 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:23 SizeLat:7 for: %V8 = call i16 @llvm.vector.reduce.mul.v8i16(<8 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:29 SizeLat:9 for: %V16 = call i16 @llvm.vector.reduce.mul.v16i16(<16 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:11 Lat:35 SizeLat:12 for: %V32 = call i16 @llvm.vector.reduce.mul.v32i16(<32 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:12 Lat:40 SizeLat:13 for: %V64 = call i16 @llvm.vector.reduce.mul.v64i16(<64 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'reduce_i16'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V2 = call i16 @llvm.vector.reduce.mul.v2i16(<2 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:15 SizeLat:5 for: %V4 = call i16 @llvm.vector.reduce.mul.v4i16(<4 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:23 SizeLat:7 for: %V8 = call i16 @llvm.vector.reduce.mul.v8i16(<8 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:29 SizeLat:9 for: %V16 = call i16 @llvm.vector.reduce.mul.v16i16(<16 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:11 Lat:35 SizeLat:12 for: %V32 = call i16 @llvm.vector.reduce.mul.v32i16(<32 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:12 Lat:36 SizeLat:13 for: %V64 = call i16 @llvm.vector.reduce.mul.v64i16(<64 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %V2  = call i16 @llvm.vector.reduce.mul.v2i16(<2 x i16> undef)
  %V4  = call i16 @llvm.vector.reduce.mul.v4i16(<4 x i16> undef)
  %V8  = call i16 @llvm.vector.reduce.mul.v8i16(<8 x i16> undef)
  %V16 = call i16 @llvm.vector.reduce.mul.v16i16(<16 x i16> undef)
  %V32 = call i16 @llvm.vector.reduce.mul.v32i16(<32 x i16> undef)
  %V64 = call i16 @llvm.vector.reduce.mul.v64i16(<64 x i16> undef)
  ret i32 undef
}

define i32 @reduce_i8(i32 %arg) {
; SSE-LABEL: 'reduce_i8'
; SSE-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V2 = call i8 @llvm.vector.reduce.mul.v2i8(<2 x i8> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:14 SizeLat:6 for: %V4 = call i8 @llvm.vector.reduce.mul.v4i8(<4 x i8> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:20 SizeLat:8 for: %V8 = call i8 @llvm.vector.reduce.mul.v8i8(<8 x i8> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:26 SizeLat:10 for: %V16 = call i8 @llvm.vector.reduce.mul.v16i8(<16 x i8> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:38 SizeLat:14 for: %V32 = call i8 @llvm.vector.reduce.mul.v32i8(<32 x i8> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:22 Lat:62 SizeLat:22 for: %V64 = call i8 @llvm.vector.reduce.mul.v64i8(<64 x i8> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:38 Lat:110 SizeLat:38 for: %V128 = call i8 @llvm.vector.reduce.mul.v128i8(<128 x i8> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'reduce_i8'
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:9 SizeLat:4 for: %V2 = call i8 @llvm.vector.reduce.mul.v2i8(<2 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:15 SizeLat:6 for: %V4 = call i8 @llvm.vector.reduce.mul.v4i8(<4 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:21 SizeLat:8 for: %V8 = call i8 @llvm.vector.reduce.mul.v8i8(<8 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:10 Lat:27 SizeLat:10 for: %V16 = call i8 @llvm.vector.reduce.mul.v16i8(<16 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:15 Lat:35 SizeLat:16 for: %V32 = call i8 @llvm.vector.reduce.mul.v32i8(<32 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:35 CodeSize:25 Lat:51 SizeLat:28 for: %V64 = call i8 @llvm.vector.reduce.mul.v64i8(<64 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:65 CodeSize:45 Lat:83 SizeLat:52 for: %V128 = call i8 @llvm.vector.reduce.mul.v128i8(<128 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'reduce_i8'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V2 = call i8 @llvm.vector.reduce.mul.v2i8(<2 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:14 SizeLat:6 for: %V4 = call i8 @llvm.vector.reduce.mul.v4i8(<4 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:20 SizeLat:8 for: %V8 = call i8 @llvm.vector.reduce.mul.v8i8(<8 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:10 Lat:26 SizeLat:10 for: %V16 = call i8 @llvm.vector.reduce.mul.v16i8(<16 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:11 Lat:31 SizeLat:12 for: %V32 = call i8 @llvm.vector.reduce.mul.v32i8(<32 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:25 CodeSize:13 Lat:41 SizeLat:16 for: %V64 = call i8 @llvm.vector.reduce.mul.v64i8(<64 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:17 Lat:61 SizeLat:24 for: %V128 = call i8 @llvm.vector.reduce.mul.v128i8(<128 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'reduce_i8'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V2 = call i8 @llvm.vector.reduce.mul.v2i8(<2 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:16 SizeLat:6 for: %V4 = call i8 @llvm.vector.reduce.mul.v4i8(<4 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:24 SizeLat:8 for: %V8 = call i8 @llvm.vector.reduce.mul.v8i8(<8 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:30 SizeLat:10 for: %V16 = call i8 @llvm.vector.reduce.mul.v16i8(<16 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:12 Lat:36 SizeLat:13 for: %V32 = call i8 @llvm.vector.reduce.mul.v32i8(<32 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:13 Lat:37 SizeLat:14 for: %V64 = call i8 @llvm.vector.reduce.mul.v64i8(<64 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:15 Lat:39 SizeLat:16 for: %V128 = call i8 @llvm.vector.reduce.mul.v128i8(<128 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'reduce_i8'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V2 = call i8 @llvm.vector.reduce.mul.v2i8(<2 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:16 SizeLat:6 for: %V4 = call i8 @llvm.vector.reduce.mul.v4i8(<4 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:24 SizeLat:8 for: %V8 = call i8 @llvm.vector.reduce.mul.v8i8(<8 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:30 SizeLat:10 for: %V16 = call i8 @llvm.vector.reduce.mul.v16i8(<16 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:12 Lat:36 SizeLat:13 for: %V32 = call i8 @llvm.vector.reduce.mul.v32i8(<32 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:13 Lat:41 SizeLat:14 for: %V64 = call i8 @llvm.vector.reduce.mul.v64i8(<64 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:15 Lat:51 SizeLat:16 for: %V128 = call i8 @llvm.vector.reduce.mul.v128i8(<128 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'reduce_i8'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V2 = call i8 @llvm.vector.reduce.mul.v2i8(<2 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:16 SizeLat:6 for: %V4 = call i8 @llvm.vector.reduce.mul.v4i8(<4 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:24 SizeLat:8 for: %V8 = call i8 @llvm.vector.reduce.mul.v8i8(<8 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:30 SizeLat:10 for: %V16 = call i8 @llvm.vector.reduce.mul.v16i8(<16 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:12 Lat:36 SizeLat:13 for: %V32 = call i8 @llvm.vector.reduce.mul.v32i8(<32 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:13 Lat:37 SizeLat:14 for: %V64 = call i8 @llvm.vector.reduce.mul.v64i8(<64 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:15 Lat:39 SizeLat:16 for: %V128 = call i8 @llvm.vector.reduce.mul.v128i8(<128 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %V2   = call i8 @llvm.vector.reduce.mul.v2i8(<2 x i8> undef)
  %V4   = call i8 @llvm.vector.reduce.mul.v4i8(<4 x i8> undef)
  %V8   = call i8 @llvm.vector.reduce.mul.v8i8(<8 x i8> undef)
  %V16  = call i8 @llvm.vector.reduce.mul.v16i8(<16 x i8> undef)
  %V32  = call i8 @llvm.vector.reduce.mul.v32i8(<32 x i8> undef)
  %V64  = call i8 @llvm.vector.reduce.mul.v64i8(<64 x i8> undef)
  %V128 = call i8 @llvm.vector.reduce.mul.v128i8(<128 x i8> undef)
  ret i32 undef
}

declare i64 @llvm.vector.reduce.mul.v1i64(<1 x i64>)
declare i64 @llvm.vector.reduce.mul.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.mul.v4i64(<4 x i64>)
declare i64 @llvm.vector.reduce.mul.v8i64(<8 x i64>)
declare i64 @llvm.vector.reduce.mul.v16i64(<16 x i64>)

declare i32 @llvm.vector.reduce.mul.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.mul.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.mul.v8i32(<8 x i32>)
declare i32 @llvm.vector.reduce.mul.v16i32(<16 x i32>)
declare i32 @llvm.vector.reduce.mul.v32i32(<32 x i32>)

declare i16 @llvm.vector.reduce.mul.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.mul.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.mul.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.mul.v16i16(<16 x i16>)
declare i16 @llvm.vector.reduce.mul.v32i16(<32 x i16>)
declare i16 @llvm.vector.reduce.mul.v64i16(<64 x i16>)

declare i8 @llvm.vector.reduce.mul.v2i8(<2 x i8>)
declare i8 @llvm.vector.reduce.mul.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.mul.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.mul.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.mul.v32i8(<32 x i8>)
declare i8 @llvm.vector.reduce.mul.v64i8(<64 x i8>)
declare i8 @llvm.vector.reduce.mul.v128i8(<128 x i8>)
