; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=armv7-eabi < %s | FileCheck %s

define float @trunc_unsigned_f32(float %x) nounwind {
; CHECK-LABEL: trunc_unsigned_f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvt.u32.f32 s0, s0
; CHECK-NEXT:    vcvt.f32.u32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    bx lr
  %i = fptoui float %x to i32
  %r = uitofp i32 %i to float
  ret float %r
}

define double @trunc_unsigned_f64_i64(double %x) nounwind {
; CHECK-LABEL: trunc_unsigned_f64_i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    bl __aeabi_d2ulz
; CHECK-NEXT:    bl __aeabi_ul2d
; CHECK-NEXT:    pop {r11, pc}
  %i = fptoui double %x to i64
  %r = uitofp i64 %i to double
  ret double %r
}

define double @trunc_unsigned_f64_i32(double %x) nounwind {
; CHECK-LABEL: trunc_unsigned_f64_i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov d16, r0, r1
; CHECK-NEXT:    vcvt.u32.f64 s0, d16
; CHECK-NEXT:    vcvt.f64.u32 d16, s0
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    bx lr
  %i = fptoui double %x to i32
  %r = uitofp i32 %i to double
  ret double %r
}

