; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=x86_64-unknown-unknown --show-mc-encoding -mattr=+raoint | FileCheck %s --check-prefixes=X64
; RUN: llc < %s -verify-machineinstrs -mtriple=x86_64-unknown-unknown --show-mc-encoding -mattr=+raoint,+egpr | FileCheck %s --check-prefixes=EGPR

define void @test_int_x86_aadd64(ptr %A, i64 %B) {
; X64-LABEL: test_int_x86_aadd64:
; X64:       # %bb.0:
; X64-NEXT:    aaddq %rsi, (%rdi) # encoding: [0x48,0x0f,0x38,0xfc,0x37]
; X64-NEXT:    retq # encoding: [0xc3]
;
; EGPR-LABEL: test_int_x86_aadd64:
; EGPR:       # %bb.0:
; EGPR-NEXT:    aaddq %rsi, (%rdi) # EVEX TO LEGACY Compression encoding: [0x48,0x0f,0x38,0xfc,0x37]
; EGPR-NEXT:    retq # encoding: [0xc3]
  call void @llvm.x86.aadd64(ptr %A, i64 %B)
  ret  void
}
declare void @llvm.x86.aadd64(ptr %A, i64 %B)

define void @test_int_x86_aand64(ptr %A, i64 %B) {
; X64-LABEL: test_int_x86_aand64:
; X64:       # %bb.0:
; X64-NEXT:    aandq %rsi, (%rdi) # encoding: [0x66,0x48,0x0f,0x38,0xfc,0x37]
; X64-NEXT:    retq # encoding: [0xc3]
;
; EGPR-LABEL: test_int_x86_aand64:
; EGPR:       # %bb.0:
; EGPR-NEXT:    aandq %rsi, (%rdi) # EVEX TO LEGACY Compression encoding: [0x66,0x48,0x0f,0x38,0xfc,0x37]
; EGPR-NEXT:    retq # encoding: [0xc3]
  call void @llvm.x86.aand64(ptr %A, i64 %B)
  ret  void
}
declare void @llvm.x86.aand64(ptr %A, i64 %B)

define void @test_int_x86_aor64(ptr %A, i64 %B) {
; X64-LABEL: test_int_x86_aor64:
; X64:       # %bb.0:
; X64-NEXT:    aorq %rsi, (%rdi) # encoding: [0xf2,0x48,0x0f,0x38,0xfc,0x37]
; X64-NEXT:    retq # encoding: [0xc3]
;
; EGPR-LABEL: test_int_x86_aor64:
; EGPR:       # %bb.0:
; EGPR-NEXT:    aorq %rsi, (%rdi) # EVEX TO LEGACY Compression encoding: [0xf2,0x48,0x0f,0x38,0xfc,0x37]
; EGPR-NEXT:    retq # encoding: [0xc3]
  call void @llvm.x86.aor64(ptr %A, i64 %B)
  ret  void
}
declare void @llvm.x86.aor64(ptr %A, i64 %B)

define void @test_int_x86_axor64(ptr %A, i64 %B) {
; X64-LABEL: test_int_x86_axor64:
; X64:       # %bb.0:
; X64-NEXT:    axorq %rsi, (%rdi) # encoding: [0xf3,0x48,0x0f,0x38,0xfc,0x37]
; X64-NEXT:    retq # encoding: [0xc3]
;
; EGPR-LABEL: test_int_x86_axor64:
; EGPR:       # %bb.0:
; EGPR-NEXT:    axorq %rsi, (%rdi) # EVEX TO LEGACY Compression encoding: [0xf3,0x48,0x0f,0x38,0xfc,0x37]
; EGPR-NEXT:    retq # encoding: [0xc3]
  call void @llvm.x86.axor64(ptr %A, i64 %B)
  ret  void
}
declare void @llvm.x86.axor64(ptr %A, i64 %B)
