; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+m,+zvfh | FileCheck %s --check-prefixes=CHECK,V,RV32
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+m,+zvfh | FileCheck %s --check-prefixes=CHECK,V,RV64
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+m,+zvfh,+experimental-xrivosvizip | FileCheck %s --check-prefixes=CHECK,ZIP

; Integers

define {<16 x i1>, <16 x i1>} @vector_deinterleave_v16i1_v32i1(<32 x i1> %vec) {
; CHECK-LABEL: vector_deinterleave_v16i1_v32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; CHECK-NEXT:    vslidedown.vi v0, v0, 2
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v9, 0
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v9, v9, 8
; CHECK-NEXT:    vnsrl.wi v11, v8, 0
; CHECK-NEXT:    vnsrl.wi v8, v8, 8
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vslideup.vi v10, v11, 8
; CHECK-NEXT:    vslideup.vi v9, v8, 8
; CHECK-NEXT:    vmsne.vi v0, v10, 0
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    ret
%retval = call {<16 x i1>, <16 x i1>} @llvm.vector.deinterleave2.v32i1(<32 x i1> %vec)
ret {<16 x i1>, <16 x i1>} %retval
}

define {<16 x i8>, <16 x i8>} @vector_deinterleave_v16i8_v32i8(<32 x i8> %vec) {
; CHECK-LABEL: vector_deinterleave_v16i8_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    vnsrl.wi v11, v8, 8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    vmv.v.v v9, v11
; CHECK-NEXT:    ret
%retval = call {<16 x i8>, <16 x i8>} @llvm.vector.deinterleave2.v32i8(<32 x i8> %vec)
ret {<16 x i8>, <16 x i8>} %retval
}

define {<8 x i16>, <8 x i16>} @vector_deinterleave_v8i16_v16i16(<16 x i16> %vec) {
; CHECK-LABEL: vector_deinterleave_v8i16_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    vnsrl.wi v11, v8, 16
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    vmv.v.v v9, v11
; CHECK-NEXT:    ret
%retval = call {<8 x i16>, <8 x i16>} @llvm.vector.deinterleave2.v16i16(<16 x i16> %vec)
ret {<8 x i16>, <8 x i16>} %retval
}

define {<4 x i32>, <4 x i32>} @vector_deinterleave_v4i32_vv8i32(<8 x i32> %vec) {
; CHECK-LABEL: vector_deinterleave_v4i32_vv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vnsrl.wx v10, v8, a0
; CHECK-NEXT:    vnsrl.wi v11, v8, 0
; CHECK-NEXT:    vmv.v.v v8, v11
; CHECK-NEXT:    vmv.v.v v9, v10
; CHECK-NEXT:    ret
%retval = call {<4 x i32>, <4 x i32>} @llvm.vector.deinterleave2.v8i32(<8 x i32> %vec)
ret {<4 x i32>, <4 x i32>} %retval
}

define {<2 x i64>, <2 x i64>} @vector_deinterleave_v2i64_v4i64(<4 x i64> %vec) {
; V-LABEL: vector_deinterleave_v2i64_v4i64:
; V:       # %bb.0:
; V-NEXT:    vsetivli zero, 2, e64, m2, ta, ma
; V-NEXT:    vslidedown.vi v10, v8, 2
; V-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; V-NEXT:    vmv.v.i v0, 1
; V-NEXT:    vmv1r.v v9, v10
; V-NEXT:    vslidedown.vi v9, v8, 1, v0.t
; V-NEXT:    vslideup.vi v8, v10, 1
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_v2i64_v4i64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v10, v8, v9
; ZIP-NEXT:    ri.vunzip2b.vv v11, v8, v9
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    vmv.v.v v9, v11
; ZIP-NEXT:    ret
%retval = call {<2 x i64>, <2 x i64>} @llvm.vector.deinterleave2.v4i64(<4 x i64> %vec)
ret {<2 x i64>, <2 x i64>} %retval
}

define {<4 x i64>, <4 x i64>} @vector_deinterleave_v4i64_v8i64(<8 x i64> %vec) {
; V-LABEL: vector_deinterleave_v4i64_v8i64:
; V:       # %bb.0:
; V-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; V-NEXT:    vmv.v.i v0, 8
; V-NEXT:    vsetivli zero, 4, e64, m4, ta, ma
; V-NEXT:    vslidedown.vi v16, v8, 4
; V-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; V-NEXT:    vmv.v.i v10, 2
; V-NEXT:    vmv2r.v v12, v8
; V-NEXT:    vmv.v.i v11, 12
; V-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; V-NEXT:    vslideup.vi v14, v16, 2
; V-NEXT:    vslideup.vi v14, v16, 1, v0.t
; V-NEXT:    vmv1r.v v0, v10
; V-NEXT:    vslidedown.vi v12, v8, 1, v0.t
; V-NEXT:    vmv1r.v v0, v11
; V-NEXT:    vmerge.vvm v12, v12, v14, v0
; V-NEXT:    vslidedown.vi v14, v8, 1
; V-NEXT:    vmv1r.v v0, v10
; V-NEXT:    vslidedown.vi v14, v8, 2, v0.t
; V-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; V-NEXT:    vmv.v.i v0, 4
; V-NEXT:    vmv2r.v v8, v16
; V-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; V-NEXT:    vslideup.vi v8, v16, 1, v0.t
; V-NEXT:    vmv1r.v v0, v11
; V-NEXT:    vmerge.vvm v10, v14, v8, v0
; V-NEXT:    vmv2r.v v8, v12
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_v4i64_v8i64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v12, v8, v10
; ZIP-NEXT:    ri.vunzip2b.vv v14, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    vmv.v.v v10, v14
; ZIP-NEXT:    ret
  %retval = call {<4 x i64>, <4 x i64>} @llvm.vector.deinterleave2.v8i64(<8 x i64> %vec)
  ret {<4 x i64>, <4 x i64>} %retval
}

define {<8 x i64>, <8 x i64>} @vector_deinterleave_v8i64_v16i64(<16 x i64> %vec) {
; V-LABEL: vector_deinterleave_v8i64_v16i64:
; V:       # %bb.0:
; V-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; V-NEXT:    vid.v v16
; V-NEXT:    vsetivli zero, 8, e64, m8, ta, ma
; V-NEXT:    vslidedown.vi v24, v8, 8
; V-NEXT:    li a0, 85
; V-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; V-NEXT:    vmv.v.i v0, -16
; V-NEXT:    vmv.s.x v12, a0
; V-NEXT:    li a0, 170
; V-NEXT:    vadd.vv v13, v16, v16
; V-NEXT:    vmv.s.x v20, a0
; V-NEXT:    vadd.vi v21, v13, -8
; V-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; V-NEXT:    vcompress.vm v16, v8, v12
; V-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; V-NEXT:    vadd.vi v22, v13, -7
; V-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; V-NEXT:    vcompress.vm v12, v8, v20
; V-NEXT:    vrgatherei16.vv v16, v24, v21, v0.t
; V-NEXT:    vrgatherei16.vv v12, v24, v22, v0.t
; V-NEXT:    vmv.v.v v8, v16
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_v8i64_v16i64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v16, v8, v12
; ZIP-NEXT:    ri.vunzip2b.vv v20, v8, v12
; ZIP-NEXT:    vmv.v.v v8, v16
; ZIP-NEXT:    vmv.v.v v12, v20
; ZIP-NEXT:    ret
  %retval = call {<8 x i64>, <8 x i64>} @llvm.vector.deinterleave2.v16i64(<16 x i64> %vec)
  ret {<8 x i64>, <8 x i64>} %retval
}

define {<2 x i32>, <2 x i32>, <2 x i32>} @vector_deinterleave3_v2i32_v6i32(<6 x i32> %v) nounwind {
; CHECK-LABEL: vector_deinterleave3_v2i32_v6i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetivli zero, 2, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v12, v8, 2
; CHECK-NEXT:    vsetivli zero, 2, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v10, v8, 4
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v8, v12, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg3e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
	   %res = call {<2 x i32>, <2 x i32>, <2 x i32>} @llvm.vector.deinterleave3.v6i32(<6 x i32> %v)
	   ret {<2 x i32>, <2 x i32>, <2 x i32>} %res
}

define {<2 x i32>, <2 x i32>, <2 x i32>, <2 x i32>} @vector_deinterleave4_v2i32_v8i32(<8 x i32> %v) nounwind {
; CHECK-LABEL: vector_deinterleave4_v2i32_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetivli zero, 2, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v10, v8, 6
; CHECK-NEXT:    vslidedown.vi v12, v8, 4
; CHECK-NEXT:    vsetivli zero, 2, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v9, v8, 2
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v12, v10, a0
; CHECK-NEXT:    vslideup.vx v8, v9, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv.v.v v9, v12
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg4e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
	   %res = call {<2 x i32>, <2 x i32>, <2 x i32>, <2 x i32>} @llvm.vector.deinterleave4.v8i32(<8 x i32> %v)
	   ret {<2 x i32>, <2 x i32>, <2 x i32>, <2 x i32>} %res
}

define {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} @vector_deinterleave5_v2i16_v10i16(<10 x i16> %v) nounwind {
; CHECK-LABEL: vector_deinterleave5_v2i16_v10i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetivli zero, 2, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v12, v8, 6
; CHECK-NEXT:    vslidedown.vi v13, v8, 4
; CHECK-NEXT:    vslidedown.vi v14, v8, 2
; CHECK-NEXT:    vsetivli zero, 2, e16, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v10, v8, 8
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a2, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v13, v12, a0
; CHECK-NEXT:    vslideup.vx v8, v14, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v8, v13, a1
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg5e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
	   %res = call {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} @llvm.vector.deinterleave5.v10i16(<10 x i16> %v)
	   ret {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res
}

define {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} @vector_deinterleave6_v2i16_v12i16(<12 x i16> %v) nounwind {
; CHECK-LABEL: vector_deinterleave6_v2i16_v12i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetivli zero, 2, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v14, v8, 6
; CHECK-NEXT:    vslidedown.vi v15, v8, 4
; CHECK-NEXT:    vslidedown.vi v16, v8, 2
; CHECK-NEXT:    vsetivli zero, 2, e16, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v10, v8, 10
; CHECK-NEXT:    vslidedown.vi v12, v8, 8
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a2, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v15, v14, a0
; CHECK-NEXT:    vslideup.vx v8, v16, a0
; CHECK-NEXT:    vslideup.vx v12, v10, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v8, v15, a1
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v9, v12
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg6e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
	   %res = call {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} @llvm.vector.deinterleave6.v12i16(<12 x i16> %v)
	   ret {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res
}

define {<2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>} @vector_deinterleave7_v14i8_v2i8(<14 x i8> %v) nounwind {
; CHECK-LABEL: vector_deinterleave7_v14i8_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetivli zero, 2, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v9, v8, 10
; CHECK-NEXT:    vslidedown.vi v10, v8, 8
; CHECK-NEXT:    vslidedown.vi v11, v8, 12
; CHECK-NEXT:    vslidedown.vi v12, v8, 2
; CHECK-NEXT:    vslidedown.vi v13, v8, 4
; CHECK-NEXT:    vslidedown.vi v14, v8, 6
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a2, a0, 3
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, tu, ma
; CHECK-NEXT:    vslideup.vx v10, v9, a2
; CHECK-NEXT:    add a3, a1, a2
; CHECK-NEXT:    vslideup.vx v8, v12, a2
; CHECK-NEXT:    vsetvli zero, a3, e8, mf2, tu, ma
; CHECK-NEXT:    vslideup.vx v10, v11, a1
; CHECK-NEXT:    vslideup.vx v8, v13, a1
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v8, v14, a3
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v8, v10, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs1r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vlseg7e8.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
	   %res = call {<2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>} @llvm.vector.deinterleave7.v14i8(<14 x i8> %v)
	   ret {<2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>} %res
}

define {<2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>} @vector_deinterleave8_v16i8_v2i8(<16 x i8> %v) nounwind {
; CHECK-LABEL: vector_deinterleave8_v16i8_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetivli zero, 2, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v9, v8, 10
; CHECK-NEXT:    vslidedown.vi v10, v8, 8
; CHECK-NEXT:    vslidedown.vi v11, v8, 12
; CHECK-NEXT:    vslidedown.vi v12, v8, 14
; CHECK-NEXT:    vslidedown.vi v13, v8, 2
; CHECK-NEXT:    vslidedown.vi v14, v8, 4
; CHECK-NEXT:    vslidedown.vi v15, v8, 6
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a2, a0, 3
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, tu, ma
; CHECK-NEXT:    vslideup.vx v10, v9, a2
; CHECK-NEXT:    add a3, a1, a2
; CHECK-NEXT:    vslideup.vx v8, v13, a2
; CHECK-NEXT:    vsetvli zero, a3, e8, mf2, tu, ma
; CHECK-NEXT:    vslideup.vx v10, v11, a1
; CHECK-NEXT:    vslideup.vx v8, v14, a1
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v10, v12, a3
; CHECK-NEXT:    vslideup.vx v8, v15, a3
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v8, v10, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs1r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vlseg8e8.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
	   %res = call {<2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>} @llvm.vector.deinterleave8.v16i8(<16 x i8> %v)
	   ret {<2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>, <2 x i8>} %res
}

; Floats

define {<2 x half>, <2 x half>} @vector_deinterleave_v2f16_v4f16(<4 x half> %vec) {
; CHECK-LABEL: vector_deinterleave_v2f16_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    vnsrl.wi v9, v8, 16
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
%retval = call {<2 x half>, <2 x half>} @llvm.vector.deinterleave2.v4f16(<4 x half> %vec)
ret {<2 x half>, <2 x half>} %retval
}

define {<4 x half>, <4 x half>} @vector_deinterleave_v4f16_v8f16(<8 x half> %vec) {
; CHECK-LABEL: vector_deinterleave_v4f16_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    vnsrl.wi v9, v8, 16
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
%retval = call {<4 x half>, <4 x half>} @llvm.vector.deinterleave2.v8f16(<8 x half> %vec)
ret {<4 x half>, <4 x half>} %retval
}

define {<2 x float>, <2 x float>} @vector_deinterleave_v2f32_v4f32(<4 x float> %vec) {
; CHECK-LABEL: vector_deinterleave_v2f32_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wx v9, v8, a0
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
%retval = call {<2 x float>, <2 x float>} @llvm.vector.deinterleave2.v4f32(<4 x float> %vec)
ret {<2 x float>, <2 x float>} %retval
}

define {<8 x half>, <8 x half>} @vector_deinterleave_v8f16_v16f16(<16 x half> %vec) {
; CHECK-LABEL: vector_deinterleave_v8f16_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    vnsrl.wi v11, v8, 16
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    vmv.v.v v9, v11
; CHECK-NEXT:    ret
%retval = call {<8 x half>, <8 x half>} @llvm.vector.deinterleave2.v16f16(<16 x half> %vec)
ret {<8 x half>, <8 x half>} %retval
}

define {<4 x float>, <4 x float>} @vector_deinterleave_v4f32_v8f32(<8 x float> %vec) {
; CHECK-LABEL: vector_deinterleave_v4f32_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vnsrl.wx v10, v8, a0
; CHECK-NEXT:    vnsrl.wi v11, v8, 0
; CHECK-NEXT:    vmv.v.v v8, v11
; CHECK-NEXT:    vmv.v.v v9, v10
; CHECK-NEXT:    ret
%retval = call {<4 x float>, <4 x float>} @llvm.vector.deinterleave2.v8f32(<8 x float> %vec)
ret  {<4 x float>, <4 x float>} %retval
}

define {<2 x double>, <2 x double>} @vector_deinterleave_v2f64_v4f64(<4 x double> %vec) {
; V-LABEL: vector_deinterleave_v2f64_v4f64:
; V:       # %bb.0:
; V-NEXT:    vsetivli zero, 2, e64, m2, ta, ma
; V-NEXT:    vslidedown.vi v10, v8, 2
; V-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; V-NEXT:    vmv.v.i v0, 1
; V-NEXT:    vmv1r.v v9, v10
; V-NEXT:    vslidedown.vi v9, v8, 1, v0.t
; V-NEXT:    vslideup.vi v8, v10, 1
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_v2f64_v4f64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v10, v8, v9
; ZIP-NEXT:    ri.vunzip2b.vv v12, v8, v9
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    vmv.v.v v9, v12
; ZIP-NEXT:    ret
%retval = call {<2 x double>, <2 x double>} @llvm.vector.deinterleave2.v4f64(<4 x double> %vec)
ret {<2 x double>, <2 x double>} %retval
}

define {<4 x double>, <4 x double>} @vector_deinterleave_v4f64_v8f64(<8 x double> %vec) {
; V-LABEL: vector_deinterleave_v4f64_v8f64:
; V:       # %bb.0:
; V-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; V-NEXT:    vmv.v.i v0, 8
; V-NEXT:    vsetivli zero, 4, e64, m4, ta, ma
; V-NEXT:    vslidedown.vi v16, v8, 4
; V-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; V-NEXT:    vmv.v.i v10, 2
; V-NEXT:    vmv2r.v v12, v8
; V-NEXT:    vmv.v.i v11, 12
; V-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; V-NEXT:    vslideup.vi v14, v16, 2
; V-NEXT:    vslideup.vi v14, v16, 1, v0.t
; V-NEXT:    vmv1r.v v0, v10
; V-NEXT:    vslidedown.vi v12, v8, 1, v0.t
; V-NEXT:    vmv1r.v v0, v11
; V-NEXT:    vmerge.vvm v12, v12, v14, v0
; V-NEXT:    vslidedown.vi v14, v8, 1
; V-NEXT:    vmv1r.v v0, v10
; V-NEXT:    vslidedown.vi v14, v8, 2, v0.t
; V-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; V-NEXT:    vmv.v.i v0, 4
; V-NEXT:    vmv2r.v v8, v16
; V-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; V-NEXT:    vslideup.vi v8, v16, 1, v0.t
; V-NEXT:    vmv1r.v v0, v11
; V-NEXT:    vmerge.vvm v10, v14, v8, v0
; V-NEXT:    vmv2r.v v8, v12
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_v4f64_v8f64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v12, v8, v10
; ZIP-NEXT:    ri.vunzip2b.vv v16, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    vmv.v.v v10, v16
; ZIP-NEXT:    ret
%retval = call {<4 x double>, <4 x double>} @llvm.vector.deinterleave2.v8f64(<8 x double> %vec)
ret {<4 x double>, <4 x double>} %retval
}

define {<2 x float>, <2 x float>, <2 x float>} @vector_deinterleave3_v6f32_v2f32(<6 x float> %v) {
; CHECK-LABEL: vector_deinterleave3_v6f32_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x02, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 2 * vlenb
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetivli zero, 2, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v12, v8, 2
; CHECK-NEXT:    vsetivli zero, 2, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v10, v8, 4
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v8, v12, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg3e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    .cfi_def_cfa sp, 16
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
	   %res = call {<2 x float>, <2 x float>, <2 x float>} @llvm.vector.deinterleave3.v6f32(<6 x float> %v)
	   ret {<2 x float>, <2 x float>, <2 x float>} %res
}

define {<2 x float>, <2 x float>, <2 x float>, <2 x float>} @vector_deinterleave4_v8f32_v2f32(<8 x float> %v) {
; CHECK-LABEL: vector_deinterleave4_v8f32_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x02, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 2 * vlenb
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetivli zero, 2, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v10, v8, 6
; CHECK-NEXT:    vslidedown.vi v12, v8, 4
; CHECK-NEXT:    vsetivli zero, 2, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v9, v8, 2
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v12, v10, a0
; CHECK-NEXT:    vslideup.vx v8, v9, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv.v.v v9, v12
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg4e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    .cfi_def_cfa sp, 16
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
	   %res = call {<2 x float>, <2 x float>, <2 x float>, <2 x float>} @llvm.vector.deinterleave4.v8f32(<8 x float> %v)
	   ret {<2 x float>, <2 x float>, <2 x float>, <2 x float>} %res
}

define {<2 x half>, <2 x half>, <2 x half>, <2 x half>, <2 x half>} @vector_deinterleave5_v10f16_v2f16(<10 x half> %v) {
; CHECK-LABEL: vector_deinterleave5_v10f16_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x02, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 2 * vlenb
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetivli zero, 2, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v12, v8, 6
; CHECK-NEXT:    vslidedown.vi v13, v8, 4
; CHECK-NEXT:    vslidedown.vi v14, v8, 2
; CHECK-NEXT:    vsetivli zero, 2, e16, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v10, v8, 8
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a2, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v13, v12, a0
; CHECK-NEXT:    vslideup.vx v8, v14, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v8, v13, a1
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg5e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    .cfi_def_cfa sp, 16
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
	   %res = call {<2 x half>, <2 x half>, <2 x half>, <2 x half>, <2 x half>} @llvm.vector.deinterleave5.v10f16(<10 x half> %v)
	   ret {<2 x half>, <2 x half>, <2 x half>, <2 x half>, <2 x half>} %res
}

define {<2 x half>, <2 x half>, <2 x half>, <2 x half>, <2 x half>, <2 x half>} @vector_deinterleave6_v12f16_v2f16(<12 x half> %v) {
; CHECK-LABEL: vector_deinterleave6_v12f16_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x02, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 2 * vlenb
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetivli zero, 2, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v14, v8, 6
; CHECK-NEXT:    vslidedown.vi v15, v8, 4
; CHECK-NEXT:    vslidedown.vi v16, v8, 2
; CHECK-NEXT:    vsetivli zero, 2, e16, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v10, v8, 10
; CHECK-NEXT:    vslidedown.vi v12, v8, 8
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a2, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v15, v14, a0
; CHECK-NEXT:    vslideup.vx v8, v16, a0
; CHECK-NEXT:    vslideup.vx v12, v10, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v8, v15, a1
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v9, v12
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg6e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    .cfi_def_cfa sp, 16
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
	   %res = call {<2 x half>, <2 x half>, <2 x half>, <2 x half>, <2 x half>, <2 x half>} @llvm.vector.deinterleave6.v12f16(<12 x half> %v)
	   ret {<2 x half>, <2 x half>, <2 x half>, <2 x half>, <2 x half>, <2 x half>} %res
}

define {<1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>} @vector_deinterleave7_v7f16_v1f16(<7 x half> %v) {
; CHECK-LABEL: vector_deinterleave7_v7f16_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x02, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 2 * vlenb
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v9, v8, 3
; CHECK-NEXT:    vslidedown.vi v11, v8, 2
; CHECK-NEXT:    vslidedown.vi v12, v8, 1
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vslidedown.vi v13, v8, 5
; CHECK-NEXT:    vslidedown.vi v14, v8, 6
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a2, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v11, v9, a0
; CHECK-NEXT:    vslideup.vx v10, v12, a0
; CHECK-NEXT:    vsetvli a2, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v10, v11, a1
; CHECK-NEXT:    vslidedown.vi v11, v8, 4
; CHECK-NEXT:    vsetvli a2, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v11, v13, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v11, v14, a1
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs2r.v v10, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg7e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    .cfi_def_cfa sp, 16
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
	   %res = call {<1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>} @llvm.vector.deinterleave7.v7f16(<7 x half> %v)
	   ret {<1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>} %res
}

define {<1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>} @vector_deinterleave8_v8f16_v1f16(<8 x half> %v) {
; CHECK-LABEL: vector_deinterleave8_v8f16_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x02, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 2 * vlenb
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v10, v8, 7
; CHECK-NEXT:    vslidedown.vi v11, v8, 6
; CHECK-NEXT:    vslidedown.vi v12, v8, 5
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vslidedown.vi v9, v8, 4
; CHECK-NEXT:    vsetvli a2, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v11, v10, a0
; CHECK-NEXT:    vslideup.vx v9, v12, a0
; CHECK-NEXT:    vsetvli a2, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v9, v11, a1
; CHECK-NEXT:    vslidedown.vi v10, v8, 3
; CHECK-NEXT:    vslidedown.vi v11, v8, 2
; CHECK-NEXT:    vslidedown.vi v12, v8, 1
; CHECK-NEXT:    vsetvli a2, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v11, v10, a0
; CHECK-NEXT:    vslideup.vx v8, v12, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslideup.vx v8, v11, a1
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg8e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    .cfi_def_cfa sp, 16
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
	   %res = call {<1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>} @llvm.vector.deinterleave8.v8f16(<8 x half> %v)
	   ret {<1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>, <1 x half>} %res
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32: {{.*}}
; RV64: {{.*}}
