; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefix=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefix=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s

define <6 x float> @bitcast_v6i32_to_v6f32(<6 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v6i32_to_v6f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6i32_to_v6f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6i32_to_v6f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i32_to_v6f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i32> %a, splat (i32 3)
  %a2 = bitcast <6 x i32> %a1 to <6 x float>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i32> %a to <6 x float>
  br label %end

end:
  %phi = phi <6 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x float> %phi
}

define inreg <6 x float> @bitcast_v6i32_to_v6f32_scalar(<6 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6i32_to_v6f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB1_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB1_3
; SI-NEXT:  .LBB1_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:  .LBB1_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB1_4:
; SI-NEXT:    s_branch .LBB1_2
;
; VI-LABEL: bitcast_v6i32_to_v6f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB1_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB1_3
; VI-NEXT:  .LBB1_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB1_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB1_4:
; VI-NEXT:    s_branch .LBB1_2
;
; GFX9-LABEL: bitcast_v6i32_to_v6f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB1_3
; GFX9-NEXT:  .LBB1_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB1_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB1_4:
; GFX9-NEXT:    s_branch .LBB1_2
;
; GFX11-LABEL: bitcast_v6i32_to_v6f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB1_3
; GFX11-NEXT:  .LBB1_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB1_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB1_4:
; GFX11-NEXT:    s_branch .LBB1_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i32> %a, splat (i32 3)
  %a2 = bitcast <6 x i32> %a1 to <6 x float>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i32> %a to <6 x float>
  br label %end

end:
  %phi = phi <6 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x float> %phi
}

define <6 x i32> @bitcast_v6f32_to_v6i32(<6 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v6f32_to_v6i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f32_to_v6i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f32_to_v6i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f32_to_v6i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <6 x float> %a1 to <6 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <6 x float> %a to <6 x i32>
  br label %end

end:
  %phi = phi <6 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i32> %phi
}

define inreg <6 x i32> @bitcast_v6f32_to_v6i32_scalar(<6 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6f32_to_v6i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB3_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB3_4
; SI-NEXT:  .LBB3_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB3_3:
; SI-NEXT:    s_branch .LBB3_2
; SI-NEXT:  .LBB3_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f32_to_v6i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB3_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB3_4
; VI-NEXT:  .LBB3_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; VI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; VI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB3_3:
; VI-NEXT:    s_branch .LBB3_2
; VI-NEXT:  .LBB3_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f32_to_v6i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB3_4
; GFX9-NEXT:  .LBB3_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v5, s21, 1.0
; GFX9-NEXT:    v_add_f32_e64 v4, s20, 1.0
; GFX9-NEXT:    v_add_f32_e64 v3, s19, 1.0
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB3_3:
; GFX9-NEXT:    s_branch .LBB3_2
; GFX9-NEXT:  .LBB3_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f32_to_v6i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB3_4
; GFX11-NEXT:  .LBB3_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v5, s5, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s4, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s3, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB3_3:
; GFX11-NEXT:    s_branch .LBB3_2
; GFX11-NEXT:  .LBB3_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <6 x float> %a1 to <6 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <6 x float> %a to <6 x i32>
  br label %end

end:
  %phi = phi <6 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i32> %phi
}

define <3 x i64> @bitcast_v6i32_to_v3i64(<6 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v6i32_to_v3i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6i32_to_v3i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6i32_to_v3i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i32_to_v3i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i32> %a, splat (i32 3)
  %a2 = bitcast <6 x i32> %a1 to <3 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i32> %a to <3 x i64>
  br label %end

end:
  %phi = phi <3 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i64> %phi
}

define inreg <3 x i64> @bitcast_v6i32_to_v3i64_scalar(<6 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6i32_to_v3i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB5_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB5_3
; SI-NEXT:  .LBB5_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:  .LBB5_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB5_4:
; SI-NEXT:    s_branch .LBB5_2
;
; VI-LABEL: bitcast_v6i32_to_v3i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB5_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB5_3
; VI-NEXT:  .LBB5_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB5_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB5_4:
; VI-NEXT:    s_branch .LBB5_2
;
; GFX9-LABEL: bitcast_v6i32_to_v3i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB5_3
; GFX9-NEXT:  .LBB5_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB5_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB5_4:
; GFX9-NEXT:    s_branch .LBB5_2
;
; GFX11-LABEL: bitcast_v6i32_to_v3i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB5_3
; GFX11-NEXT:  .LBB5_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB5_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB5_4:
; GFX11-NEXT:    s_branch .LBB5_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i32> %a, splat (i32 3)
  %a2 = bitcast <6 x i32> %a1 to <3 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i32> %a to <3 x i64>
  br label %end

end:
  %phi = phi <3 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i64> %phi
}

define <6 x i32> @bitcast_v3i64_to_v6i32(<3 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v3i64_to_v6i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3i64_to_v6i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3i64_to_v6i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3i64_to_v6i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i64> %a, splat (i64 3)
  %a2 = bitcast <3 x i64> %a1 to <6 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i64> %a to <6 x i32>
  br label %end

end:
  %phi = phi <6 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i32> %phi
}

define inreg <6 x i32> @bitcast_v3i64_to_v6i32_scalar(<3 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3i64_to_v6i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB7_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB7_3
; SI-NEXT:  .LBB7_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s20, s20, 3
; SI-NEXT:    s_addc_u32 s21, s21, 0
; SI-NEXT:    s_add_u32 s18, s18, 3
; SI-NEXT:    s_addc_u32 s19, s19, 0
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:  .LBB7_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB7_4:
; SI-NEXT:    s_branch .LBB7_2
;
; VI-LABEL: bitcast_v3i64_to_v6i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB7_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB7_3
; VI-NEXT:  .LBB7_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB7_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB7_4:
; VI-NEXT:    s_branch .LBB7_2
;
; GFX9-LABEL: bitcast_v3i64_to_v6i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB7_3
; GFX9-NEXT:  .LBB7_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB7_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB7_4:
; GFX9-NEXT:    s_branch .LBB7_2
;
; GFX11-LABEL: bitcast_v3i64_to_v6i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB7_3
; GFX11-NEXT:  .LBB7_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB7_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB7_4:
; GFX11-NEXT:    s_branch .LBB7_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i64> %a, splat (i64 3)
  %a2 = bitcast <3 x i64> %a1 to <6 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i64> %a to <6 x i32>
  br label %end

end:
  %phi = phi <6 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i32> %phi
}

define <3 x double> @bitcast_v6i32_to_v3f64(<6 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v6i32_to_v3f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6i32_to_v3f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6i32_to_v3f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i32_to_v3f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i32> %a, splat (i32 3)
  %a2 = bitcast <6 x i32> %a1 to <3 x double>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i32> %a to <3 x double>
  br label %end

end:
  %phi = phi <3 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x double> %phi
}

define inreg <3 x double> @bitcast_v6i32_to_v3f64_scalar(<6 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6i32_to_v3f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB9_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB9_3
; SI-NEXT:  .LBB9_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:  .LBB9_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB9_4:
; SI-NEXT:    s_branch .LBB9_2
;
; VI-LABEL: bitcast_v6i32_to_v3f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB9_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB9_3
; VI-NEXT:  .LBB9_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB9_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB9_4:
; VI-NEXT:    s_branch .LBB9_2
;
; GFX9-LABEL: bitcast_v6i32_to_v3f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB9_3
; GFX9-NEXT:  .LBB9_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB9_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB9_4:
; GFX9-NEXT:    s_branch .LBB9_2
;
; GFX11-LABEL: bitcast_v6i32_to_v3f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB9_3
; GFX11-NEXT:  .LBB9_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB9_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB9_4:
; GFX11-NEXT:    s_branch .LBB9_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i32> %a, splat (i32 3)
  %a2 = bitcast <6 x i32> %a1 to <3 x double>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i32> %a to <3 x double>
  br label %end

end:
  %phi = phi <3 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x double> %phi
}

define <6 x i32> @bitcast_v3f64_to_v6i32(<3 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v3f64_to_v6i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f64_to_v6i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB10_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB10_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f64_to_v6i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB10_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB10_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f64_to_v6i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB10_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB10_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <3 x double> %a1 to <6 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <3 x double> %a to <6 x i32>
  br label %end

end:
  %phi = phi <6 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i32> %phi
}

define inreg <6 x i32> @bitcast_v3f64_to_v6i32_scalar(<3 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3f64_to_v6i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB11_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB11_4
; SI-NEXT:  .LBB11_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; SI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB11_3:
; SI-NEXT:    s_branch .LBB11_2
; SI-NEXT:  .LBB11_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f64_to_v6i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB11_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB11_4
; VI-NEXT:  .LBB11_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; VI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB11_3:
; VI-NEXT:    s_branch .LBB11_2
; VI-NEXT:  .LBB11_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f64_to_v6i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB11_4
; GFX9-NEXT:  .LBB11_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB11_3:
; GFX9-NEXT:    s_branch .LBB11_2
; GFX9-NEXT:  .LBB11_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f64_to_v6i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB11_4
; GFX11-NEXT:  .LBB11_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[4:5], s[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB11_3:
; GFX11-NEXT:    s_branch .LBB11_2
; GFX11-NEXT:  .LBB11_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <3 x double> %a1 to <6 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <3 x double> %a to <6 x i32>
  br label %end

end:
  %phi = phi <6 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i32> %phi
}

define <12 x i16> @bitcast_v6i32_to_v12i16(<6 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v6i32_to_v12i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, v5
; SI-NEXT:    v_mov_b32_e32 v8, v4
; SI-NEXT:    v_mov_b32_e32 v12, v3
; SI-NEXT:    v_mov_b32_e32 v4, v2
; SI-NEXT:    v_mov_b32_e32 v2, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v12, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB12_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v12, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  .LBB12_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v6, v12
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6i32_to_v12i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6i32_to_v12i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i32_to_v12i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i32> %a, splat (i32 3)
  %a2 = bitcast <6 x i32> %a1 to <12 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i32> %a to <12 x i16>
  br label %end

end:
  %phi = phi <12 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i16> %phi
}

define inreg <12 x i16> @bitcast_v6i32_to_v12i16_scalar(<6 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6i32_to_v12i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB13_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v9, s21, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s19, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s21, 16
; SI-NEXT:    s_lshr_b32 s7, s19, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB13_3
; SI-NEXT:  .LBB13_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    v_alignbit_b32 v9, s21, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    v_alignbit_b32 v5, s19, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s21, 16
; SI-NEXT:    s_lshr_b32 s7, s19, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 16
; SI-NEXT:  .LBB13_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v3, s8
; SI-NEXT:    v_mov_b32_e32 v4, s18
; SI-NEXT:    v_mov_b32_e32 v6, s19
; SI-NEXT:    v_mov_b32_e32 v7, s7
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v10, s21
; SI-NEXT:    v_mov_b32_e32 v11, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB13_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB13_2
;
; VI-LABEL: bitcast_v6i32_to_v12i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB13_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB13_3
; VI-NEXT:  .LBB13_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB13_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB13_4:
; VI-NEXT:    s_branch .LBB13_2
;
; GFX9-LABEL: bitcast_v6i32_to_v12i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB13_3
; GFX9-NEXT:  .LBB13_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB13_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB13_4:
; GFX9-NEXT:    s_branch .LBB13_2
;
; GFX11-LABEL: bitcast_v6i32_to_v12i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB13_3
; GFX11-NEXT:  .LBB13_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB13_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB13_4:
; GFX11-NEXT:    s_branch .LBB13_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i32> %a, splat (i32 3)
  %a2 = bitcast <6 x i32> %a1 to <12 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i32> %a to <12 x i16>
  br label %end

end:
  %phi = phi <12 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i16> %phi
}

define <6 x i32> @bitcast_v12i16_to_v6i32(<12 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v12i16_to_v6i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v15, v4
; SI-NEXT:    v_mov_b32_e32 v14, v2
; SI-NEXT:    v_mov_b32_e32 v13, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v11
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB14_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB14_4
; SI-NEXT:  .LBB14_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB14_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v13
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v14
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v15
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v10
; SI-NEXT:    v_or_b32_e32 v0, v0, v18
; SI-NEXT:    v_or_b32_e32 v1, v1, v17
; SI-NEXT:    v_or_b32_e32 v2, v2, v16
; SI-NEXT:    v_or_b32_e32 v3, v3, v12
; SI-NEXT:    v_or_b32_e32 v4, v4, v9
; SI-NEXT:    v_or_b32_e32 v5, v5, v7
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB14_2
; SI-NEXT:  .LBB14_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v0, v18, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_or_b32_e32 v2, v16, v2
; SI-NEXT:    v_or_b32_e32 v3, v12, v3
; SI-NEXT:    v_or_b32_e32 v4, v9, v4
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x30000, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x30000, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x30000, v5
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12i16_to_v6i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB14_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v7, 3
; VI-NEXT:    v_add_u16_e32 v6, 3, v5
; VI-NEXT:    v_add_u16_sdwa v5, v5, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v6, v5
; VI-NEXT:    v_add_u16_e32 v6, 3, v4
; VI-NEXT:    v_add_u16_sdwa v4, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v6, v4
; VI-NEXT:    v_add_u16_e32 v6, 3, v3
; VI-NEXT:    v_add_u16_sdwa v3, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v6, v3
; VI-NEXT:    v_add_u16_e32 v6, 3, v2
; VI-NEXT:    v_add_u16_sdwa v2, v2, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v6, v2
; VI-NEXT:    v_add_u16_e32 v6, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v6, v1
; VI-NEXT:    v_add_u16_e32 v6, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v6, v0
; VI-NEXT:  .LBB14_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12i16_to_v6i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12i16_to_v6i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i16> %a, splat (i16 3)
  %a2 = bitcast <12 x i16> %a1 to <6 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i16> %a to <6 x i32>
  br label %end

end:
  %phi = phi <6 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i32> %phi
}

define inreg <6 x i32> @bitcast_v12i16_to_v6i32_scalar(<12 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12i16_to_v6i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB15_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_cbranch_execnz .LBB15_3
; SI-NEXT:  .LBB15_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:  .LBB15_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB15_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7_sgpr8_sgpr9
; SI-NEXT:    s_branch .LBB15_2
;
; VI-LABEL: bitcast_v12i16_to_v6i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB15_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB15_3
; VI-NEXT:  .LBB15_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s21, 3
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s20, 3
; VI-NEXT:    s_add_i32 s21, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s19, 3
; VI-NEXT:    s_add_i32 s20, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_add_i32 s19, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB15_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB15_4:
; VI-NEXT:    s_branch .LBB15_2
;
; GFX9-LABEL: bitcast_v12i16_to_v6i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB15_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB15_4
; GFX9-NEXT:  .LBB15_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v5, s21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB15_3:
; GFX9-NEXT:    s_branch .LBB15_2
; GFX9-NEXT:  .LBB15_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12i16_to_v6i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB15_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB15_4
; GFX11-NEXT:  .LBB15_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB15_3:
; GFX11-NEXT:    s_branch .LBB15_2
; GFX11-NEXT:  .LBB15_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i16> %a, splat (i16 3)
  %a2 = bitcast <12 x i16> %a1 to <6 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i16> %a to <6 x i32>
  br label %end

end:
  %phi = phi <6 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i32> %phi
}

define <12 x half> @bitcast_v6i32_to_v12f16(<6 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v6i32_to_v12f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v17, v5
; SI-NEXT:    v_mov_b32_e32 v16, v4
; SI-NEXT:    v_mov_b32_e32 v15, v3
; SI-NEXT:    v_mov_b32_e32 v14, v2
; SI-NEXT:    v_mov_b32_e32 v13, v1
; SI-NEXT:    v_mov_b32_e32 v12, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB16_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB16_4
; SI-NEXT:  .LBB16_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB16_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v12
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB16_2
; SI-NEXT:  .LBB16_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v1
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6i32_to_v12f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6i32_to_v12f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i32_to_v12f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i32> %a, splat (i32 3)
  %a2 = bitcast <6 x i32> %a1 to <12 x half>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i32> %a to <12 x half>
  br label %end

end:
  %phi = phi <12 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x half> %phi
}

define inreg <12 x half> @bitcast_v6i32_to_v12f16_scalar(<6 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6i32_to_v12f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB17_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB17_3
; SI-NEXT:  .LBB17_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:  .LBB17_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB17_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_branch .LBB17_2
;
; VI-LABEL: bitcast_v6i32_to_v12f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB17_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB17_3
; VI-NEXT:  .LBB17_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB17_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB17_4:
; VI-NEXT:    s_branch .LBB17_2
;
; GFX9-LABEL: bitcast_v6i32_to_v12f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB17_3
; GFX9-NEXT:  .LBB17_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB17_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB17_4:
; GFX9-NEXT:    s_branch .LBB17_2
;
; GFX11-LABEL: bitcast_v6i32_to_v12f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB17_3
; GFX11-NEXT:  .LBB17_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB17_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB17_4:
; GFX11-NEXT:    s_branch .LBB17_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i32> %a, splat (i32 3)
  %a2 = bitcast <6 x i32> %a1 to <12 x half>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i32> %a to <12 x half>
  br label %end

end:
  %phi = phi <12 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x half> %phi
}

define <6 x i32> @bitcast_v12f16_to_v6i32(<12 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v12f16_to_v6i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v10
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB18_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB18_4
; SI-NEXT:  .LBB18_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB18_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v20
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v18
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v16
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v14
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v0, v19, v0
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_or_b32_e32 v2, v15, v2
; SI-NEXT:    v_or_b32_e32 v3, v13, v3
; SI-NEXT:    v_or_b32_e32 v4, v8, v4
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB18_2
; SI-NEXT:  .LBB18_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v17
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v16
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v13
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v15
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v14
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12f16_to_v6i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB18_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v6, 0x200
; VI-NEXT:    v_add_f16_sdwa v7, v5, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v7
; VI-NEXT:    v_add_f16_sdwa v7, v4, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v7
; VI-NEXT:    v_add_f16_sdwa v7, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v7
; VI-NEXT:    v_add_f16_sdwa v7, v2, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v7
; VI-NEXT:    v_add_f16_sdwa v7, v1, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v6, v0, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v7
; VI-NEXT:    v_or_b32_e32 v0, v0, v6
; VI-NEXT:  .LBB18_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12f16_to_v6i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12f16_to_v6i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <12 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <12 x half> %a1 to <6 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <12 x half> %a to <6 x i32>
  br label %end

end:
  %phi = phi <6 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i32> %phi
}

define inreg <6 x i32> @bitcast_v12f16_to_v6i32_scalar(<12 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12f16_to_v6i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v17, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v16, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v15, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v14, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v13, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v12, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v11, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v9, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v8, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v7, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v6, s26
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB19_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v0, v16, v0
; SI-NEXT:    v_or_b32_e32 v1, v14, v1
; SI-NEXT:    v_or_b32_e32 v2, v12, v2
; SI-NEXT:    v_or_b32_e32 v3, v10, v3
; SI-NEXT:    v_or_b32_e32 v4, v8, v4
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    s_cbranch_execnz .LBB19_3
; SI-NEXT:  .LBB19_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v14
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v13
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v10
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v12
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v11
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:  .LBB19_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB19_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5
; SI-NEXT:    s_branch .LBB19_2
;
; VI-LABEL: bitcast_v12f16_to_v6i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB19_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB19_4
; VI-NEXT:  .LBB19_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s21, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s21, v0
; VI-NEXT:    s_lshr_b32 s4, s20, 16
; VI-NEXT:    v_or_b32_e32 v5, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s20, v0
; VI-NEXT:    s_lshr_b32 s4, s19, 16
; VI-NEXT:    v_or_b32_e32 v4, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s19, v0
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_or_b32_e32 v3, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_or_b32_e32 v2, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v6, v1
; VI-NEXT:    v_mov_b32_e32 v6, s4
; VI-NEXT:    v_add_f16_sdwa v6, v6, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v6
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB19_3:
; VI-NEXT:    s_branch .LBB19_2
; VI-NEXT:  .LBB19_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12f16_to_v6i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB19_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB19_4
; GFX9-NEXT:  .LBB19_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v5, s21, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, s20, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, s19, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB19_3:
; GFX9-NEXT:    s_branch .LBB19_2
; GFX9-NEXT:  .LBB19_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12f16_to_v6i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB19_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB19_4
; GFX11-NEXT:  .LBB19_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, s5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, s4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB19_3:
; GFX11-NEXT:    s_branch .LBB19_2
; GFX11-NEXT:  .LBB19_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <12 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <12 x half> %a1 to <6 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <12 x half> %a to <6 x i32>
  br label %end

end:
  %phi = phi <6 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i32> %phi
}

define <3 x i64> @bitcast_v6f32_to_v3i64(<6 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v6f32_to_v3i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f32_to_v3i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f32_to_v3i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f32_to_v3i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <6 x float> %a1 to <3 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <6 x float> %a to <3 x i64>
  br label %end

end:
  %phi = phi <3 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i64> %phi
}

define inreg <3 x i64> @bitcast_v6f32_to_v3i64_scalar(<6 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6f32_to_v3i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB21_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB21_4
; SI-NEXT:  .LBB21_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB21_3:
; SI-NEXT:    s_branch .LBB21_2
; SI-NEXT:  .LBB21_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f32_to_v3i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB21_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB21_4
; VI-NEXT:  .LBB21_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; VI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; VI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB21_3:
; VI-NEXT:    s_branch .LBB21_2
; VI-NEXT:  .LBB21_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f32_to_v3i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB21_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB21_4
; GFX9-NEXT:  .LBB21_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v5, s21, 1.0
; GFX9-NEXT:    v_add_f32_e64 v4, s20, 1.0
; GFX9-NEXT:    v_add_f32_e64 v3, s19, 1.0
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB21_3:
; GFX9-NEXT:    s_branch .LBB21_2
; GFX9-NEXT:  .LBB21_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f32_to_v3i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB21_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB21_4
; GFX11-NEXT:  .LBB21_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v5, s5, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s4, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s3, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB21_3:
; GFX11-NEXT:    s_branch .LBB21_2
; GFX11-NEXT:  .LBB21_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <6 x float> %a1 to <3 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <6 x float> %a to <3 x i64>
  br label %end

end:
  %phi = phi <3 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i64> %phi
}

define <6 x float> @bitcast_v3i64_to_v6f32(<3 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v3i64_to_v6f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3i64_to_v6f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3i64_to_v6f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3i64_to_v6f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i64> %a, splat (i64 3)
  %a2 = bitcast <3 x i64> %a1 to <6 x float>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i64> %a to <6 x float>
  br label %end

end:
  %phi = phi <6 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x float> %phi
}

define inreg <6 x float> @bitcast_v3i64_to_v6f32_scalar(<3 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3i64_to_v6f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB23_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB23_3
; SI-NEXT:  .LBB23_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s20, s20, 3
; SI-NEXT:    s_addc_u32 s21, s21, 0
; SI-NEXT:    s_add_u32 s18, s18, 3
; SI-NEXT:    s_addc_u32 s19, s19, 0
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:  .LBB23_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB23_4:
; SI-NEXT:    s_branch .LBB23_2
;
; VI-LABEL: bitcast_v3i64_to_v6f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB23_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB23_3
; VI-NEXT:  .LBB23_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB23_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB23_4:
; VI-NEXT:    s_branch .LBB23_2
;
; GFX9-LABEL: bitcast_v3i64_to_v6f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB23_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB23_3
; GFX9-NEXT:  .LBB23_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB23_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB23_4:
; GFX9-NEXT:    s_branch .LBB23_2
;
; GFX11-LABEL: bitcast_v3i64_to_v6f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB23_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB23_3
; GFX11-NEXT:  .LBB23_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB23_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB23_4:
; GFX11-NEXT:    s_branch .LBB23_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i64> %a, splat (i64 3)
  %a2 = bitcast <3 x i64> %a1 to <6 x float>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i64> %a to <6 x float>
  br label %end

end:
  %phi = phi <6 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x float> %phi
}

define <3 x double> @bitcast_v6f32_to_v3f64(<6 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v6f32_to_v3f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f32_to_v3f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f32_to_v3f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f32_to_v3f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <6 x float> %a1 to <3 x double>
  br label %end

cmp.false:
  %a3 = bitcast <6 x float> %a to <3 x double>
  br label %end

end:
  %phi = phi <3 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x double> %phi
}

define inreg <3 x double> @bitcast_v6f32_to_v3f64_scalar(<6 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6f32_to_v3f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB25_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB25_4
; SI-NEXT:  .LBB25_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB25_3:
; SI-NEXT:    s_branch .LBB25_2
; SI-NEXT:  .LBB25_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f32_to_v3f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB25_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB25_4
; VI-NEXT:  .LBB25_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; VI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; VI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB25_3:
; VI-NEXT:    s_branch .LBB25_2
; VI-NEXT:  .LBB25_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f32_to_v3f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB25_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB25_4
; GFX9-NEXT:  .LBB25_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v5, s21, 1.0
; GFX9-NEXT:    v_add_f32_e64 v4, s20, 1.0
; GFX9-NEXT:    v_add_f32_e64 v3, s19, 1.0
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB25_3:
; GFX9-NEXT:    s_branch .LBB25_2
; GFX9-NEXT:  .LBB25_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f32_to_v3f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB25_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB25_4
; GFX11-NEXT:  .LBB25_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v5, s5, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s4, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s3, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB25_3:
; GFX11-NEXT:    s_branch .LBB25_2
; GFX11-NEXT:  .LBB25_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <6 x float> %a1 to <3 x double>
  br label %end

cmp.false:
  %a3 = bitcast <6 x float> %a to <3 x double>
  br label %end

end:
  %phi = phi <3 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x double> %phi
}

define <6 x float> @bitcast_v3f64_to_v6f32(<3 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v3f64_to_v6f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f64_to_v6f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB26_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB26_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f64_to_v6f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB26_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB26_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f64_to_v6f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB26_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB26_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <3 x double> %a1 to <6 x float>
  br label %end

cmp.false:
  %a3 = bitcast <3 x double> %a to <6 x float>
  br label %end

end:
  %phi = phi <6 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x float> %phi
}

define inreg <6 x float> @bitcast_v3f64_to_v6f32_scalar(<3 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3f64_to_v6f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB27_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB27_4
; SI-NEXT:  .LBB27_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; SI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB27_3:
; SI-NEXT:    s_branch .LBB27_2
; SI-NEXT:  .LBB27_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f64_to_v6f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB27_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB27_4
; VI-NEXT:  .LBB27_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; VI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB27_3:
; VI-NEXT:    s_branch .LBB27_2
; VI-NEXT:  .LBB27_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f64_to_v6f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB27_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB27_4
; GFX9-NEXT:  .LBB27_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB27_3:
; GFX9-NEXT:    s_branch .LBB27_2
; GFX9-NEXT:  .LBB27_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f64_to_v6f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB27_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB27_4
; GFX11-NEXT:  .LBB27_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[4:5], s[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB27_3:
; GFX11-NEXT:    s_branch .LBB27_2
; GFX11-NEXT:  .LBB27_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <3 x double> %a1 to <6 x float>
  br label %end

cmp.false:
  %a3 = bitcast <3 x double> %a to <6 x float>
  br label %end

end:
  %phi = phi <6 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x float> %phi
}

define <12 x i16> @bitcast_v6f32_to_v12i16(<6 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v6f32_to_v12i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, v5
; SI-NEXT:    v_mov_b32_e32 v8, v4
; SI-NEXT:    v_mov_b32_e32 v12, v3
; SI-NEXT:    v_mov_b32_e32 v4, v2
; SI-NEXT:    v_mov_b32_e32 v2, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v12, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB28_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v12, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  .LBB28_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v6, v12
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f32_to_v12i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f32_to_v12i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f32_to_v12i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <6 x float> %a1 to <12 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <6 x float> %a to <12 x i16>
  br label %end

end:
  %phi = phi <12 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i16> %phi
}

define inreg <12 x i16> @bitcast_v6f32_to_v12i16_scalar(<6 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6f32_to_v12i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB29_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v9, s21, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s19, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s8, s21, 16
; SI-NEXT:    s_lshr_b32 s7, s19, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB29_4
; SI-NEXT:  .LBB29_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v2, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_add_f32_e64 v6, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v10, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v8, s20, 1.0
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB29_3:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    s_branch .LBB29_2
; SI-NEXT:  .LBB29_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v4, s18
; SI-NEXT:    v_mov_b32_e32 v6, s19
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v10, s21
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:    v_mov_b32_e32 v7, s7
; SI-NEXT:    v_mov_b32_e32 v11, s8
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f32_to_v12i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB29_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB29_4
; VI-NEXT:  .LBB29_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; VI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; VI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB29_3:
; VI-NEXT:    s_branch .LBB29_2
; VI-NEXT:  .LBB29_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f32_to_v12i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB29_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB29_4
; GFX9-NEXT:  .LBB29_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v5, s21, 1.0
; GFX9-NEXT:    v_add_f32_e64 v4, s20, 1.0
; GFX9-NEXT:    v_add_f32_e64 v3, s19, 1.0
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB29_3:
; GFX9-NEXT:    s_branch .LBB29_2
; GFX9-NEXT:  .LBB29_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f32_to_v12i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB29_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB29_4
; GFX11-NEXT:  .LBB29_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v5, s5, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s4, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s3, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB29_3:
; GFX11-NEXT:    s_branch .LBB29_2
; GFX11-NEXT:  .LBB29_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <6 x float> %a1 to <12 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <6 x float> %a to <12 x i16>
  br label %end

end:
  %phi = phi <12 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i16> %phi
}

define <6 x float> @bitcast_v12i16_to_v6f32(<12 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v12i16_to_v6f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v15, v4
; SI-NEXT:    v_mov_b32_e32 v14, v2
; SI-NEXT:    v_mov_b32_e32 v13, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v11
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB30_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB30_4
; SI-NEXT:  .LBB30_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB30_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v13
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v14
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v15
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v10
; SI-NEXT:    v_or_b32_e32 v0, v0, v18
; SI-NEXT:    v_or_b32_e32 v1, v1, v17
; SI-NEXT:    v_or_b32_e32 v2, v2, v16
; SI-NEXT:    v_or_b32_e32 v3, v3, v12
; SI-NEXT:    v_or_b32_e32 v4, v4, v9
; SI-NEXT:    v_or_b32_e32 v5, v5, v7
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB30_2
; SI-NEXT:  .LBB30_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v0, v18, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_or_b32_e32 v2, v16, v2
; SI-NEXT:    v_or_b32_e32 v3, v12, v3
; SI-NEXT:    v_or_b32_e32 v4, v9, v4
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x30000, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x30000, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x30000, v5
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12i16_to_v6f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB30_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v7, 3
; VI-NEXT:    v_add_u16_e32 v6, 3, v5
; VI-NEXT:    v_add_u16_sdwa v5, v5, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v6, v5
; VI-NEXT:    v_add_u16_e32 v6, 3, v4
; VI-NEXT:    v_add_u16_sdwa v4, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v6, v4
; VI-NEXT:    v_add_u16_e32 v6, 3, v3
; VI-NEXT:    v_add_u16_sdwa v3, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v6, v3
; VI-NEXT:    v_add_u16_e32 v6, 3, v2
; VI-NEXT:    v_add_u16_sdwa v2, v2, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v6, v2
; VI-NEXT:    v_add_u16_e32 v6, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v6, v1
; VI-NEXT:    v_add_u16_e32 v6, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v6, v0
; VI-NEXT:  .LBB30_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12i16_to_v6f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12i16_to_v6f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i16> %a, splat (i16 3)
  %a2 = bitcast <12 x i16> %a1 to <6 x float>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i16> %a to <6 x float>
  br label %end

end:
  %phi = phi <6 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x float> %phi
}

define inreg <6 x float> @bitcast_v12i16_to_v6f32_scalar(<12 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12i16_to_v6f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB31_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_cbranch_execnz .LBB31_3
; SI-NEXT:  .LBB31_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:  .LBB31_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB31_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7_sgpr8_sgpr9
; SI-NEXT:    s_branch .LBB31_2
;
; VI-LABEL: bitcast_v12i16_to_v6f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB31_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB31_3
; VI-NEXT:  .LBB31_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s21, 3
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s20, 3
; VI-NEXT:    s_add_i32 s21, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s19, 3
; VI-NEXT:    s_add_i32 s20, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_add_i32 s19, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB31_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB31_4:
; VI-NEXT:    s_branch .LBB31_2
;
; GFX9-LABEL: bitcast_v12i16_to_v6f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB31_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB31_4
; GFX9-NEXT:  .LBB31_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v5, s21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB31_3:
; GFX9-NEXT:    s_branch .LBB31_2
; GFX9-NEXT:  .LBB31_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12i16_to_v6f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB31_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB31_4
; GFX11-NEXT:  .LBB31_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB31_3:
; GFX11-NEXT:    s_branch .LBB31_2
; GFX11-NEXT:  .LBB31_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i16> %a, splat (i16 3)
  %a2 = bitcast <12 x i16> %a1 to <6 x float>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i16> %a to <6 x float>
  br label %end

end:
  %phi = phi <6 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x float> %phi
}

define <12 x half> @bitcast_v6f32_to_v12f16(<6 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v6f32_to_v12f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v17, v5
; SI-NEXT:    v_mov_b32_e32 v16, v4
; SI-NEXT:    v_mov_b32_e32 v15, v3
; SI-NEXT:    v_mov_b32_e32 v14, v2
; SI-NEXT:    v_mov_b32_e32 v13, v1
; SI-NEXT:    v_mov_b32_e32 v12, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB32_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB32_4
; SI-NEXT:  .LBB32_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB32_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v12
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB32_2
; SI-NEXT:  .LBB32_4: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v1
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f32_to_v12f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f32_to_v12f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f32_to_v12f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <6 x float> %a1 to <12 x half>
  br label %end

cmp.false:
  %a3 = bitcast <6 x float> %a to <12 x half>
  br label %end

end:
  %phi = phi <12 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x half> %phi
}

define inreg <12 x half> @bitcast_v6f32_to_v12f16_scalar(<6 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6f32_to_v12f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB33_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB33_3
; SI-NEXT:  .LBB33_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v1, s16, 1.0
; SI-NEXT:    v_add_f32_e64 v3, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v5, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v7, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v9, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v11, s21, 1.0
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v1
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:  .LBB33_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB33_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_branch .LBB33_2
;
; VI-LABEL: bitcast_v6f32_to_v12f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB33_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB33_4
; VI-NEXT:  .LBB33_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; VI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; VI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB33_3:
; VI-NEXT:    s_branch .LBB33_2
; VI-NEXT:  .LBB33_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f32_to_v12f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB33_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB33_4
; GFX9-NEXT:  .LBB33_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v5, s21, 1.0
; GFX9-NEXT:    v_add_f32_e64 v4, s20, 1.0
; GFX9-NEXT:    v_add_f32_e64 v3, s19, 1.0
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB33_3:
; GFX9-NEXT:    s_branch .LBB33_2
; GFX9-NEXT:  .LBB33_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f32_to_v12f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB33_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB33_4
; GFX11-NEXT:  .LBB33_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v5, s5, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s4, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s3, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB33_3:
; GFX11-NEXT:    s_branch .LBB33_2
; GFX11-NEXT:  .LBB33_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <6 x float> %a1 to <12 x half>
  br label %end

cmp.false:
  %a3 = bitcast <6 x float> %a to <12 x half>
  br label %end

end:
  %phi = phi <12 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x half> %phi
}

define <6 x float> @bitcast_v12f16_to_v6f32(<12 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v12f16_to_v6f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v10
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB34_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB34_4
; SI-NEXT:  .LBB34_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB34_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v20
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v18
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v16
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v14
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v0, v19, v0
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_or_b32_e32 v2, v15, v2
; SI-NEXT:    v_or_b32_e32 v3, v13, v3
; SI-NEXT:    v_or_b32_e32 v4, v8, v4
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB34_2
; SI-NEXT:  .LBB34_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v17
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v16
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v13
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v15
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v14
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12f16_to_v6f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB34_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v6, 0x200
; VI-NEXT:    v_add_f16_sdwa v7, v5, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v7
; VI-NEXT:    v_add_f16_sdwa v7, v4, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v7
; VI-NEXT:    v_add_f16_sdwa v7, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v7
; VI-NEXT:    v_add_f16_sdwa v7, v2, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v7
; VI-NEXT:    v_add_f16_sdwa v7, v1, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v6, v0, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v7
; VI-NEXT:    v_or_b32_e32 v0, v0, v6
; VI-NEXT:  .LBB34_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12f16_to_v6f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12f16_to_v6f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <12 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <12 x half> %a1 to <6 x float>
  br label %end

cmp.false:
  %a3 = bitcast <12 x half> %a to <6 x float>
  br label %end

end:
  %phi = phi <6 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x float> %phi
}

define inreg <6 x float> @bitcast_v12f16_to_v6f32_scalar(<12 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12f16_to_v6f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v17, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v16, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v15, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v14, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v13, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v12, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v11, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v9, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v8, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v7, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v6, s26
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB35_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v0, v16, v0
; SI-NEXT:    v_or_b32_e32 v1, v14, v1
; SI-NEXT:    v_or_b32_e32 v2, v12, v2
; SI-NEXT:    v_or_b32_e32 v3, v10, v3
; SI-NEXT:    v_or_b32_e32 v4, v8, v4
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    s_cbranch_execnz .LBB35_3
; SI-NEXT:  .LBB35_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v14
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v13
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v10
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v12
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v11
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:  .LBB35_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB35_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5
; SI-NEXT:    s_branch .LBB35_2
;
; VI-LABEL: bitcast_v12f16_to_v6f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB35_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB35_4
; VI-NEXT:  .LBB35_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s21, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s21, v0
; VI-NEXT:    s_lshr_b32 s4, s20, 16
; VI-NEXT:    v_or_b32_e32 v5, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s20, v0
; VI-NEXT:    s_lshr_b32 s4, s19, 16
; VI-NEXT:    v_or_b32_e32 v4, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s19, v0
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_or_b32_e32 v3, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_or_b32_e32 v2, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v6, v1
; VI-NEXT:    v_mov_b32_e32 v6, s4
; VI-NEXT:    v_add_f16_sdwa v6, v6, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v6
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB35_3:
; VI-NEXT:    s_branch .LBB35_2
; VI-NEXT:  .LBB35_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12f16_to_v6f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB35_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB35_4
; GFX9-NEXT:  .LBB35_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v5, s21, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, s20, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, s19, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB35_3:
; GFX9-NEXT:    s_branch .LBB35_2
; GFX9-NEXT:  .LBB35_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12f16_to_v6f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB35_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB35_4
; GFX11-NEXT:  .LBB35_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, s5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, s4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB35_3:
; GFX11-NEXT:    s_branch .LBB35_2
; GFX11-NEXT:  .LBB35_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <12 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <12 x half> %a1 to <6 x float>
  br label %end

cmp.false:
  %a3 = bitcast <12 x half> %a to <6 x float>
  br label %end

end:
  %phi = phi <6 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x float> %phi
}

define <3 x double> @bitcast_v3i64_to_v3f64(<3 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v3i64_to_v3f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3i64_to_v3f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3i64_to_v3f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3i64_to_v3f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i64> %a, splat (i64 3)
  %a2 = bitcast <3 x i64> %a1 to <3 x double>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i64> %a to <3 x double>
  br label %end

end:
  %phi = phi <3 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x double> %phi
}

define inreg <3 x double> @bitcast_v3i64_to_v3f64_scalar(<3 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3i64_to_v3f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB37_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB37_3
; SI-NEXT:  .LBB37_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:    s_add_u32 s18, s18, 3
; SI-NEXT:    s_addc_u32 s19, s19, 0
; SI-NEXT:    s_add_u32 s20, s20, 3
; SI-NEXT:    s_addc_u32 s21, s21, 0
; SI-NEXT:  .LBB37_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB37_4:
; SI-NEXT:    s_branch .LBB37_2
;
; VI-LABEL: bitcast_v3i64_to_v3f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB37_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB37_3
; VI-NEXT:  .LBB37_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:  .LBB37_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB37_4:
; VI-NEXT:    s_branch .LBB37_2
;
; GFX9-LABEL: bitcast_v3i64_to_v3f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB37_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB37_3
; GFX9-NEXT:  .LBB37_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:  .LBB37_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB37_4:
; GFX9-NEXT:    s_branch .LBB37_2
;
; GFX11-LABEL: bitcast_v3i64_to_v3f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB37_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB37_3
; GFX11-NEXT:  .LBB37_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:  .LBB37_3: ; %end
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB37_4:
; GFX11-NEXT:    s_branch .LBB37_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i64> %a, splat (i64 3)
  %a2 = bitcast <3 x i64> %a1 to <3 x double>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i64> %a to <3 x double>
  br label %end

end:
  %phi = phi <3 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x double> %phi
}

define <3 x i64> @bitcast_v3f64_to_v3i64(<3 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v3f64_to_v3i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f64_to_v3i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB38_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:  .LBB38_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f64_to_v3i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB38_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:  .LBB38_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f64_to_v3i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB38_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:  .LBB38_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <3 x double> %a1 to <3 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <3 x double> %a to <3 x i64>
  br label %end

end:
  %phi = phi <3 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i64> %phi
}

define inreg <3 x i64> @bitcast_v3f64_to_v3i64_scalar(<3 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3f64_to_v3i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB39_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB39_4
; SI-NEXT:  .LBB39_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; SI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB39_3:
; SI-NEXT:    s_branch .LBB39_2
; SI-NEXT:  .LBB39_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f64_to_v3i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB39_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB39_4
; VI-NEXT:  .LBB39_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; VI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB39_3:
; VI-NEXT:    s_branch .LBB39_2
; VI-NEXT:  .LBB39_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f64_to_v3i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB39_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB39_4
; GFX9-NEXT:  .LBB39_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB39_3:
; GFX9-NEXT:    s_branch .LBB39_2
; GFX9-NEXT:  .LBB39_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f64_to_v3i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB39_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB39_4
; GFX11-NEXT:  .LBB39_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], s[4:5], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB39_3:
; GFX11-NEXT:    s_branch .LBB39_2
; GFX11-NEXT:  .LBB39_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <3 x double> %a1 to <3 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <3 x double> %a to <3 x i64>
  br label %end

end:
  %phi = phi <3 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i64> %phi
}

define <12 x i16> @bitcast_v3i64_to_v12i16(<3 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v3i64_to_v12i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, v5
; SI-NEXT:    v_mov_b32_e32 v8, v4
; SI-NEXT:    v_mov_b32_e32 v12, v3
; SI-NEXT:    v_mov_b32_e32 v4, v2
; SI-NEXT:    v_mov_b32_e32 v2, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v12, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB40_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v12, vcc, 0, v12, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v10, vcc, 0, v10, vcc
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v12, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  .LBB40_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v6, v12
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3i64_to_v12i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3i64_to_v12i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3i64_to_v12i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i64> %a, splat (i64 3)
  %a2 = bitcast <3 x i64> %a1 to <12 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i64> %a to <12 x i16>
  br label %end

end:
  %phi = phi <12 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i16> %phi
}

define inreg <12 x i16> @bitcast_v3i64_to_v12i16_scalar(<3 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3i64_to_v12i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB41_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v9, s21, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s19, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s21, 16
; SI-NEXT:    s_lshr_b32 s7, s19, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB41_3
; SI-NEXT:  .LBB41_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:    s_add_u32 s18, s18, 3
; SI-NEXT:    s_addc_u32 s19, s19, 0
; SI-NEXT:    s_add_u32 s20, s20, 3
; SI-NEXT:    s_addc_u32 s21, s21, 0
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v9, s21, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s19, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s21, 16
; SI-NEXT:    s_lshr_b32 s7, s19, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 16
; SI-NEXT:  .LBB41_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v3, s8
; SI-NEXT:    v_mov_b32_e32 v4, s18
; SI-NEXT:    v_mov_b32_e32 v6, s19
; SI-NEXT:    v_mov_b32_e32 v7, s7
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v10, s21
; SI-NEXT:    v_mov_b32_e32 v11, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB41_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB41_2
;
; VI-LABEL: bitcast_v3i64_to_v12i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB41_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB41_3
; VI-NEXT:  .LBB41_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB41_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB41_4:
; VI-NEXT:    s_branch .LBB41_2
;
; GFX9-LABEL: bitcast_v3i64_to_v12i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB41_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB41_3
; GFX9-NEXT:  .LBB41_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB41_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB41_4:
; GFX9-NEXT:    s_branch .LBB41_2
;
; GFX11-LABEL: bitcast_v3i64_to_v12i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB41_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB41_3
; GFX11-NEXT:  .LBB41_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB41_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB41_4:
; GFX11-NEXT:    s_branch .LBB41_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i64> %a, splat (i64 3)
  %a2 = bitcast <3 x i64> %a1 to <12 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i64> %a to <12 x i16>
  br label %end

end:
  %phi = phi <12 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i16> %phi
}

define <3 x i64> @bitcast_v12i16_to_v3i64(<12 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v12i16_to_v3i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v15, v4
; SI-NEXT:    v_mov_b32_e32 v14, v2
; SI-NEXT:    v_mov_b32_e32 v13, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v11
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB42_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB42_4
; SI-NEXT:  .LBB42_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB42_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v13
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v14
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v15
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v10
; SI-NEXT:    v_or_b32_e32 v0, v0, v18
; SI-NEXT:    v_or_b32_e32 v1, v1, v17
; SI-NEXT:    v_or_b32_e32 v2, v2, v16
; SI-NEXT:    v_or_b32_e32 v3, v3, v12
; SI-NEXT:    v_or_b32_e32 v4, v4, v9
; SI-NEXT:    v_or_b32_e32 v5, v5, v7
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB42_2
; SI-NEXT:  .LBB42_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v0, v18, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_or_b32_e32 v2, v16, v2
; SI-NEXT:    v_or_b32_e32 v3, v12, v3
; SI-NEXT:    v_or_b32_e32 v4, v9, v4
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x30000, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x30000, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x30000, v5
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12i16_to_v3i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB42_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v7, 3
; VI-NEXT:    v_add_u16_e32 v6, 3, v5
; VI-NEXT:    v_add_u16_sdwa v5, v5, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v6, v5
; VI-NEXT:    v_add_u16_e32 v6, 3, v4
; VI-NEXT:    v_add_u16_sdwa v4, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v6, v4
; VI-NEXT:    v_add_u16_e32 v6, 3, v3
; VI-NEXT:    v_add_u16_sdwa v3, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v6, v3
; VI-NEXT:    v_add_u16_e32 v6, 3, v2
; VI-NEXT:    v_add_u16_sdwa v2, v2, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v6, v2
; VI-NEXT:    v_add_u16_e32 v6, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v6, v1
; VI-NEXT:    v_add_u16_e32 v6, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v6, v0
; VI-NEXT:  .LBB42_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12i16_to_v3i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12i16_to_v3i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i16> %a, splat (i16 3)
  %a2 = bitcast <12 x i16> %a1 to <3 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i16> %a to <3 x i64>
  br label %end

end:
  %phi = phi <3 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i64> %phi
}

define inreg <3 x i64> @bitcast_v12i16_to_v3i64_scalar(<12 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12i16_to_v3i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB43_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_cbranch_execnz .LBB43_3
; SI-NEXT:  .LBB43_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:  .LBB43_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB43_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7_sgpr8_sgpr9
; SI-NEXT:    s_branch .LBB43_2
;
; VI-LABEL: bitcast_v12i16_to_v3i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB43_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB43_3
; VI-NEXT:  .LBB43_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s21, 3
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s20, 3
; VI-NEXT:    s_add_i32 s21, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s19, 3
; VI-NEXT:    s_add_i32 s20, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_add_i32 s19, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB43_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB43_4:
; VI-NEXT:    s_branch .LBB43_2
;
; GFX9-LABEL: bitcast_v12i16_to_v3i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB43_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB43_4
; GFX9-NEXT:  .LBB43_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v5, s21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB43_3:
; GFX9-NEXT:    s_branch .LBB43_2
; GFX9-NEXT:  .LBB43_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12i16_to_v3i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB43_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB43_4
; GFX11-NEXT:  .LBB43_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB43_3:
; GFX11-NEXT:    s_branch .LBB43_2
; GFX11-NEXT:  .LBB43_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i16> %a, splat (i16 3)
  %a2 = bitcast <12 x i16> %a1 to <3 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i16> %a to <3 x i64>
  br label %end

end:
  %phi = phi <3 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i64> %phi
}

define <12 x half> @bitcast_v3i64_to_v12f16(<3 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v3i64_to_v12f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v5
; SI-NEXT:    v_mov_b32_e32 v12, v4
; SI-NEXT:    v_mov_b32_e32 v15, v3
; SI-NEXT:    v_mov_b32_e32 v14, v2
; SI-NEXT:    v_mov_b32_e32 v17, v1
; SI-NEXT:    v_mov_b32_e32 v16, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB44_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB44_4
; SI-NEXT:  .LBB44_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB44_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB44_2
; SI-NEXT:  .LBB44_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v8, vcc, 0, v13, vcc
; SI-NEXT:    v_lshrrev_b32_e32 v16, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3i64_to_v12f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3i64_to_v12f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3i64_to_v12f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i64> %a, splat (i64 3)
  %a2 = bitcast <3 x i64> %a1 to <12 x half>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i64> %a to <12 x half>
  br label %end

end:
  %phi = phi <12 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x half> %phi
}

define inreg <12 x half> @bitcast_v3i64_to_v12f16_scalar(<3 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3i64_to_v12f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB45_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB45_3
; SI-NEXT:  .LBB45_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s4, s16, 3
; SI-NEXT:    s_addc_u32 s5, s17, 0
; SI-NEXT:    s_lshr_b32 s6, s4, 16
; SI-NEXT:    s_lshr_b32 s7, s5, 16
; SI-NEXT:    s_add_u32 s8, s18, 3
; SI-NEXT:    s_addc_u32 s9, s19, 0
; SI-NEXT:    s_lshr_b32 s10, s8, 16
; SI-NEXT:    s_lshr_b32 s11, s9, 16
; SI-NEXT:    s_add_u32 s12, s20, 3
; SI-NEXT:    s_addc_u32 s13, s21, 0
; SI-NEXT:    s_lshr_b32 s14, s12, 16
; SI-NEXT:    s_lshr_b32 s15, s13, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s13
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s12
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s8
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s15
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s14
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s11
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s10
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s6
; SI-NEXT:  .LBB45_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB45_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_branch .LBB45_2
;
; VI-LABEL: bitcast_v3i64_to_v12f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB45_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB45_3
; VI-NEXT:  .LBB45_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB45_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB45_4:
; VI-NEXT:    s_branch .LBB45_2
;
; GFX9-LABEL: bitcast_v3i64_to_v12f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB45_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB45_3
; GFX9-NEXT:  .LBB45_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB45_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB45_4:
; GFX9-NEXT:    s_branch .LBB45_2
;
; GFX11-LABEL: bitcast_v3i64_to_v12f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB45_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB45_3
; GFX11-NEXT:  .LBB45_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB45_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB45_4:
; GFX11-NEXT:    s_branch .LBB45_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i64> %a, splat (i64 3)
  %a2 = bitcast <3 x i64> %a1 to <12 x half>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i64> %a to <12 x half>
  br label %end

end:
  %phi = phi <12 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x half> %phi
}

define <3 x i64> @bitcast_v12f16_to_v3i64(<12 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v12f16_to_v3i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v10
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB46_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB46_4
; SI-NEXT:  .LBB46_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB46_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v20
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v18
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v16
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v14
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v0, v19, v0
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_or_b32_e32 v2, v15, v2
; SI-NEXT:    v_or_b32_e32 v3, v13, v3
; SI-NEXT:    v_or_b32_e32 v4, v8, v4
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB46_2
; SI-NEXT:  .LBB46_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v17
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v16
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v13
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v15
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v14
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12f16_to_v3i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB46_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v6, 0x200
; VI-NEXT:    v_add_f16_sdwa v7, v5, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v7
; VI-NEXT:    v_add_f16_sdwa v7, v4, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v7
; VI-NEXT:    v_add_f16_sdwa v7, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v7
; VI-NEXT:    v_add_f16_sdwa v7, v2, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v7
; VI-NEXT:    v_add_f16_sdwa v7, v1, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v6, v0, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v7
; VI-NEXT:    v_or_b32_e32 v0, v0, v6
; VI-NEXT:  .LBB46_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12f16_to_v3i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12f16_to_v3i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <12 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <12 x half> %a1 to <3 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <12 x half> %a to <3 x i64>
  br label %end

end:
  %phi = phi <3 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i64> %phi
}

define inreg <3 x i64> @bitcast_v12f16_to_v3i64_scalar(<12 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12f16_to_v3i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v17, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v16, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v15, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v14, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v13, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v12, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v11, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v9, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v8, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v7, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v6, s26
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB47_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v0, v16, v0
; SI-NEXT:    v_or_b32_e32 v1, v14, v1
; SI-NEXT:    v_or_b32_e32 v2, v12, v2
; SI-NEXT:    v_or_b32_e32 v3, v10, v3
; SI-NEXT:    v_or_b32_e32 v4, v8, v4
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    s_cbranch_execnz .LBB47_3
; SI-NEXT:  .LBB47_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v14
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v13
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v10
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v12
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v11
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:  .LBB47_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB47_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5
; SI-NEXT:    s_branch .LBB47_2
;
; VI-LABEL: bitcast_v12f16_to_v3i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB47_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB47_4
; VI-NEXT:  .LBB47_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s21, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s21, v0
; VI-NEXT:    s_lshr_b32 s4, s20, 16
; VI-NEXT:    v_or_b32_e32 v5, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s20, v0
; VI-NEXT:    s_lshr_b32 s4, s19, 16
; VI-NEXT:    v_or_b32_e32 v4, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s19, v0
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_or_b32_e32 v3, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_or_b32_e32 v2, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v6, v1
; VI-NEXT:    v_mov_b32_e32 v6, s4
; VI-NEXT:    v_add_f16_sdwa v6, v6, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v6
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB47_3:
; VI-NEXT:    s_branch .LBB47_2
; VI-NEXT:  .LBB47_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12f16_to_v3i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB47_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB47_4
; GFX9-NEXT:  .LBB47_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v5, s21, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, s20, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, s19, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB47_3:
; GFX9-NEXT:    s_branch .LBB47_2
; GFX9-NEXT:  .LBB47_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12f16_to_v3i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB47_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB47_4
; GFX11-NEXT:  .LBB47_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, s5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, s4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB47_3:
; GFX11-NEXT:    s_branch .LBB47_2
; GFX11-NEXT:  .LBB47_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <12 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <12 x half> %a1 to <3 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <12 x half> %a to <3 x i64>
  br label %end

end:
  %phi = phi <3 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i64> %phi
}

define <12 x i16> @bitcast_v3f64_to_v12i16(<3 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v3f64_to_v12i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v5
; SI-NEXT:    v_mov_b32_e32 v12, v4
; SI-NEXT:    v_mov_b32_e32 v15, v3
; SI-NEXT:    v_mov_b32_e32 v14, v2
; SI-NEXT:    v_mov_b32_e32 v17, v1
; SI-NEXT:    v_mov_b32_e32 v16, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v9, v13, v12, 16
; SI-NEXT:    v_alignbit_b32 v5, v15, v14, 16
; SI-NEXT:    v_alignbit_b32 v1, v17, v16, 16
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v13
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v17
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB48_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_alignbit_b32 v9, v13, v12, 16
; SI-NEXT:    v_alignbit_b32 v5, v15, v14, 16
; SI-NEXT:    v_alignbit_b32 v1, v17, v16, 16
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v13
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v17
; SI-NEXT:  .LBB48_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, v16
; SI-NEXT:    v_mov_b32_e32 v2, v17
; SI-NEXT:    v_mov_b32_e32 v4, v14
; SI-NEXT:    v_mov_b32_e32 v6, v15
; SI-NEXT:    v_mov_b32_e32 v8, v12
; SI-NEXT:    v_mov_b32_e32 v10, v13
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f64_to_v12i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB48_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB48_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f64_to_v12i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB48_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB48_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f64_to_v12i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB48_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB48_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <3 x double> %a1 to <12 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <3 x double> %a to <12 x i16>
  br label %end

end:
  %phi = phi <12 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i16> %phi
}

define inreg <12 x i16> @bitcast_v3f64_to_v12i16_scalar(<3 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3f64_to_v12i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB49_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v9, s21, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s19, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s8, s21, 16
; SI-NEXT:    s_lshr_b32 s7, s19, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB49_4
; SI-NEXT:  .LBB49_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[16:17], s[16:17], 1.0
; SI-NEXT:    v_add_f64 v[12:13], s[20:21], 1.0
; SI-NEXT:    v_add_f64 v[14:15], s[18:19], 1.0
; SI-NEXT:    v_alignbit_b32 v9, v13, v12, 16
; SI-NEXT:    v_alignbit_b32 v5, v15, v14, 16
; SI-NEXT:    v_alignbit_b32 v1, v17, v16, 16
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v13
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v17
; SI-NEXT:    s_branch .LBB49_5
; SI-NEXT:  .LBB49_3:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    s_branch .LBB49_2
; SI-NEXT:  .LBB49_4:
; SI-NEXT:    v_mov_b32_e32 v17, s17
; SI-NEXT:    v_mov_b32_e32 v16, s16
; SI-NEXT:    v_mov_b32_e32 v15, s19
; SI-NEXT:    v_mov_b32_e32 v14, s18
; SI-NEXT:    v_mov_b32_e32 v13, s21
; SI-NEXT:    v_mov_b32_e32 v12, s20
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:    v_mov_b32_e32 v7, s7
; SI-NEXT:    v_mov_b32_e32 v11, s8
; SI-NEXT:  .LBB49_5: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, v16
; SI-NEXT:    v_mov_b32_e32 v2, v17
; SI-NEXT:    v_mov_b32_e32 v4, v14
; SI-NEXT:    v_mov_b32_e32 v6, v15
; SI-NEXT:    v_mov_b32_e32 v8, v12
; SI-NEXT:    v_mov_b32_e32 v10, v13
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f64_to_v12i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB49_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB49_4
; VI-NEXT:  .LBB49_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; VI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB49_3:
; VI-NEXT:    s_branch .LBB49_2
; VI-NEXT:  .LBB49_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f64_to_v12i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB49_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB49_4
; GFX9-NEXT:  .LBB49_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB49_3:
; GFX9-NEXT:    s_branch .LBB49_2
; GFX9-NEXT:  .LBB49_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f64_to_v12i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB49_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB49_4
; GFX11-NEXT:  .LBB49_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[4:5], s[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB49_3:
; GFX11-NEXT:    s_branch .LBB49_2
; GFX11-NEXT:  .LBB49_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <3 x double> %a1 to <12 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <3 x double> %a to <12 x i16>
  br label %end

end:
  %phi = phi <12 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i16> %phi
}

define <3 x double> @bitcast_v12i16_to_v3f64(<12 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v12i16_to_v3f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v15, v4
; SI-NEXT:    v_mov_b32_e32 v14, v2
; SI-NEXT:    v_mov_b32_e32 v13, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v11
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB50_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB50_4
; SI-NEXT:  .LBB50_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB50_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v13
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v14
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v15
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v10
; SI-NEXT:    v_or_b32_e32 v0, v0, v18
; SI-NEXT:    v_or_b32_e32 v1, v1, v17
; SI-NEXT:    v_or_b32_e32 v2, v2, v16
; SI-NEXT:    v_or_b32_e32 v3, v3, v12
; SI-NEXT:    v_or_b32_e32 v4, v4, v9
; SI-NEXT:    v_or_b32_e32 v5, v5, v7
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB50_2
; SI-NEXT:  .LBB50_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v0, v18, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_or_b32_e32 v2, v16, v2
; SI-NEXT:    v_or_b32_e32 v3, v12, v3
; SI-NEXT:    v_or_b32_e32 v4, v9, v4
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x30000, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x30000, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x30000, v5
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12i16_to_v3f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB50_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v7, 3
; VI-NEXT:    v_add_u16_e32 v6, 3, v5
; VI-NEXT:    v_add_u16_sdwa v5, v5, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v6, v5
; VI-NEXT:    v_add_u16_e32 v6, 3, v4
; VI-NEXT:    v_add_u16_sdwa v4, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v6, v4
; VI-NEXT:    v_add_u16_e32 v6, 3, v3
; VI-NEXT:    v_add_u16_sdwa v3, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v6, v3
; VI-NEXT:    v_add_u16_e32 v6, 3, v2
; VI-NEXT:    v_add_u16_sdwa v2, v2, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v6, v2
; VI-NEXT:    v_add_u16_e32 v6, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v6, v1
; VI-NEXT:    v_add_u16_e32 v6, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v6, v0
; VI-NEXT:  .LBB50_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12i16_to_v3f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12i16_to_v3f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i16> %a, splat (i16 3)
  %a2 = bitcast <12 x i16> %a1 to <3 x double>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i16> %a to <3 x double>
  br label %end

end:
  %phi = phi <3 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x double> %phi
}

define inreg <3 x double> @bitcast_v12i16_to_v3f64_scalar(<12 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12i16_to_v3f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB51_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_cbranch_execnz .LBB51_3
; SI-NEXT:  .LBB51_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:  .LBB51_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB51_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7_sgpr8_sgpr9
; SI-NEXT:    s_branch .LBB51_2
;
; VI-LABEL: bitcast_v12i16_to_v3f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB51_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB51_3
; VI-NEXT:  .LBB51_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s21, 3
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s20, 3
; VI-NEXT:    s_add_i32 s21, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s19, 3
; VI-NEXT:    s_add_i32 s20, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_add_i32 s19, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB51_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB51_4:
; VI-NEXT:    s_branch .LBB51_2
;
; GFX9-LABEL: bitcast_v12i16_to_v3f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB51_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB51_4
; GFX9-NEXT:  .LBB51_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v5, s21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB51_3:
; GFX9-NEXT:    s_branch .LBB51_2
; GFX9-NEXT:  .LBB51_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12i16_to_v3f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB51_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB51_4
; GFX11-NEXT:  .LBB51_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB51_3:
; GFX11-NEXT:    s_branch .LBB51_2
; GFX11-NEXT:  .LBB51_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i16> %a, splat (i16 3)
  %a2 = bitcast <12 x i16> %a1 to <3 x double>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i16> %a to <3 x double>
  br label %end

end:
  %phi = phi <3 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x double> %phi
}

define <12 x half> @bitcast_v3f64_to_v12f16(<3 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v3f64_to_v12f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB52_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v6
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v6
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v6
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v6
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v0
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:  .LBB52_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB52_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v0
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v0
; SI-NEXT:  .LBB52_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, v15
; SI-NEXT:    v_mov_b32_e32 v1, v17
; SI-NEXT:    v_mov_b32_e32 v2, v13
; SI-NEXT:    v_mov_b32_e32 v3, v16
; SI-NEXT:    v_mov_b32_e32 v4, v12
; SI-NEXT:    v_mov_b32_e32 v5, v14
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f64_to_v12f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB52_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB52_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f64_to_v12f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB52_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB52_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f64_to_v12f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB52_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB52_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <3 x double> %a1 to <12 x half>
  br label %end

cmp.false:
  %a3 = bitcast <3 x double> %a to <12 x half>
  br label %end

end:
  %phi = phi <12 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x half> %phi
}

define inreg <12 x half> @bitcast_v3f64_to_v12f16_scalar(<3 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3f64_to_v12f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB53_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB53_3
; SI-NEXT:  .LBB53_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[14:15], s[20:21], 1.0
; SI-NEXT:    v_add_f64 v[16:17], s[18:19], 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v1
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v14
; SI-NEXT:    v_add_f64 v[12:13], s[16:17], 1.0
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v1
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v1
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v1
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v1
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:  .LBB53_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB53_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_branch .LBB53_2
;
; VI-LABEL: bitcast_v3f64_to_v12f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB53_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB53_4
; VI-NEXT:  .LBB53_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; VI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB53_3:
; VI-NEXT:    s_branch .LBB53_2
; VI-NEXT:  .LBB53_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f64_to_v12f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB53_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB53_4
; GFX9-NEXT:  .LBB53_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB53_3:
; GFX9-NEXT:    s_branch .LBB53_2
; GFX9-NEXT:  .LBB53_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f64_to_v12f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB53_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB53_4
; GFX11-NEXT:  .LBB53_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[4:5], s[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB53_3:
; GFX11-NEXT:    s_branch .LBB53_2
; GFX11-NEXT:  .LBB53_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <3 x double> %a1 to <12 x half>
  br label %end

cmp.false:
  %a3 = bitcast <3 x double> %a to <12 x half>
  br label %end

end:
  %phi = phi <12 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x half> %phi
}

define <3 x double> @bitcast_v12f16_to_v3f64(<12 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v12f16_to_v3f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v10
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB54_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB54_4
; SI-NEXT:  .LBB54_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB54_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v20
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v18
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v16
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v14
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v0, v19, v0
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_or_b32_e32 v2, v15, v2
; SI-NEXT:    v_or_b32_e32 v3, v13, v3
; SI-NEXT:    v_or_b32_e32 v4, v8, v4
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB54_2
; SI-NEXT:  .LBB54_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v17
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v16
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v13
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v15
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v14
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12f16_to_v3f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB54_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v6, 0x200
; VI-NEXT:    v_add_f16_sdwa v7, v5, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v7
; VI-NEXT:    v_add_f16_sdwa v7, v4, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v7
; VI-NEXT:    v_add_f16_sdwa v7, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v7
; VI-NEXT:    v_add_f16_sdwa v7, v2, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v7
; VI-NEXT:    v_add_f16_sdwa v7, v1, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v6, v0, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v7
; VI-NEXT:    v_or_b32_e32 v0, v0, v6
; VI-NEXT:  .LBB54_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12f16_to_v3f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12f16_to_v3f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <12 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <12 x half> %a1 to <3 x double>
  br label %end

cmp.false:
  %a3 = bitcast <12 x half> %a to <3 x double>
  br label %end

end:
  %phi = phi <3 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x double> %phi
}

define inreg <3 x double> @bitcast_v12f16_to_v3f64_scalar(<12 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12f16_to_v3f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v17, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v16, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v15, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v14, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v13, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v12, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v11, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v9, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v8, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v7, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v6, s26
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB55_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v0, v16, v0
; SI-NEXT:    v_or_b32_e32 v1, v14, v1
; SI-NEXT:    v_or_b32_e32 v2, v12, v2
; SI-NEXT:    v_or_b32_e32 v3, v10, v3
; SI-NEXT:    v_or_b32_e32 v4, v8, v4
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    s_cbranch_execnz .LBB55_3
; SI-NEXT:  .LBB55_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v14
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v13
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v10
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v12
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v11
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:  .LBB55_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB55_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5
; SI-NEXT:    s_branch .LBB55_2
;
; VI-LABEL: bitcast_v12f16_to_v3f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB55_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB55_4
; VI-NEXT:  .LBB55_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s21, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s21, v0
; VI-NEXT:    s_lshr_b32 s4, s20, 16
; VI-NEXT:    v_or_b32_e32 v5, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s20, v0
; VI-NEXT:    s_lshr_b32 s4, s19, 16
; VI-NEXT:    v_or_b32_e32 v4, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s19, v0
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_or_b32_e32 v3, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_or_b32_e32 v2, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v6, v1
; VI-NEXT:    v_mov_b32_e32 v6, s4
; VI-NEXT:    v_add_f16_sdwa v6, v6, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v6
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB55_3:
; VI-NEXT:    s_branch .LBB55_2
; VI-NEXT:  .LBB55_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12f16_to_v3f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB55_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB55_4
; GFX9-NEXT:  .LBB55_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v5, s21, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, s20, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, s19, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB55_3:
; GFX9-NEXT:    s_branch .LBB55_2
; GFX9-NEXT:  .LBB55_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12f16_to_v3f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB55_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB55_4
; GFX11-NEXT:  .LBB55_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, s5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, s4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB55_3:
; GFX11-NEXT:    s_branch .LBB55_2
; GFX11-NEXT:  .LBB55_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <12 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <12 x half> %a1 to <3 x double>
  br label %end

cmp.false:
  %a3 = bitcast <12 x half> %a to <3 x double>
  br label %end

end:
  %phi = phi <3 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x double> %phi
}

define <12 x half> @bitcast_v12i16_to_v12f16(<12 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v12i16_to_v12f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v23, v11
; SI-NEXT:    v_mov_b32_e32 v22, v10
; SI-NEXT:    v_mov_b32_e32 v21, v9
; SI-NEXT:    v_mov_b32_e32 v20, v8
; SI-NEXT:    v_mov_b32_e32 v19, v7
; SI-NEXT:    v_mov_b32_e32 v18, v6
; SI-NEXT:    v_mov_b32_e32 v17, v5
; SI-NEXT:    v_mov_b32_e32 v16, v4
; SI-NEXT:    v_mov_b32_e32 v15, v3
; SI-NEXT:    v_mov_b32_e32 v14, v2
; SI-NEXT:    v_mov_b32_e32 v13, v1
; SI-NEXT:    v_mov_b32_e32 v24, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB56_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB56_4
; SI-NEXT:  .LBB56_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB56_3: ; %cmp.false
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v23
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB56_2
; SI-NEXT:  .LBB56_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12i16_to_v12f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB56_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v6, 3
; VI-NEXT:    v_add_u16_sdwa v7, v0, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v8, v1, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v9, v2, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v10, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v11, v4, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v6, v5, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v5, 3, v5
; VI-NEXT:    v_add_u16_e32 v4, 3, v4
; VI-NEXT:    v_add_u16_e32 v3, 3, v3
; VI-NEXT:    v_add_u16_e32 v2, 3, v2
; VI-NEXT:    v_add_u16_e32 v1, 3, v1
; VI-NEXT:    v_add_u16_e32 v0, 3, v0
; VI-NEXT:    v_or_b32_e32 v5, v5, v6
; VI-NEXT:    v_or_b32_e32 v4, v4, v11
; VI-NEXT:    v_or_b32_e32 v3, v3, v10
; VI-NEXT:    v_or_b32_e32 v2, v2, v9
; VI-NEXT:    v_or_b32_e32 v1, v1, v8
; VI-NEXT:    v_or_b32_e32 v0, v0, v7
; VI-NEXT:  .LBB56_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12i16_to_v12f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12i16_to_v12f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i16> %a, splat (i16 3)
  %a2 = bitcast <12 x i16> %a1 to <12 x half>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i16> %a to <12 x half>
  br label %end

end:
  %phi = phi <12 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x half> %phi
}

define inreg <12 x half> @bitcast_v12i16_to_v12f16_scalar(<12 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12i16_to_v12f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB57_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s27
; SI-NEXT:    s_cbranch_execnz .LBB57_3
; SI-NEXT:  .LBB57_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s27, s27, 3
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_add_i32 s25, s25, 3
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s27
; SI-NEXT:  .LBB57_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB57_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_branch .LBB57_2
;
; VI-LABEL: bitcast_v12i16_to_v12f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB57_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB57_3
; VI-NEXT:  .LBB57_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s7, s17, 3
; VI-NEXT:    s_add_i32 s9, s18, 3
; VI-NEXT:    s_add_i32 s11, s19, 3
; VI-NEXT:    s_add_i32 s13, s20, 3
; VI-NEXT:    s_add_i32 s15, s21, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s6, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s8, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s10, s19, 0xffff0000
; VI-NEXT:    s_and_b32 s12, s20, 0xffff0000
; VI-NEXT:    s_and_b32 s14, s21, 0xffff0000
; VI-NEXT:    s_and_b32 s15, s15, 0xffff
; VI-NEXT:    s_and_b32 s13, s13, 0xffff
; VI-NEXT:    s_and_b32 s11, s11, 0xffff
; VI-NEXT:    s_and_b32 s9, s9, 0xffff
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s14, s14, s15
; VI-NEXT:    s_or_b32 s12, s12, s13
; VI-NEXT:    s_or_b32 s10, s10, s11
; VI-NEXT:    s_or_b32 s8, s8, s9
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s21, s14, 0x30000
; VI-NEXT:    s_add_i32 s20, s12, 0x30000
; VI-NEXT:    s_add_i32 s19, s10, 0x30000
; VI-NEXT:    s_add_i32 s18, s8, 0x30000
; VI-NEXT:    s_add_i32 s17, s6, 0x30000
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB57_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB57_4:
; VI-NEXT:    s_branch .LBB57_2
;
; GFX9-LABEL: bitcast_v12i16_to_v12f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB57_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB57_4
; GFX9-NEXT:  .LBB57_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v5, s21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB57_3:
; GFX9-NEXT:    s_branch .LBB57_2
; GFX9-NEXT:  .LBB57_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12i16_to_v12f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB57_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB57_4
; GFX11-NEXT:  .LBB57_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB57_3:
; GFX11-NEXT:    s_branch .LBB57_2
; GFX11-NEXT:  .LBB57_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i16> %a, splat (i16 3)
  %a2 = bitcast <12 x i16> %a1 to <12 x half>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i16> %a to <12 x half>
  br label %end

end:
  %phi = phi <12 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x half> %phi
}

define <12 x i16> @bitcast_v12f16_to_v12i16(<12 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v12f16_to_v12i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB58_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v11
; SI-NEXT:    v_or_b32_e32 v10, v10, v12
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; SI-NEXT:    v_or_b32_e32 v6, v6, v12
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_or_b32_e32 v2, v2, v12
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_or_b32_e32 v8, v8, v9
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v9, 16
; SI-NEXT:  .LBB58_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12f16_to_v12i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB58_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v7, 0x200
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v0
; VI-NEXT:    v_add_f16_sdwa v0, v0, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v9, 0x200, v2
; VI-NEXT:    v_add_f16_sdwa v2, v2, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v10, 0x200, v3
; VI-NEXT:    v_add_f16_sdwa v3, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v11, 0x200, v4
; VI-NEXT:    v_add_f16_sdwa v4, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v12, 0x200, v5
; VI-NEXT:    v_add_f16_sdwa v5, v5, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v12, v5
; VI-NEXT:    v_or_b32_e32 v4, v11, v4
; VI-NEXT:    v_or_b32_e32 v3, v10, v3
; VI-NEXT:    v_or_b32_e32 v2, v9, v2
; VI-NEXT:    v_or_b32_e32 v1, v8, v1
; VI-NEXT:    v_or_b32_e32 v0, v6, v0
; VI-NEXT:  .LBB58_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12f16_to_v12i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12f16_to_v12i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v6
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <12 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <12 x half> %a1 to <12 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <12 x half> %a to <12 x i16>
  br label %end

end:
  %phi = phi <12 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i16> %phi
}

define inreg <12 x i16> @bitcast_v12f16_to_v12i16_scalar(<12 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12f16_to_v12i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v1, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v2, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v3, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v4, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v5, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v6, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v7, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v8, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v9, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s26
; SI-NEXT:    v_cvt_f16_f32_e32 v11, s27
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB59_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB59_3
; SI-NEXT:  .LBB59_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v11
; SI-NEXT:    v_or_b32_e32 v10, v10, v12
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; SI-NEXT:    v_or_b32_e32 v6, v6, v12
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_or_b32_e32 v2, v2, v12
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_or_b32_e32 v8, v8, v9
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v9, 16
; SI-NEXT:  .LBB59_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB59_4:
; SI-NEXT:    s_branch .LBB59_2
;
; VI-LABEL: bitcast_v12f16_to_v12i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s22, 0
; VI-NEXT:    s_cbranch_scc0 .LBB59_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB59_4
; VI-NEXT:  .LBB59_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    s_lshr_b32 s4, s19, 16
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    s_lshr_b32 s4, s20, 16
; VI-NEXT:    v_mov_b32_e32 v5, s4
; VI-NEXT:    s_lshr_b32 s4, s21, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v12, s4
; VI-NEXT:    v_add_f16_e32 v6, s16, v0
; VI-NEXT:    v_add_f16_sdwa v7, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, s17, v0
; VI-NEXT:    v_add_f16_sdwa v8, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    v_add_f16_sdwa v9, v3, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, s19, v0
; VI-NEXT:    v_add_f16_sdwa v10, v4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, s20, v0
; VI-NEXT:    v_add_f16_sdwa v11, v5, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, s21, v0
; VI-NEXT:    v_add_f16_sdwa v0, v12, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v5, v0
; VI-NEXT:    v_or_b32_e32 v4, v4, v11
; VI-NEXT:    v_or_b32_e32 v3, v3, v10
; VI-NEXT:    v_or_b32_e32 v2, v2, v9
; VI-NEXT:    v_or_b32_e32 v1, v1, v8
; VI-NEXT:    v_or_b32_e32 v0, v6, v7
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB59_3:
; VI-NEXT:    s_branch .LBB59_2
; VI-NEXT:  .LBB59_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12f16_to_v12i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s22, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB59_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB59_4
; GFX9-NEXT:  .LBB59_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v5, s21, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, s20, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, s19, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB59_3:
; GFX9-NEXT:    s_branch .LBB59_2
; GFX9-NEXT:  .LBB59_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v12f16_to_v12i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s18, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB59_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB59_4
; GFX11-NEXT:  .LBB59_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, s5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, s4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB59_3:
; GFX11-NEXT:    s_branch .LBB59_2
; GFX11-NEXT:  .LBB59_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <12 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <12 x half> %a1 to <12 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <12 x half> %a to <12 x i16>
  br label %end

end:
  %phi = phi <12 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i16> %phi
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX11-FAKE16: {{.*}}
; GFX11-TRUE16: {{.*}}
