/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.StringUtilities;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class TextNode
extends AstNode {
    private String _text;
    private TextLocation _startLocation;
    private TextLocation _endLocation;

    public TextNode() {
    }

    public TextNode(String text) {
        this(text, TextLocation.EMPTY, TextLocation.EMPTY);
    }

    public TextNode(String text, TextLocation startLocation, TextLocation endLocation) {
        this._text = text;
        this._startLocation = startLocation;
        this._endLocation = endLocation;
    }

    @Override
    public final String getText() {
        return this._text;
    }

    public final void setText(String text) {
        this.verifyNotFrozen();
        this._text = text;
    }

    @Override
    public final TextLocation getStartLocation() {
        return this._startLocation;
    }

    public final void setStartLocation(TextLocation startLocation) {
        this.verifyNotFrozen();
        this._startLocation = startLocation;
    }

    @Override
    public final TextLocation getEndLocation() {
        return this._endLocation;
    }

    public final void setEndLocation(TextLocation endLocation) {
        this.verifyNotFrozen();
        this._endLocation = endLocation;
    }

    public Role<? extends TextNode> getRole() {
        return super.getRole();
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitText(this, data);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.WHITESPACE;
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof TextNode && StringUtilities.equals((String)this.getText(), (String)((TextNode)other).getText());
    }
}

