/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.services;

import java.util.Set;
import org.apache.sling.testing.mock.sling.services.MockSlingSettingService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class MockSlingSettingServiceTest {
    @Test
    public void testDefaultRunModes() {
        Set<String> defaultRunModes = Set.of("mode0");
        MockSlingSettingService underTest = new MockSlingSettingService(defaultRunModes);
        Assert.assertEquals(defaultRunModes, (Object)underTest.getRunModes());
        Set<String> newRunModes = Set.of("mode1", "mode2");
        underTest.setRunModes(newRunModes);
        Assert.assertEquals(newRunModes, (Object)underTest.getRunModes());
    }

    @Test
    public void testNoDefaultRunModes() {
        MockSlingSettingService underTest = new MockSlingSettingService();
        Assert.assertTrue((boolean)underTest.getRunModes().isEmpty());
        Set<String> newRunModes = Set.of("mode1", "mode2");
        underTest.setRunModes(newRunModes);
        Assert.assertEquals(newRunModes, (Object)underTest.getRunModes());
    }

    @Test
    public void slingId() {
        MatcherAssert.assertThat((Object)new MockSlingSettingService().getSlingId(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetAbsolutePathWithinSlingHome() {
        MockSlingSettingService underTest = new MockSlingSettingService();
        Assert.assertThrows(UnsupportedOperationException.class, () -> underTest.getAbsolutePathWithinSlingHome("relPath1"));
    }

    @Test
    public void testGetSlingHomePath() {
        MockSlingSettingService underTest = new MockSlingSettingService();
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((MockSlingSettingService)underTest).getSlingHomePath());
    }

    @Test
    public void testGetSlingHome() {
        MockSlingSettingService underTest = new MockSlingSettingService();
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((MockSlingSettingService)underTest).getSlingHome());
    }

    @Test
    public void testGetSlingName() {
        MockSlingSettingService underTest = new MockSlingSettingService();
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((MockSlingSettingService)underTest).getSlingName());
    }

    @Test
    public void testGetSlingDescription() {
        MockSlingSettingService underTest = new MockSlingSettingService();
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((MockSlingSettingService)underTest).getSlingDescription());
    }

    @Test
    public void testGetBestRunModeMatchCountFromSpec() {
        MockSlingSettingService underTest = new MockSlingSettingService();
        Assert.assertThrows(UnsupportedOperationException.class, () -> underTest.getBestRunModeMatchCountFromSpec("test"));
    }
}

