/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.sling.testing.mock.jcr.MockJcr;
import org.apache.sling.testing.mock.sling.NodeTypeDefinitionScanner;
import org.apache.sling.testing.mock.sling.NodeTypeMode;
import org.junit.Assert;
import org.junit.Test;

public class NodeTypeDefinitionScannerTest {
    @Test
    public void testGetNodeTypeDefinitions() throws Exception {
        List definitions = NodeTypeDefinitionScanner.get().getNodeTypeDefinitions();
        Assert.assertTrue((boolean)definitions.contains("SLING-INF/nodetypes/folder.cnd"));
        Assert.assertTrue((boolean)definitions.contains("SLING-INF/nodetypes/resource.cnd"));
    }

    @Test
    public void testRegistersNodeTypes() throws Exception {
        Session session = MockJcr.newSession();
        MockJcr.loadNodeTypeDefs((Session)session, (Reader)new StringReader("[nt:hierarchyNode] > nt:base\n[nt:folder] > nt:hierarchyNode"));
        NodeTypeDefinitionScanner.get().register(session, NodeTypeMode.NODETYPES_REQUIRED);
        HashSet<String> nodeTypes = new HashSet<String>();
        NodeTypeIterator nodeTypeIterator = session.getWorkspace().getNodeTypeManager().getAllNodeTypes();
        while (nodeTypeIterator.hasNext()) {
            nodeTypes.add(nodeTypeIterator.nextNodeType().getName());
        }
        Assert.assertTrue((boolean)nodeTypes.containsAll(Set.of("sling:Folder", "sling:HierarchyNode", "sling:OrderedFolder", "sling:Resource", "sling:ResourceSuperType")));
    }
}

