/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.ServiceConfig;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component
public class Service7 {
    private boolean activated;
    private ComponentContext componentContext;
    private BundleContext bundleContext;
    private Map<String, Object> map;

    @Activate
    private void activate(ComponentContext componentContext, ServiceConfig config, BundleContext bundleContext) {
        this.activated = true;
        this.componentContext = componentContext;
        this.bundleContext = bundleContext;
        this.map = Service7.readAnnotationToMap(config);
    }

    @Deactivate
    private void deactivate() {
        this.activated = false;
        this.componentContext = null;
        this.bundleContext = null;
        this.map = null;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public ComponentContext getComponentContext() {
        return this.componentContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    static Map<String, Object> readAnnotationToMap(ServiceConfig config) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("prop1", config.prop1());
        map.put("prop2.with.periods", config.prop2_with_periods());
        map.put("prop3-with-hyphens", config.prop3$_$with$_$hyphens());
        return map;
    }
}

