/*
 * Decompiled with CFR 0.152.
 */
package osgimock.org.apache.felix.framework.wiring;

import java.util.Collections;
import java.util.Map;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import osgimock.org.apache.felix.framework.capabilityset.CapabilitySet;
import osgimock.org.apache.felix.framework.capabilityset.SimpleFilter;
import osgimock.org.apache.felix.framework.util.Util;
import osgimock.org.apache.felix.framework.wiring.BundleCapabilityImpl;

public class BundleRequirementImpl
implements BundleRequirement {
    private final BundleRevision m_revision;
    private final String m_namespace;
    private final SimpleFilter m_filter;
    private final boolean m_optional;
    private final Map<String, String> m_dirs;
    private final Map<String, Object> m_attrs;

    public BundleRequirementImpl(BundleRevision revision, String namespace, Map<String, String> dirs, Map<String, Object> attrs, SimpleFilter filter) {
        this.m_revision = revision;
        this.m_namespace = namespace;
        this.m_dirs = Util.newImmutableMap(dirs);
        this.m_attrs = Util.newImmutableMap(attrs);
        this.m_filter = filter;
        boolean optional = false;
        if (this.m_dirs.containsKey("resolution") && this.m_dirs.get("resolution").equals("optional")) {
            optional = true;
        }
        this.m_optional = optional;
    }

    public BundleRequirementImpl(BundleRevision revision, String namespace, Map<String, String> dirs, Map<String, Object> attrs) {
        this(revision, namespace, dirs, Collections.EMPTY_MAP, SimpleFilter.convert(attrs));
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public Map<String, String> getDirectives() {
        return this.m_dirs;
    }

    public Map<String, Object> getAttributes() {
        return this.m_attrs;
    }

    public BundleRevision getResource() {
        return this.m_revision;
    }

    public BundleRevision getRevision() {
        return this.m_revision;
    }

    public boolean matches(BundleCapability cap) {
        return CapabilitySet.matches((Capability)((BundleCapabilityImpl)cap), this.getFilter());
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public SimpleFilter getFilter() {
        return this.m_filter;
    }

    public String toString() {
        return "[" + this.m_revision + "] " + this.m_namespace + "; " + this.getFilter().toString();
    }
}

