/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.Set;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.TreeBidiMap;

class MockNamespaceRegistry
implements NamespaceRegistry {
    private final BidiMap<String, String> namespacePrefixMapping = new TreeBidiMap();

    public MockNamespaceRegistry() {
        this.namespacePrefixMapping.put((Object)"jcr", (Object)"http://www.jcp.org/jcr/1.0");
    }

    public String getURI(String prefix) throws RepositoryException {
        return (String)this.namespacePrefixMapping.get((Object)prefix);
    }

    public String getPrefix(String uri) throws RepositoryException {
        return (String)this.namespacePrefixMapping.getKey((Object)uri);
    }

    public void registerNamespace(String prefix, String uri) throws RepositoryException {
        this.namespacePrefixMapping.put((Object)prefix, (Object)uri);
    }

    public void unregisterNamespace(String prefix) throws RepositoryException {
        this.namespacePrefixMapping.remove((Object)prefix);
    }

    public String[] getPrefixes() throws RepositoryException {
        Set keys = this.namespacePrefixMapping.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public String[] getURIs() throws RepositoryException {
        Set values = this.namespacePrefixMapping.values();
        return values.toArray(new String[values.size()]);
    }
}

