/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.plugin.ratelimiter.algorithm;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

/**
 * test for ConcurrentRateLimiterAlgorithm.
 */
@ExtendWith(MockitoExtension.class)
public final class ConcurrentRateLimiterAlgorithmTest {

    private ConcurrentRateLimiterAlgorithm concurrentRateLimiterAlgorithm;

    @BeforeEach
    public void startup() {
        concurrentRateLimiterAlgorithm = new ConcurrentRateLimiterAlgorithm();
    }

    @Test
    public void getScriptNameTest() {
        assertThat("concurrent_request_rate_limiter.lua", is(concurrentRateLimiterAlgorithm.getScriptName()));
    }

    @Test
    public void getKeyNameTest() {
        assertThat("concurrent_request_rate_limiter", is(concurrentRateLimiterAlgorithm.getKeyName()));
    }
}
