/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.netty;

import com.alipay.sofa.rpc.common.BatchExecutorQueue;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import java.util.concurrent.Executor;

public class NettyBatchWriteQueue
extends BatchExecutorQueue<MessageTuple> {
    private final Channel channel;
    private final EventLoop eventLoop;

    private NettyBatchWriteQueue(Channel channel) {
        this.channel = channel;
        this.eventLoop = channel.eventLoop();
    }

    public ChannelFuture enqueue(Object message) {
        return this.enqueue(message, this.channel.newPromise());
    }

    public ChannelFuture enqueue(Object message, ChannelPromise channelPromise) {
        MessageTuple messageTuple = new MessageTuple(message, channelPromise);
        super.enqueue(messageTuple, (Executor)this.eventLoop);
        return messageTuple.channelPromise;
    }

    @Override
    protected void prepare(MessageTuple item) {
        this.channel.write(item.originMessage, item.channelPromise);
    }

    @Override
    protected void flush(MessageTuple item) {
        this.prepare(item);
        this.channel.flush();
    }

    public static NettyBatchWriteQueue createWriteQueue(Channel channel) {
        return new NettyBatchWriteQueue(channel);
    }

    static class MessageTuple {
        private final Object originMessage;
        private final ChannelPromise channelPromise;

        public MessageTuple(Object originMessage, ChannelPromise channelPromise) {
            this.originMessage = originMessage;
            this.channelPromise = channelPromise;
        }
    }
}

