/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.http;

import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.common.cache.ReflectCache;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.utils.ClassTypeUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ServerStartedEvent;
import com.alipay.sofa.rpc.event.ServerStoppedEvent;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.server.BusinessPool;
import com.alipay.sofa.rpc.server.Server;
import com.alipay.sofa.rpc.server.SofaRejectedExecutionHandler;
import com.alipay.sofa.rpc.server.http.HttpServerHandler;
import com.alipay.sofa.rpc.transport.ServerTransport;
import com.alipay.sofa.rpc.transport.ServerTransportConfig;
import com.alipay.sofa.rpc.transport.ServerTransportFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class AbstractHttpServer
implements Server {
    protected final String container;
    protected volatile boolean started;
    protected ServerConfig serverConfig;
    protected ServerTransportConfig serverTransportConfig;
    protected HttpServerHandler serverHandler;
    private ServerTransport serverTransport;
    protected ThreadPoolExecutor bizThreadPool;

    public AbstractHttpServer(String container) {
        this.container = container;
    }

    @Override
    public void init(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.serverTransportConfig = AbstractHttpServer.convertConfig(serverConfig);
        this.bizThreadPool = this.initThreadPool(serverConfig);
        this.serverHandler = new HttpServerHandler();
        this.serverTransportConfig.setContainer(this.container);
        this.serverTransportConfig.setServerHandler(this.serverHandler);
    }

    protected ThreadPoolExecutor initThreadPool(ServerConfig serverConfig) {
        ThreadPoolExecutor threadPool = BusinessPool.initPool(serverConfig);
        threadPool.setThreadFactory(new NamedThreadFactory("SEV-" + serverConfig.getProtocol().toUpperCase() + "-BIZ-" + serverConfig.getPort(), serverConfig.isDaemon()));
        threadPool.setRejectedExecutionHandler(new SofaRejectedExecutionHandler());
        if (serverConfig.isPreStartCore()) {
            threadPool.prestartAllCoreThreads();
        }
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.started) {
            return;
        }
        AbstractHttpServer abstractHttpServer = this;
        synchronized (abstractHttpServer) {
            if (this.started) {
                return;
            }
            try {
                this.bizThreadPool = this.initThreadPool(this.serverConfig);
                this.serverHandler.setBizThreadPool(this.bizThreadPool);
                this.serverTransport = ServerTransportFactory.getServerTransport(this.serverTransportConfig);
                this.started = this.serverTransport.start();
                if (this.started && EventBus.isEnable(ServerStartedEvent.class)) {
                    EventBus.post(new ServerStartedEvent(this.serverConfig, this.bizThreadPool));
                }
            }
            catch (SofaRpcRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("010000024", "HTTP/2"), e);
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean hasNoEntry() {
        return this.serverHandler.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        AbstractHttpServer abstractHttpServer = this;
        synchronized (abstractHttpServer) {
            if (!this.started) {
                return;
            }
            this.serverTransport.stop();
            this.serverTransport = null;
            if (this.bizThreadPool != null) {
                this.bizThreadPool.shutdown();
                this.bizThreadPool = null;
                this.serverHandler.setBizThreadPool(null);
            }
            this.started = false;
            if (EventBus.isEnable(ServerStoppedEvent.class)) {
                EventBus.post(new ServerStoppedEvent(this.serverConfig));
            }
        }
    }

    @Override
    public void registerProcessor(ProviderConfig providerConfig, Invoker instance) {
        String serviceName = this.getUniqueName(providerConfig);
        this.serverHandler.getInvokerMap().put(serviceName, instance);
        Class<?> itfClass = providerConfig.getProxyClass();
        HashMap<String, Method> methodsLimit = new HashMap<String, Method>(16);
        for (Method method : itfClass.getMethods()) {
            String methodName = method.getName();
            if (methodsLimit.containsKey(methodName)) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("010000026", itfClass.getName(), methodName));
            }
            methodsLimit.put(methodName, method);
        }
        for (Map.Entry entry : methodsLimit.entrySet()) {
            ReflectCache.putMethodCache(serviceName, (Method)entry.getValue());
            ReflectCache.putMethodSigsCache(serviceName, (String)entry.getKey(), ClassTypeUtils.getTypeStrs(((Method)entry.getValue()).getParameterTypes(), true));
        }
    }

    @Override
    public void unRegisterProcessor(ProviderConfig providerConfig, boolean closeIfNoEntry) {
        if (!this.started) {
            return;
        }
        String key = this.getUniqueName(providerConfig);
        this.serverHandler.getInvokerMap().remove(key);
        if (closeIfNoEntry && this.serverHandler.getInvokerMap().size() == 0) {
            this.stop();
        }
    }

    private String getUniqueName(ProviderConfig providerConfig) {
        String uniqueId = providerConfig.getUniqueId();
        return providerConfig.getInterfaceId() + (StringUtils.isEmpty(uniqueId) ? "" : ":" + uniqueId);
    }

    @Override
    public void destroy() {
        if (!this.started) {
            return;
        }
        this.stop();
        this.serverHandler = null;
    }

    @Override
    public void destroy(Destroyable.DestroyHook hook) {
        hook.preDestroy();
        this.destroy();
        hook.postDestroy();
    }

    public ThreadPoolExecutor getBizThreadPool() {
        return this.bizThreadPool;
    }

    private static ServerTransportConfig convertConfig(ServerConfig serverConfig) {
        ServerTransportConfig serverTransportConfig = new ServerTransportConfig();
        serverTransportConfig.setPort(serverConfig.getPort());
        serverTransportConfig.setProtocolType(serverConfig.getProtocol());
        serverTransportConfig.setHost(serverConfig.getBoundHost());
        serverTransportConfig.setContextPath(serverConfig.getContextPath());
        serverTransportConfig.setBizMaxThreads(serverConfig.getMaxThreads());
        serverTransportConfig.setBizPoolType(serverConfig.getThreadPoolType());
        serverTransportConfig.setIoThreads(serverConfig.getIoThreads());
        serverTransportConfig.setChannelListeners(serverConfig.getOnConnect());
        serverTransportConfig.setMaxConnection(serverConfig.getAccepts());
        serverTransportConfig.setPayload(serverConfig.getPayload());
        serverTransportConfig.setTelnet(serverConfig.isTelnet());
        serverTransportConfig.setUseEpoll(serverConfig.isEpoll());
        serverTransportConfig.setBizPoolQueueType(serverConfig.getQueueType());
        serverTransportConfig.setBizPoolQueues(serverConfig.getQueues());
        serverTransportConfig.setDaemon(serverConfig.isDaemon());
        serverTransportConfig.setParameters(serverConfig.getParameters());
        serverTransportConfig.setContainer(serverConfig.getTransport());
        return serverTransportConfig;
    }
}

