/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.protocol;

import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoader;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.ext.ExtensionLoaderListener;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.protocol.TelnetHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TelnetHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TelnetHandlerFactory.class);
    private static Map<String, TelnetHandler> supportedCmds = new ConcurrentHashMap<String, TelnetHandler>();
    private static final ExtensionLoader<TelnetHandler> EXTENSION_LOADER = TelnetHandlerFactory.buildLoader();

    private static ExtensionLoader<TelnetHandler> buildLoader() {
        ExtensionLoader<TelnetHandler> extensionLoader = ExtensionLoaderFactory.getExtensionLoader(TelnetHandler.class);
        extensionLoader.addListener(new ExtensionLoaderListener<TelnetHandler>(){

            @Override
            public void onLoad(ExtensionClass<TelnetHandler> extensionClass) {
                TelnetHandler handler = extensionClass.getExtInstance();
                supportedCmds.put(handler.getCommand(), handler);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Add telnet handler {}:{}.", handler.getCommand(), handler);
                }
            }
        });
        return extensionLoader;
    }

    public static TelnetHandler getHandler(String command) {
        return supportedCmds.get(command);
    }

    public static Map<String, TelnetHandler> getAllHandlers() {
        return supportedCmds;
    }
}

