/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.doc.swagger.utils;

import com.alipay.sofa.rpc.doc.swagger.utils.ClassUtils;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LocalVariableTableParameterNameDiscoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalVariableTableParameterNameDiscoverer.class);
    private static final char PACKAGE_SEPARATOR = '.';
    public static final String CLASS_FILE_SUFFIX = ".class";
    private static final Map<Member, String[]> NO_DEBUG_INFO_MAP = Collections.emptyMap();
    private final Map<Class<?>, Map<Member, String[]>> parameterNamesCache = new ConcurrentHashMap(32);

    public String[] getParameterNames(Method originalMethod) {
        Class<?> declaringClass = originalMethod.getDeclaringClass();
        Map<Member, String[]> map = this.parameterNamesCache.get(declaringClass);
        if (map == null) {
            map = this.inspectClass(declaringClass);
            this.parameterNamesCache.put(declaringClass, map);
        }
        if (map != NO_DEBUG_INFO_MAP) {
            return map.get(originalMethod);
        }
        return null;
    }

    public String[] getParameterNames(Constructor<?> ctor) {
        Class<?> declaringClass = ctor.getDeclaringClass();
        Map<Member, String[]> map = this.parameterNamesCache.get(declaringClass);
        if (map == null) {
            map = this.inspectClass(declaringClass);
            this.parameterNamesCache.put(declaringClass, map);
        }
        if (map != NO_DEBUG_INFO_MAP) {
            return map.get(ctor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Member, String[]> inspectClass(Class<?> clazz) {
        InputStream is = clazz.getResourceAsStream(LocalVariableTableParameterNameDiscoverer.getClassFileName(clazz));
        if (is == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cannot find '.class' file for class [" + clazz + "] - unable to determine constructor/method parameter names");
            }
            return NO_DEBUG_INFO_MAP;
        }
        try {
            ClassReader classReader = new ClassReader(is);
            ConcurrentHashMap<Member, String[]> map = new ConcurrentHashMap<Member, String[]>(32);
            classReader.accept((ClassVisitor)new ParameterNameDiscoveringVisitor(clazz, map), 0);
            ConcurrentHashMap<Member, String[]> concurrentHashMap = map;
            return concurrentHashMap;
        }
        catch (IOException ex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exception thrown while reading '.class' file for class [" + clazz + "] - unable to determine constructor/method parameter names", ex);
            }
        }
        catch (IllegalArgumentException ex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ASM ClassReader failed to parse class file [" + clazz + "], probably due to a new Java class file version that isn't supported yet - unable to determine constructor/method parameter names", ex);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
        return NO_DEBUG_INFO_MAP;
    }

    public static String getClassFileName(Class<?> clazz) {
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return className.substring(lastDotIndex + 1) + CLASS_FILE_SUFFIX;
    }

    private static class LocalVariableTableVisitor
    extends MethodVisitor {
        private static final String CONSTRUCTOR = "<init>";
        private final Class<?> clazz;
        private final Map<Member, String[]> memberMap;
        private final String name;
        private final Type[] args;
        private final String[] parameterNames;
        private final boolean isStatic;
        private boolean hasLvtInfo = false;
        private final int[] lvtSlotIndex;

        public LocalVariableTableVisitor(Class<?> clazz, Map<Member, String[]> map, String name, String desc, boolean isStatic) {
            super(458752);
            this.clazz = clazz;
            this.memberMap = map;
            this.name = name;
            this.args = Type.getArgumentTypes((String)desc);
            this.parameterNames = new String[this.args.length];
            this.isStatic = isStatic;
            this.lvtSlotIndex = LocalVariableTableVisitor.computeLvtSlotIndices(isStatic, this.args);
        }

        public void visitLocalVariable(String name, String description, String signature, Label start, Label end, int index) {
            this.hasLvtInfo = true;
            for (int i = 0; i < this.lvtSlotIndex.length; ++i) {
                if (this.lvtSlotIndex[i] != index) continue;
                this.parameterNames[i] = name;
            }
        }

        public void visitEnd() {
            if (this.hasLvtInfo || this.isStatic && this.parameterNames.length == 0) {
                this.memberMap.put(this.resolveMember(), this.parameterNames);
            }
        }

        private Member resolveMember() {
            ClassLoader loader = this.clazz.getClassLoader();
            Class[] argTypes = new Class[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                argTypes[i] = ClassUtils.resolveClassName(this.args[i].getClassName(), loader);
            }
            try {
                if (CONSTRUCTOR.equals(this.name)) {
                    return this.clazz.getDeclaredConstructor(argTypes);
                }
                return this.clazz.getDeclaredMethod(this.name, argTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Method [" + this.name + "] was discovered in the .class file but cannot be resolved in the class object", ex);
            }
        }

        private static int[] computeLvtSlotIndices(boolean isStatic, Type[] paramTypes) {
            int[] lvtIndex = new int[paramTypes.length];
            int nextIndex = isStatic ? 0 : 1;
            for (int i = 0; i < paramTypes.length; ++i) {
                lvtIndex[i] = nextIndex++;
                if (!LocalVariableTableVisitor.isWideType(paramTypes[i])) continue;
                nextIndex += 2;
            }
            return lvtIndex;
        }

        private static boolean isWideType(Type aType) {
            return aType == Type.LONG_TYPE || aType == Type.DOUBLE_TYPE;
        }
    }

    private static class ParameterNameDiscoveringVisitor
    extends ClassVisitor {
        private static final String STATIC_CLASS_INIT = "<clinit>";
        private final Class<?> clazz;
        private final Map<Member, String[]> memberMap;

        public ParameterNameDiscoveringVisitor(Class<?> clazz, Map<Member, String[]> memberMap) {
            super(458752);
            this.clazz = clazz;
            this.memberMap = memberMap;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!ParameterNameDiscoveringVisitor.isSyntheticOrBridged(access) && !STATIC_CLASS_INIT.equals(name)) {
                return new LocalVariableTableVisitor(this.clazz, this.memberMap, name, desc, ParameterNameDiscoveringVisitor.isStatic(access));
            }
            return null;
        }

        private static boolean isSyntheticOrBridged(int access) {
            return (access & 0x1000 | access & 0x40) > 0;
        }

        private static boolean isStatic(int access) {
            return (access & 8) > 0;
        }
    }
}

