/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.threadpool.extension;

import com.alipay.sofa.common.thread.virtual.SofaVirtualThreadFactory;
import com.alipay.sofa.rpc.common.threadpool.SofaExecutorFactory;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.ext.Extension;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

@Extension(value="virtual")
public class VirtualThreadPoolFactory
implements SofaExecutorFactory {
    private static final AtomicInteger POOL_COUNT = new AtomicInteger();

    @Override
    public Executor createExecutor(String namePrefix, ServerConfig serverConfig) {
        return SofaVirtualThreadFactory.ofExecutorService((String)this.buildNamePrefix(namePrefix));
    }

    private String buildNamePrefix(String namePrefix) {
        StringBuilder sb = new StringBuilder();
        sb.append("SOFA-");
        sb.append(namePrefix);
        sb.append("-");
        sb.append(POOL_COUNT.getAndIncrement());
        sb.append("-");
        sb.append("VT");
        return sb.toString();
    }
}

