/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.json;

import com.alipay.sofa.rpc.common.json.JSON;
import com.alipay.sofa.rpc.common.json.JSONField;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.common.utils.CompatibleTypeUtils;
import com.alipay.sofa.rpc.common.utils.DateUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanSerializer {
    public static Object serialize(Object bean) throws NullPointerException {
        return BeanSerializer.serialize(bean, false);
    }

    public static Object serialize(Object bean, boolean addType) throws NullPointerException {
        String typeName;
        if (bean == null) {
            return null;
        }
        if (bean instanceof String || bean instanceof Boolean || bean instanceof Number) {
            return bean;
        }
        if (bean instanceof Collection) {
            Collection list = (Collection)bean;
            ArrayList<Object> array = new ArrayList<Object>(list.size());
            for (Object o : list) {
                array.add(BeanSerializer.serialize(o, addType));
            }
            return array;
        }
        if (bean.getClass().isArray()) {
            int length = Array.getLength(bean);
            ArrayList<Object> array = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                array.add(BeanSerializer.serialize(Array.get(bean, i), addType));
            }
            return array;
        }
        if (bean instanceof Map) {
            LinkedHashMap map = new LinkedHashMap((Map)bean);
            Iterator itr = map.entrySet().iterator();
            Map.Entry entry = null;
            while (itr.hasNext()) {
                entry = itr.next();
                map.put(entry.getKey(), BeanSerializer.serialize(entry.getValue(), addType));
            }
            return map;
        }
        if (bean instanceof Date) {
            return DateUtils.dateToStr((Date)bean);
        }
        if (bean instanceof Enum) {
            Enum e = (Enum)bean;
            return e.toString();
        }
        Class<?> beanClass = bean.getClass();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Field field : JSON.getSerializeFields(beanClass)) {
            Object value = null;
            String key = field.getName();
            try {
                value = BeanSerializer.serialize(field.get(bean), addType);
                JSONField jsonField = field.getAnnotation(JSONField.class);
                if (jsonField != null) {
                    boolean isRequired = jsonField.isRequired();
                    if (value == null) {
                        if (isRequired) {
                            throw new NullPointerException("Field " + field.getName() + " can't be null");
                        }
                        if (jsonField.skipIfNull()) continue;
                    }
                    if (!jsonField.alias().isEmpty()) {
                        key = jsonField.alias();
                    }
                }
                map.put(key, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Read bean filed " + beanClass.getName() + "." + field.getName() + " error! ", e);
            }
        }
        if (addType && !(typeName = beanClass.getName()).startsWith("java.") && !typeName.startsWith("javax.") && !typeName.startsWith("sun.")) {
            map.put("@type", typeName);
        }
        return map;
    }

    private static <K, V> Map<K, V> mapToMap(Map<K, V> src, Class<? extends Map> dstClazz) {
        if (dstClazz.isInterface()) {
            dstClazz = HashMap.class;
        }
        Map des = ClassUtils.newInstance(dstClazz);
        for (Map.Entry<K, V> entry : src.entrySet()) {
            des.put(BeanSerializer.deserialize(entry.getKey()), BeanSerializer.deserialize(entry.getValue()));
        }
        return des;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> T mapToObject(Map src, Class<T> dstClazz) {
        String actualType = (String)src.get("@type");
        Class realClass = actualType != null ? ClassUtils.forName(actualType) : dstClazz;
        Object bean = ClassUtils.newInstance(realClass);
        for (Field field : JSON.getSerializeFields(realClass)) {
            Collection<T> value = null;
            try {
                JSONField jsonField = field.getAnnotation(JSONField.class);
                String name = null;
                boolean isRequired = false;
                if (jsonField != null) {
                    name = jsonField.alias();
                    isRequired = jsonField.isRequired();
                }
                if (StringUtils.isEmpty(name)) {
                    name = field.getName();
                }
                if ((value = (Collection<T>)src.get(name)) == null) {
                    if (isRequired) {
                        throw new NullPointerException("Field " + name + " can't be null");
                    }
                } else {
                    Class<?> fieldClazz = field.getType();
                    if (Collection.class.isAssignableFrom(fieldClazz)) {
                        Class genericType = Object.class;
                        try {
                            genericType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (value instanceof Collection) {
                            value = BeanSerializer.collection2Collection(value, fieldClazz, genericType);
                        } else {
                            if (!value.getClass().isArray()) throw new RuntimeException("value type is not supported, type=" + value.getClass());
                            value = BeanSerializer.arrayToCollection(value, fieldClazz, genericType);
                        }
                    } else {
                        value = (Collection<T>)BeanSerializer.deserializeByType(value, fieldClazz);
                    }
                }
                field.set(bean, value);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Write bean filed " + realClass.getName() + "." + field.getName() + "error! ", e);
            }
        }
        return bean;
    }

    private static <T> Collection<T> arrayToCollection(Object src, Class<? extends Collection> clazz, Class<T> genericType) {
        if (clazz.isInterface()) {
            if (List.class.isAssignableFrom(clazz)) {
                clazz = ArrayList.class;
            } else if (Set.class.isAssignableFrom(clazz)) {
                clazz = HashSet.class;
            }
        }
        Collection collection = ClassUtils.newInstance(clazz);
        for (int i = 0; i < Array.getLength(src); ++i) {
            collection.add(BeanSerializer.deserializeByType(Array.get(src, i), genericType));
        }
        return collection;
    }

    private static <T> Collection<T> collection2Collection(Collection src, Class<? extends Collection> clazz, Class<T> genericType) {
        return BeanSerializer.arrayToCollection(src.toArray(), clazz, genericType);
    }

    private static <T> T[] collectionToArray(Collection<T> src, Class<T> componentType) {
        return BeanSerializer.array2Array(src.toArray(), componentType);
    }

    private static <T> T[] array2Array(Object[] src, Class<T> componentType) {
        Object array = Array.newInstance(componentType, src.length);
        for (int i = 0; i < src.length; ++i) {
            Array.set(array, i, BeanSerializer.deserializeByType(src[i], componentType));
        }
        return (Object[])array;
    }

    public static <T> T deserializeByType(Object src, Class<T> clazz) {
        if (src == null) {
            return (T)ClassUtils.getDefaultPrimitiveValue(clazz);
        }
        if (src instanceof Boolean) {
            return (T)CompatibleTypeUtils.convert(src, clazz);
        }
        if (src instanceof Number) {
            return (T)CompatibleTypeUtils.convert(src, clazz);
        }
        if (src instanceof Map) {
            Map srcMap = (Map)src;
            if (clazz == Object.class) {
                if (srcMap.containsKey("@type")) {
                    return (T)BeanSerializer.mapToObject(srcMap, Object.class);
                }
                return (T)BeanSerializer.mapToMap(srcMap, srcMap.getClass());
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return (T)BeanSerializer.mapToMap(srcMap, clazz);
            }
            return BeanSerializer.mapToObject(srcMap, clazz);
        }
        if (src instanceof Collection) {
            Collection list = (Collection)src;
            if (clazz == Object.class) {
                return (T)BeanSerializer.collection2Collection(list, list.getClass(), Object.class);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return (T)BeanSerializer.collection2Collection(list, clazz, Object.class);
            }
            if (clazz.isArray()) {
                if (clazz.getComponentType().isPrimitive()) {
                    return (T)CompatibleTypeUtils.convert(list, clazz);
                }
                return (T)BeanSerializer.collectionToArray(list, clazz.getComponentType());
            }
            return (T)list;
        }
        if (src.getClass().isArray()) {
            Class<?> componentType = src.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                if (Collection.class.isAssignableFrom(clazz)) {
                    return (T)BeanSerializer.arrayToCollection(src, clazz, Object.class);
                }
                return (T)src;
            }
            Object[] array = (Object[])src;
            if (clazz == Object.class) {
                return (T)BeanSerializer.array2Array(array, array.getClass().getComponentType());
            }
            if (clazz.isArray()) {
                return (T)BeanSerializer.array2Array(array, clazz.getComponentType());
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return (T)BeanSerializer.arrayToCollection(src, clazz, Object.class);
            }
            return (T)src;
        }
        if (clazz.isEnum()) {
            if (src instanceof String) {
                return Enum.valueOf(clazz, (String)src);
            }
            throw new RuntimeException("Enum field must set string!");
        }
        if (Date.class.isAssignableFrom(clazz)) {
            if (src instanceof Long) {
                return (T)new Date((Long)src);
            }
            if (src instanceof String) {
                try {
                    return (T)DateUtils.strToDate((String)src);
                }
                catch (Exception e) {
                    throw new RuntimeException("Date field must set string(yyyy-MM-dd HH:mm:ss)!");
                }
            }
            throw new RuntimeException("Date field must set long or string(yyyy-MM-dd HH:mm:ss)!");
        }
        if (src instanceof String) {
            return (T)CompatibleTypeUtils.convert(src, clazz);
        }
        return (T)src;
    }

    public static Object deserialize(Object object) {
        return BeanSerializer.deserializeByType(object, Object.class);
    }
}

