/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.serialization;

import com.alipay.remoting.serialization.HessianSerializer;
import com.alipay.remoting.serialization.Serializer;
import java.util.concurrent.locks.ReentrantLock;

public class SerializerManager {
    private static Serializer[] serializers = new Serializer[5];
    public static final byte Hessian2 = 1;
    private static final ReentrantLock REENTRANT_LOCK = new ReentrantLock();

    public static Serializer getSerializer(int idx) {
        Serializer currentSerializer = serializers[idx];
        if (currentSerializer == null && idx == 1) {
            REENTRANT_LOCK.lock();
            try {
                currentSerializer = serializers[idx];
                if (currentSerializer == null) {
                    currentSerializer = new HessianSerializer();
                    SerializerManager.addSerializer(1, currentSerializer);
                }
            }
            finally {
                REENTRANT_LOCK.unlock();
            }
        }
        return currentSerializer;
    }

    public static void addSerializer(int idx, Serializer serializer) {
        if (serializers.length <= idx) {
            Serializer[] newSerializers = new Serializer[idx + 5];
            System.arraycopy(serializers, 0, newSerializers, 0, serializers.length);
            serializers = newSerializers;
        }
        SerializerManager.serializers[idx] = serializer;
    }
}

