/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc.protocol;

import com.alipay.remoting.AbstractRemotingProcessor;
import com.alipay.remoting.CommandFactory;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.RemotingContext;
import com.alipay.remoting.ResponseStatus;
import com.alipay.remoting.exception.DeserializationException;
import com.alipay.remoting.exception.SerializationException;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.protocol.AsyncMultiInterestUserProcessor;
import com.alipay.remoting.rpc.protocol.AsyncUserProcessor;
import com.alipay.remoting.rpc.protocol.RpcAsyncContext;
import com.alipay.remoting.rpc.protocol.RpcDeserializeLevel;
import com.alipay.remoting.rpc.protocol.RpcRequestCommand;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.remoting.util.RemotingUtil;
import com.alipay.sofa.common.insight.RecordContext;
import com.alipay.sofa.common.insight.RecordScene;
import com.alipay.sofa.common.insight.RecorderManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;

public class RpcRequestProcessor
extends AbstractRemotingProcessor<RpcRequestCommand> {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");

    public RpcRequestProcessor() {
    }

    public RpcRequestProcessor(CommandFactory commandFactory) {
        super(commandFactory);
    }

    public RpcRequestProcessor(ExecutorService executor) {
        super(executor);
    }

    @Override
    public void process(RemotingContext ctx, RpcRequestCommand cmd, ExecutorService defaultExecutor) throws Exception {
        Executor executor;
        if (!this.deserializeRequestCommand(ctx, cmd, 0)) {
            return;
        }
        UserProcessor<?> userProcessor = ctx.getUserProcessor(cmd.getRequestClass());
        if (userProcessor == null) {
            String errMsg = "No user processor found for request: " + cmd.getRequestClass();
            logger.error(errMsg);
            this.sendResponseIfNecessary(ctx, cmd.getType(), (RemotingCommand)this.getCommandFactory().createExceptionResponse(cmd.getId(), errMsg));
            return;
        }
        ctx.setTimeoutDiscard(userProcessor.timeoutDiscard());
        if (userProcessor.processInIOThread()) {
            if (!this.deserializeRequestCommand(ctx, cmd, 2)) {
                return;
            }
            new ProcessTask(ctx, cmd).run();
            return;
        }
        if (null == userProcessor.getExecutorSelector()) {
            executor = userProcessor.getExecutor();
        } else {
            if (!this.deserializeRequestCommand(ctx, cmd, 1)) {
                return;
            }
            executor = userProcessor.getExecutorSelector().select(cmd.getRequestClass(), cmd.getRequestHeader());
        }
        if (executor == null) {
            executor = this.getExecutor() == null ? defaultExecutor : this.getExecutor();
        }
        cmd.setBeforeEnterQueueTime(System.nanoTime());
        executor.execute(new ProcessTask(ctx, cmd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProcess(RemotingContext ctx, RpcRequestCommand cmd) throws Exception {
        try {
            long currentTimestamp = System.currentTimeMillis();
            RecorderManager.getRecorder().start(RecordScene.BOLT_REQUEST_HANDLE, new RecordContext(cmd.getId()));
            this.preProcessRemotingContext(ctx, cmd, currentTimestamp);
            if (ctx.isTimeoutDiscard() && ctx.isRequestTimeout()) {
                this.timeoutLog(cmd, currentTimestamp, ctx);
                return;
            }
            this.debugLog(ctx, cmd, currentTimestamp);
            if (!this.deserializeRequestCommand(ctx, cmd, 2)) {
                return;
            }
            this.dispatchToUserProcessor(ctx, cmd);
        }
        finally {
            RecorderManager.getRecorder().stop(RecordScene.BOLT_REQUEST_HANDLE, ctx.getInvokeContext().getRecordContext());
        }
    }

    public void sendResponseIfNecessary(final RemotingContext ctx, byte type, RemotingCommand response) {
        final int id = response.getId();
        if (type != 2) {
            RemotingCommand serializedResponse = response;
            try {
                response.serialize();
            }
            catch (SerializationException e) {
                String errMsg = "SerializationException occurred when sendResponseIfNecessary in RpcRequestProcessor, id=" + id;
                logger.error(errMsg, (Throwable)e);
                serializedResponse = this.getCommandFactory().createExceptionResponse(id, ResponseStatus.SERVER_SERIAL_EXCEPTION, e);
                try {
                    serializedResponse.serialize();
                }
                catch (SerializationException e1) {
                    logger.error("serialize SerializationException response failed!");
                }
            }
            catch (Throwable t) {
                String errMsg = "Serialize RpcResponseCommand failed when sendResponseIfNecessary in RpcRequestProcessor, id=" + id;
                logger.error(errMsg, t);
                serializedResponse = this.getCommandFactory().createExceptionResponse(id, t, errMsg);
                try {
                    serializedResponse.serialize();
                }
                catch (Throwable t1) {
                    logger.error("serialize exception response failed!", t1);
                }
            }
            ctx.writeAndFlush(serializedResponse).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Rpc response sent! requestId=" + id + ". The address is " + RemotingUtil.parseRemoteAddress(ctx.getChannelContext().channel()));
                    }
                    if (!future.isSuccess()) {
                        logger.error("Rpc response send failed! id=" + id + ". The address is " + RemotingUtil.parseRemoteAddress(ctx.getChannelContext().channel()), future.cause());
                    }
                }
            });
        } else if (logger.isDebugEnabled()) {
            logger.debug("Oneway rpc request received, do not send response, id=" + id + ", the address is " + RemotingUtil.parseRemoteAddress(ctx.getChannelContext().channel()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchToUserProcessor(RemotingContext ctx, RpcRequestCommand cmd) {
        int id = cmd.getId();
        byte type = cmd.getType();
        UserProcessor<?> processor = ctx.getUserProcessor(cmd.getRequestClass());
        ClassLoader classLoader = null;
        try {
            ClassLoader bizClassLoader = processor.getBizClassLoader();
            if (bizClassLoader != null) {
                classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(bizClassLoader);
            }
            if (processor instanceof AsyncUserProcessor || processor instanceof AsyncMultiInterestUserProcessor) {
                try {
                    processor.handleRequest(processor.preHandleRequest(ctx, cmd.getRequestObject()), new RpcAsyncContext(ctx, cmd, this), cmd.getRequestObject());
                }
                catch (RejectedExecutionException e) {
                    logger.warn("RejectedExecutionException occurred when do ASYNC process in RpcRequestProcessor");
                    this.sendResponseIfNecessary(ctx, type, (RemotingCommand)this.getCommandFactory().createExceptionResponse(id, ResponseStatus.SERVER_THREADPOOL_BUSY));
                }
                catch (Throwable t) {
                    String errMsg = "AYSNC process rpc request failed in RpcRequestProcessor, id=" + id;
                    logger.error(errMsg, t);
                    this.sendResponseIfNecessary(ctx, type, (RemotingCommand)this.getCommandFactory().createExceptionResponse(id, t, errMsg));
                }
            } else {
                try {
                    Object responseObject = processor.handleRequest(processor.preHandleRequest(ctx, cmd.getRequestObject()), cmd.getRequestObject());
                    this.sendResponseIfNecessary(ctx, type, (RemotingCommand)this.getCommandFactory().createResponse(responseObject, cmd));
                }
                catch (RejectedExecutionException e) {
                    logger.warn("RejectedExecutionException occurred when do SYNC process in RpcRequestProcessor");
                    this.sendResponseIfNecessary(ctx, type, (RemotingCommand)this.getCommandFactory().createExceptionResponse(id, ResponseStatus.SERVER_THREADPOOL_BUSY));
                }
                catch (Throwable t) {
                    String errMsg = "SYNC process rpc request failed in RpcRequestProcessor, id=" + id;
                    logger.error(errMsg, t);
                    this.sendResponseIfNecessary(ctx, type, (RemotingCommand)this.getCommandFactory().createExceptionResponse(id, t, errMsg));
                }
            }
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        catch (Throwable throwable) {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            throw throwable;
        }
    }

    private boolean deserializeRequestCommand(RemotingContext ctx, RpcRequestCommand cmd, int level) {
        boolean result;
        try {
            cmd.deserialize(level);
            result = true;
        }
        catch (DeserializationException e) {
            logger.error("DeserializationException occurred when process in RpcRequestProcessor, id={}, deserializeLevel={}", new Object[]{cmd.getId(), RpcDeserializeLevel.valueOf(level), e});
            this.sendResponseIfNecessary(ctx, cmd.getType(), (RemotingCommand)this.getCommandFactory().createExceptionResponse(cmd.getId(), ResponseStatus.SERVER_DESERIAL_EXCEPTION, e));
            result = false;
        }
        catch (Throwable t) {
            String errMsg = "Deserialize RpcRequestCommand failed in RpcRequestProcessor, id=" + cmd.getId() + ", deserializeLevel=" + level;
            logger.error(errMsg, t);
            this.sendResponseIfNecessary(ctx, cmd.getType(), (RemotingCommand)this.getCommandFactory().createExceptionResponse(cmd.getId(), t, errMsg));
            result = false;
        }
        return result;
    }

    private void preProcessRemotingContext(RemotingContext ctx, RpcRequestCommand cmd, long currentTimestamp) {
        ctx.setArriveTimestamp(cmd.getArriveTime());
        ctx.setTimeout(cmd.getTimeout());
        ctx.setRpcCommandType(cmd.getType());
        ctx.getInvokeContext().putIfAbsent("bolt.invoke.wait.time", currentTimestamp - cmd.getArriveTime());
        ctx.getInvokeContext().putIfAbsent("bolt.invoke.request.arrive.header.in.nano", cmd.getArriveHeaderTimeInNano());
        ctx.getInvokeContext().putIfAbsent("bolt.invoke.request.arrive.body.in.nano", cmd.getArriveBodyTimeInNano());
        ctx.getInvokeContext().putIfAbsent("bolt.invoke.before.dispatch.in.nano", cmd.getBeforeEnterQueueTime());
        ctx.getInvokeContext().putIfAbsent("bolt.invoke.start.process.in.nano", System.nanoTime());
    }

    private void timeoutLog(RpcRequestCommand cmd, long currentTimestamp, RemotingContext ctx) {
        ChannelHandlerContext channelCtx;
        Channel channel;
        if (logger.isDebugEnabled()) {
            logger.debug("request id [{}] currenTimestamp [{}] - arriveTime [{}] = server cost [{}] >= timeout value [{}].", new Object[]{cmd.getId(), currentTimestamp, cmd.getArriveTime(), currentTimestamp - cmd.getArriveTime(), cmd.getTimeout()});
        }
        String remoteAddr = "UNKNOWN";
        if (null != ctx && null != (channel = (channelCtx = ctx.getChannelContext()).channel())) {
            remoteAddr = RemotingUtil.parseRemoteAddress(channel);
        }
        logger.warn("Rpc request id[{}], from remoteAddr[{}] stop process, total wait time in queue is [{}], client timeout setting is [{}].", new Object[]{cmd.getId(), remoteAddr, currentTimestamp - cmd.getArriveTime(), cmd.getTimeout()});
    }

    private void debugLog(RemotingContext ctx, RpcRequestCommand cmd, long currentTimestamp) {
        if (logger.isDebugEnabled()) {
            logger.debug("Rpc request received! requestId={}, from {}", (Object)cmd.getId(), (Object)RemotingUtil.parseRemoteAddress(ctx.getChannelContext().channel()));
            logger.debug("request id {} currenTimestamp {} - arriveTime {} = server cost {} < timeout {}.", new Object[]{cmd.getId(), currentTimestamp, cmd.getArriveTime(), currentTimestamp - cmd.getArriveTime(), cmd.getTimeout()});
        }
    }

    class ProcessTask
    implements Runnable {
        RemotingContext ctx;
        RpcRequestCommand msg;

        public ProcessTask(RemotingContext ctx, RpcRequestCommand msg) {
            this.ctx = ctx;
            this.msg = msg;
        }

        @Override
        public void run() {
            try {
                RpcRequestProcessor.this.doProcess(this.ctx, this.msg);
            }
            catch (Throwable e) {
                String remotingAddress = RemotingUtil.parseRemoteAddress(this.ctx.getChannelContext().channel());
                String errMsg = "Exception caught when process rpc request command in RpcRequestProcessor, Id=" + this.msg.getId();
                logger.error(errMsg + "! Invoke source address is [" + remotingAddress + "].", e);
                RpcRequestProcessor.this.sendResponseIfNecessary(this.ctx, this.msg.getType(), (RemotingCommand)RpcRequestProcessor.this.getCommandFactory().createExceptionResponse(this.msg.getId(), e, errMsg));
            }
        }
    }
}

