/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.enums;

import java.util.Arrays;
import org.apache.shenyu.common.exception.ShenyuException;

public enum ApiHttpMethodEnum {
    GET("GET", 0),
    HEAD("HEAD", 1),
    POST("POST", 2),
    PUT("PUT", 3),
    PATCH("PATCH", 4),
    DELETE("DELETE", 5),
    OPTIONS("OPTIONS", 6),
    TRACE("TRACE", 7),
    NOT_HTTP("NOT_HTTP", 8);

    private final String name;
    private final Integer value;

    private ApiHttpMethodEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Integer getValue() {
        return this.value;
    }

    public static Integer getValueByName(String name) {
        return Arrays.stream(ApiHttpMethodEnum.values()).filter(e -> e.name.equals(name)).findFirst().map(item -> item.value).orElseThrow(() -> new ShenyuException(String.format(" this http method can not support %s", name)));
    }

    public static ApiHttpMethodEnum of(String name) {
        return Arrays.stream(ApiHttpMethodEnum.values()).filter(e -> e.name.equals(name)).findFirst().orElseThrow(() -> new ShenyuException(String.format(" this http method can not support %s", name)));
    }
}

