/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.util;

import com.fasterxml.jackson.databind.Module;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.util.ClassUtils;

public abstract class JacksonUtils {
    public static List<Module> instantiateAvailableModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        try {
            Class jdk8ModuleClass = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.jdk8.Jdk8Module", null);
            Module jdk8Module = (Module)BeanUtils.instantiateClass((Class)jdk8ModuleClass);
            modules.add(jdk8Module);
        }
        catch (ClassNotFoundException jdk8ModuleClass) {
            // empty catch block
        }
        try {
            Class javaTimeModuleClass = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", null);
            Module javaTimeModule = (Module)BeanUtils.instantiateClass((Class)javaTimeModuleClass);
            modules.add(javaTimeModule);
        }
        catch (ClassNotFoundException javaTimeModuleClass) {
            // empty catch block
        }
        try {
            Class parameterNamesModuleClass = ClassUtils.forName((String)"com.fasterxml.jackson.module.paramnames.ParameterNamesModule", null);
            Module parameterNamesModule = (Module)BeanUtils.instantiateClass((Class)parameterNamesModuleClass);
            modules.add(parameterNamesModule);
        }
        catch (ClassNotFoundException parameterNamesModuleClass) {
            // empty catch block
        }
        if (KotlinDetector.isKotlinPresent()) {
            try {
                Class kotlinModuleClass = ClassUtils.forName((String)"com.fasterxml.jackson.module.kotlin.KotlinModule", null);
                Module kotlinModule = (Module)BeanUtils.instantiateClass((Class)kotlinModuleClass);
                modules.add(kotlinModule);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return modules;
    }
}

