/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.okhttp;

import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import shade.polaris.com.google.common.base.Preconditions;
import shade.polaris.io.grpc.Attributes;
import shade.polaris.io.grpc.Metadata;
import shade.polaris.io.grpc.Status;
import shade.polaris.io.grpc.internal.AbstractServerStream;
import shade.polaris.io.grpc.internal.StatsTraceContext;
import shade.polaris.io.grpc.internal.TransportTracer;
import shade.polaris.io.grpc.internal.WritableBuffer;
import shade.polaris.io.grpc.okhttp.ExceptionHandlingFrameWriter;
import shade.polaris.io.grpc.okhttp.Headers;
import shade.polaris.io.grpc.okhttp.OkHttpReadableBuffer;
import shade.polaris.io.grpc.okhttp.OkHttpServerTransport;
import shade.polaris.io.grpc.okhttp.OkHttpWritableBuffer;
import shade.polaris.io.grpc.okhttp.OkHttpWritableBufferAllocator;
import shade.polaris.io.grpc.okhttp.OutboundFlowController;
import shade.polaris.io.grpc.okhttp.internal.framed.ErrorCode;
import shade.polaris.io.grpc.okhttp.internal.framed.Header;
import shade.polaris.io.perfmark.PerfMark;
import shade.polaris.io.perfmark.Tag;
import shade.polaris.okio.Buffer;

class OkHttpServerStream
extends AbstractServerStream {
    private final String authority;
    private final TransportState state;
    private final Sink sink = new Sink();
    private final TransportTracer transportTracer;
    private final Attributes attributes;

    public OkHttpServerStream(TransportState state, Attributes transportAttrs, String authority, StatsTraceContext statsTraceCtx, TransportTracer transportTracer) {
        super(new OkHttpWritableBufferAllocator(), statsTraceCtx);
        this.state = Preconditions.checkNotNull(state, "state");
        this.attributes = Preconditions.checkNotNull(transportAttrs, "transportAttrs");
        this.authority = authority;
        this.transportTracer = Preconditions.checkNotNull(transportTracer, "transportTracer");
    }

    @Override
    protected TransportState transportState() {
        return this.state;
    }

    @Override
    protected Sink abstractServerStreamSink() {
        return this.sink;
    }

    @Override
    public int streamId() {
        return this.state.streamId;
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    static class TransportState
    extends AbstractServerStream.TransportState
    implements OutboundFlowController.Stream,
    OkHttpServerTransport.StreamState {
        @GuardedBy(value="lock")
        private final OkHttpServerTransport transport;
        private final int streamId;
        private final int initialWindowSize;
        private final Object lock;
        @GuardedBy(value="lock")
        private boolean cancelSent = false;
        @GuardedBy(value="lock")
        private int window;
        @GuardedBy(value="lock")
        private int processedWindow;
        @GuardedBy(value="lock")
        private final ExceptionHandlingFrameWriter frameWriter;
        @GuardedBy(value="lock")
        private final OutboundFlowController outboundFlow;
        @GuardedBy(value="lock")
        private boolean receivedEndOfStream;
        private final Tag tag;
        private final OutboundFlowController.StreamState outboundFlowState;

        public TransportState(OkHttpServerTransport transport, int streamId, int maxMessageSize, StatsTraceContext statsTraceCtx, Object lock, ExceptionHandlingFrameWriter frameWriter, OutboundFlowController outboundFlow, int initialWindowSize, TransportTracer transportTracer, String methodName) {
            super(maxMessageSize, statsTraceCtx, transportTracer);
            this.transport = Preconditions.checkNotNull(transport, "transport");
            this.streamId = streamId;
            this.lock = Preconditions.checkNotNull(lock, "lock");
            this.frameWriter = frameWriter;
            this.outboundFlow = outboundFlow;
            this.window = initialWindowSize;
            this.processedWindow = initialWindowSize;
            this.initialWindowSize = initialWindowSize;
            this.tag = PerfMark.createTag(methodName);
            this.outboundFlowState = outboundFlow.createState(this, streamId);
        }

        @Override
        @GuardedBy(value="lock")
        public void deframeFailed(Throwable cause) {
            this.cancel(ErrorCode.INTERNAL_ERROR, Status.fromThrowable(cause));
        }

        @Override
        @GuardedBy(value="lock")
        public void bytesRead(int processedBytes) {
            this.processedWindow -= processedBytes;
            if ((float)this.processedWindow <= (float)this.initialWindowSize * 0.5f) {
                int delta = this.initialWindowSize - this.processedWindow;
                this.window += delta;
                this.processedWindow += delta;
                this.frameWriter.windowUpdate(this.streamId, delta);
                this.frameWriter.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @GuardedBy(value="lock")
        public void runOnTransportThread(Runnable r) {
            Object object = this.lock;
            synchronized (object) {
                r.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void inboundDataReceived(Buffer frame, int windowConsumed, boolean endOfStream) {
            Object object = this.lock;
            synchronized (object) {
                PerfMark.event("OkHttpServerTransport$FrameHandler.data", this.tag);
                if (endOfStream) {
                    this.receivedEndOfStream = true;
                }
                this.window -= windowConsumed;
                super.inboundDataReceived(new OkHttpReadableBuffer(frame), endOfStream);
            }
        }

        @Override
        public void inboundRstReceived(Status status) {
            PerfMark.event("OkHttpServerTransport$FrameHandler.rstStream", this.tag);
            this.transportReportStatus(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasReceivedEndOfStream() {
            Object object = this.lock;
            synchronized (object) {
                return this.receivedEndOfStream;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int inboundWindowAvailable() {
            Object object = this.lock;
            synchronized (object) {
                return this.window;
            }
        }

        @GuardedBy(value="lock")
        private void sendBuffer(Buffer buffer, boolean flush) {
            if (this.cancelSent) {
                return;
            }
            this.outboundFlow.data(false, this.outboundFlowState, buffer, flush);
        }

        @GuardedBy(value="lock")
        private void sendHeaders(List<Header> responseHeaders) {
            this.frameWriter.synReply(false, this.streamId, responseHeaders);
            this.frameWriter.flush();
        }

        @GuardedBy(value="lock")
        private void sendTrailers(List<Header> responseTrailers) {
            this.outboundFlow.notifyWhenNoPendingData(this.outboundFlowState, () -> this.sendTrailersAfterFlowControlled(responseTrailers));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendTrailersAfterFlowControlled(List<Header> responseTrailers) {
            Object object = this.lock;
            synchronized (object) {
                this.frameWriter.synReply(true, this.streamId, responseTrailers);
                if (!this.receivedEndOfStream) {
                    this.frameWriter.rstStream(this.streamId, ErrorCode.NO_ERROR);
                }
                this.transport.streamClosed(this.streamId, true);
                this.complete();
            }
        }

        @GuardedBy(value="lock")
        private void cancel(ErrorCode http2Error, Status reason) {
            if (this.cancelSent) {
                return;
            }
            this.cancelSent = true;
            this.frameWriter.rstStream(this.streamId, http2Error);
            this.transportReportStatus(reason);
            this.transport.streamClosed(this.streamId, true);
        }

        @Override
        public OutboundFlowController.StreamState getOutboundFlowState() {
            return this.outboundFlowState;
        }
    }

    class Sink
    implements AbstractServerStream.Sink {
        Sink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeHeaders(Metadata metadata) {
            PerfMark.startTask("OkHttpServerStream$Sink.writeHeaders");
            try {
                List<Header> responseHeaders = Headers.createResponseHeaders(metadata);
                Object object = OkHttpServerStream.this.state.lock;
                synchronized (object) {
                    OkHttpServerStream.this.state.sendHeaders(responseHeaders);
                }
            }
            finally {
                PerfMark.stopTask("OkHttpServerStream$Sink.writeHeaders");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeFrame(WritableBuffer frame, boolean flush, int numMessages) {
            PerfMark.startTask("OkHttpServerStream$Sink.writeFrame");
            Buffer buffer = ((OkHttpWritableBuffer)frame).buffer();
            int size = (int)buffer.size();
            if (size > 0) {
                OkHttpServerStream.this.onSendingBytes(size);
            }
            try {
                Object object = OkHttpServerStream.this.state.lock;
                synchronized (object) {
                    OkHttpServerStream.this.state.sendBuffer(buffer, flush);
                    OkHttpServerStream.this.transportTracer.reportMessageSent(numMessages);
                }
            }
            finally {
                PerfMark.stopTask("OkHttpServerStream$Sink.writeFrame");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeTrailers(Metadata trailers, boolean headersSent, Status status) {
            PerfMark.startTask("OkHttpServerStream$Sink.writeTrailers");
            try {
                List<Header> responseTrailers = Headers.createResponseTrailers(trailers, headersSent);
                Object object = OkHttpServerStream.this.state.lock;
                synchronized (object) {
                    OkHttpServerStream.this.state.sendTrailers(responseTrailers);
                }
            }
            finally {
                PerfMark.stopTask("OkHttpServerStream$Sink.writeTrailers");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(Status reason) {
            PerfMark.startTask("OkHttpServerStream$Sink.cancel");
            try {
                Object object = OkHttpServerStream.this.state.lock;
                synchronized (object) {
                    OkHttpServerStream.this.state.cancel(ErrorCode.CANCEL, reason);
                }
            }
            finally {
                PerfMark.stopTask("OkHttpServerStream$Sink.cancel");
            }
        }
    }
}

