/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.common;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.plugin.server.ServerConnector;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.Services;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.common.ServiceInstancesResponse;
import com.tencent.polaris.plugins.connector.common.ServiceUpdateTask;
import com.tencent.polaris.plugins.connector.common.constant.ServiceUpdateTaskConstant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public abstract class DestroyableServerConnector
extends Destroyable
implements ServerConnector {
    protected static final int TASK_RETRY_INTERVAL_MS = 500;
    private static final Logger LOG = LoggerFactory.getLogger(DestroyableServerConnector.class);
    protected final Map<ServiceEventKey, ServiceUpdateTask> updateTaskSet = new ConcurrentHashMap<ServiceEventKey, ServiceUpdateTask>();

    public abstract boolean isInitialized();

    public void retryServiceUpdateTask(ServiceUpdateTask updateTask) {
        LOG.info("[ServerConnector]retry schedule task for {}, retry delay {}", (Object)updateTask, (Object)500);
        updateTask.setStatus(ServiceUpdateTaskConstant.Status.RUNNING, ServiceUpdateTaskConstant.Status.READY);
        if (this.isDestroyed()) {
            return;
        }
        this.submitServiceHandler(updateTask, 500L);
    }

    protected abstract void submitServiceHandler(ServiceUpdateTask var1, long var2);

    public void addLongRunningTask(ServiceUpdateTask serviceUpdateTask) {
        this.updateTaskSet.put(serviceUpdateTask.getServiceEventKey(), serviceUpdateTask);
    }

    public ServiceInstancesResponse syncGetServiceInstances(ServiceUpdateTask serviceUpdateTask) {
        return null;
    }

    public Services syncGetServices(ServiceUpdateTask serviceUpdateTask) {
        return null;
    }

    public class UpdateServiceTask
    implements Runnable {
        @Override
        public void run() {
            for (ServiceUpdateTask serviceUpdateTask : DestroyableServerConnector.this.updateTaskSet.values()) {
                if (DestroyableServerConnector.this.isDestroyed()) break;
                if (!serviceUpdateTask.needUpdate()) continue;
                DestroyableServerConnector.this.submitServiceHandler(serviceUpdateTask, 0L);
            }
        }
    }
}

