/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class AbstractPolarisLogging {
    private static final String CLASSPATH_PREFIX = "classpath:";

    protected String getLocation(String defaultLocation) {
        String location = System.getProperty("polaris.logging.config");
        if (null == location || location.trim().length() == 0) {
            return defaultLocation;
        }
        return location;
    }

    public static URL getResourceUrl(String resource) throws IOException {
        if (resource.startsWith(CLASSPATH_PREFIX)) {
            URL url;
            String path = resource.substring(CLASSPATH_PREFIX.length());
            ClassLoader classLoader = AbstractPolarisLogging.class.getClassLoader();
            URL uRL = url = classLoader != null ? classLoader.getResource(path) : ClassLoader.getSystemResource(path);
            if (url == null) {
                throw new FileNotFoundException("Resource [" + resource + "] does not exist");
            }
            return url;
        }
        try {
            return new URL(resource);
        }
        catch (MalformedURLException ex) {
            return new File(resource).toURI().toURL();
        }
    }

    public static File getResourceAsFile(URL url) {
        return new File(url.getFile());
    }

    public abstract void loadConfiguration();

    static {
        String loggingPath = System.getProperty("polaris.log.home");
        if (null == loggingPath || loggingPath.trim().length() == 0) {
            String userHome = System.getProperty("user.dir");
            System.setProperty("polaris.log.home", userHome + File.separator + "polaris" + File.separator + "logs");
        }
    }
}

