/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.LocalFileConfigInputDetail;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;

public class ConfigInputDetail
extends LocalFileConfigInputDetail
implements Serializable {
    private static final long serialVersionUID = 8699540049365755476L;
    private ArrayList<String> key = new ArrayList();
    private String logBeginRegex = "";
    private String regex = "";
    private String customizedFields = "";

    public ConfigInputDetail() {
        this.logType = "common_reg_log";
    }

    public ConfigInputDetail(String logPath, String filePattern, String logType, String logBeginRegex, String regex, ArrayList<String> key, String timeFormat, boolean localStorage) {
        this.logType = "common_reg_log";
        this.logPath = logPath;
        this.filePattern = filePattern;
        this.logType = logType;
        this.logBeginRegex = logBeginRegex;
        this.regex = regex;
        this.SetKey(key);
        this.timeFormat = timeFormat;
        this.localStorage = localStorage;
    }

    public ConfigInputDetail(String logPath, String filePattern, String logType, String logBeginRegex, String regex, ArrayList<String> key, String timeFormat, boolean localStorage, String customizedFields) {
        this.logType = "common_reg_log";
        this.logPath = logPath;
        this.filePattern = filePattern;
        this.logType = logType;
        this.logBeginRegex = logBeginRegex;
        this.regex = regex;
        this.SetKey(key);
        this.timeFormat = timeFormat;
        this.localStorage = localStorage;
        this.customizedFields = customizedFields;
    }

    @Override
    public JSONObject ToJsonObject() {
        JSONObject jsonObj = new JSONObject();
        this.LocalFileConfigToJsonObject(jsonObj);
        JSONArray keyArray = new JSONArray();
        keyArray.addAll(this.key);
        jsonObj.put("key", (Object)keyArray);
        jsonObj.put("logBeginRegex", (Object)this.logBeginRegex);
        jsonObj.put("regex", (Object)this.regex);
        if (this.customizedFields != null && !this.customizedFields.isEmpty()) {
            try {
                JSONObject toObject = JSONObject.parseObject((String)this.customizedFields);
                jsonObj.put("customizedFields", (Object)toObject);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to read object from string: " + this.customizedFields, ex);
            }
        }
        return jsonObj;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    @Override
    public void FromJsonObject(JSONObject inputDetail) throws LogException {
        try {
            this.LocalFileConfigFromJsonObject(inputDetail);
            this.logBeginRegex = inputDetail.containsKey((Object)"logBeginRegex") ? inputDetail.getString("logBeginRegex") : ".*";
            this.regex = inputDetail.getString("regex");
            this.SetKey(inputDetail.getJSONArray("key"));
            if (inputDetail.containsKey((Object)"customizedFields")) {
                this.customizedFields = inputDetail.getString("customizedFields");
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String inputDetailString) throws LogException {
        try {
            JSONObject inputDetail = JSONObject.parseObject((String)inputDetailString);
            this.FromJsonObject(inputDetail);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }

    public ConfigInputDetail(ConfigInputDetail inputDetail) {
        this.filePattern = inputDetail.GetFilePattern();
        this.SetKey(inputDetail.GetKey());
        this.localStorage = inputDetail.GetLocalStorage();
        this.logBeginRegex = inputDetail.GetLogBeginRegex();
        this.logPath = inputDetail.GetLogPath();
        this.logType = inputDetail.GetLogType();
        this.regex = inputDetail.GetRegex();
        this.timeFormat = inputDetail.GetTimeFormat();
        this.SetFilterKeyRegex(inputDetail.GetFilterKey(), inputDetail.GetFilterRegex());
        this.topicFormat = inputDetail.GetTopicFormat();
        this.customizedFields = inputDetail.customizedFields;
        this.advanced = inputDetail.advanced;
    }

    public ArrayList<String> GetKey() {
        return this.key;
    }

    public void SetKey(ArrayList<String> key) {
        this.key = new ArrayList<String>(key);
    }

    public void SetKey(JSONArray key) throws LogException {
        try {
            this.key = new ArrayList();
            for (int i = 0; i < key.size(); ++i) {
                this.key.add(key.getString(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToSetKey", e.getMessage(), e, "");
        }
    }

    public String GetLogBeginRegex() {
        return this.logBeginRegex;
    }

    public void SetLogBeginRegex(String logBeginRegex) {
        this.logBeginRegex = logBeginRegex;
    }

    public String GetRegex() {
        return this.regex;
    }

    public void SetRegex(String regex) {
        this.regex = regex;
    }

    public String GetCustomizedFields() {
        return this.customizedFields;
    }

    public void SetCustomizedFields(String customizedFields) {
        this.customizedFields = customizedFields;
    }
}

