/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.appender.self;

import com.alipay.common.tracer.core.appender.manager.AsyncCommonAppenderManager;
import com.alipay.common.tracer.core.appender.self.Timestamp;
import com.alipay.common.tracer.core.utils.TracerUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class SelfLog {
    private static final String ERROR_PREFIX = "[ERROR] ";
    private static final String WARN_PREFIX = "[WARN]  ";
    private static final String INFO_PREFIX = "[INFO]  ";
    protected static final String SELF_LOG_FILE = "tracer-self.log";
    private static AsyncCommonAppenderManager selfLogAppenderManager = new AsyncCommonAppenderManager(1024, "tracer-self.log");

    public static void error(String log, Throwable e) {
        try {
            String timestamp = Timestamp.currentTime();
            StringWriter sw = new StringWriter(4096);
            PrintWriter pw = new PrintWriter((Writer)sw, false);
            pw.append(timestamp).append(ERROR_PREFIX).append(log).append("\r\n");
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            selfLogAppenderManager.append(sw.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void errorWithTraceId(String log, Throwable e) {
        try {
            String timestamp = Timestamp.currentTime();
            StringWriter sw = new StringWriter(4096);
            PrintWriter pw = new PrintWriter((Writer)sw, false);
            pw.append(timestamp).append(ERROR_PREFIX).append("[").append(TracerUtils.getTraceId()).append("]").append(log).append("\r\n");
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            selfLogAppenderManager.append(sw.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void error(String log) {
        SelfLog.doLog(log, ERROR_PREFIX);
    }

    public static void errorWithTraceId(String log, String traceId) {
        SelfLog.doLog(log, "[ERROR] [" + traceId + "]");
    }

    public static void errorWithTraceId(String log) {
        SelfLog.doLog(log, "[ERROR] [" + TracerUtils.getTraceId() + "]");
    }

    public static void warn(String log) {
        SelfLog.doLog(log, WARN_PREFIX);
    }

    public static void info(String log) {
        SelfLog.doLog(log, INFO_PREFIX);
    }

    public static void infoWithTraceId(String log) {
        SelfLog.doLog(log, "[INFO]  [" + TracerUtils.getTraceId() + "]");
    }

    public static void flush() {
    }

    private static void doLog(String log, String prefix) {
        try {
            String timestamp = Timestamp.currentTime();
            StringBuilder sb = new StringBuilder();
            sb.append(timestamp).append(prefix).append(log).append("\r\n");
            selfLogAppenderManager.append(sb.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        selfLogAppenderManager.start("SelfLogAppender");
    }
}

