/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.internals;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.huaweicloud.lts.producer.Attempt;
import com.huaweicloud.lts.producer.Callback;
import com.huaweicloud.lts.producer.Result;
import com.huaweicloud.lts.producer.exception.ResultFailedException;
import com.huaweicloud.lts.producer.internals.GroupKey;
import com.huaweicloud.lts.producer.model.log.LogContent;
import com.huaweicloud.lts.producer.model.log.LogItem;
import com.huaweicloud.lts.producer.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerBatch
implements Delayed {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerBatch.class);
    private final GroupKey groupKey;
    private final String packageId;
    private final int batchSizeThresholdInBytes;
    private final int batchCountThreshold;
    protected final List<LogItem> logItems = new ArrayList<LogItem>();
    protected final List<Thunk> thunks = new ArrayList<Thunk>();
    private final long createdMs;
    private long nextRetryMs;
    protected int curBatchSizeInBytes;
    protected int curBatchCount;
    private final EvictingQueue<Attempt> reservedAttempts;
    private int attemptCount;
    private final String appName;
    private final String pathFile;

    public ProducerBatch(GroupKey groupKey, String packageId, int batchSizeThresholdInBytes, int batchCountThreshold, int maxReservedAttempts, long nowMs, String appName, String pathFile) {
        this.groupKey = groupKey;
        this.packageId = packageId;
        this.createdMs = nowMs;
        this.batchSizeThresholdInBytes = batchSizeThresholdInBytes;
        this.batchCountThreshold = batchCountThreshold;
        this.curBatchCount = 0;
        this.curBatchSizeInBytes = 0;
        this.appName = appName;
        this.pathFile = pathFile;
        this.reservedAttempts = EvictingQueue.create((int)maxReservedAttempts);
        this.attemptCount = 0;
    }

    public ListenableFuture<Result> tryAppend(List<LogItem> items, int sizeInBytes, Callback callback, boolean isLogBackSdk, int maxSingleLogSizeInBytes, boolean giveUpExtraLongSingleLog) {
        if (isLogBackSdk) {
            return this.tryAppendLogBack(items, sizeInBytes, maxSingleLogSizeInBytes, giveUpExtraLongSingleLog, callback);
        }
        return this.tryAppend(items, sizeInBytes, maxSingleLogSizeInBytes, giveUpExtraLongSingleLog, callback);
    }

    private ListenableFuture<Result> tryAppendLogBack(List<LogItem> items, int sizeInBytes, int maxSingleLogSizeInBytes, boolean giveUpExtraLongSingleLog, Callback callback) {
        this.overLimitSplitLog(items, maxSingleLogSizeInBytes, giveUpExtraLongSingleLog);
        if (!this.hasRoomFor(sizeInBytes, items.get(0).getContents().size())) {
            return null;
        }
        SettableFuture future = SettableFuture.create();
        if (this.logItems.size() == 0) {
            this.logItems.addAll(items);
        } else {
            LogItem logItem = this.logItems.get(0);
            logItem.getContents().addAll(items.get(0).getContents());
        }
        this.thunks.add(new Thunk(callback, (SettableFuture<Result>)future));
        this.curBatchCount += items.get(0).getContents().size();
        this.curBatchSizeInBytes += sizeInBytes;
        return future;
    }

    private void overLimitSplitLog(List<LogItem> items, int maxSingleLogSizeInBytes, boolean giveUpExtraLongSingleLog) {
        for (LogItem logItem : items) {
            ArrayList<LogContent> newContents = new ArrayList<LogContent>();
            for (LogContent logContent : logItem.getContents()) {
                if (logContent.getLog().length() <= maxSingleLogSizeInBytes) continue;
                if (giveUpExtraLongSingleLog) {
                    String log = logContent.getLog().substring(0, maxSingleLogSizeInBytes);
                    logContent.setLog(log);
                    continue;
                }
                List<String> strList = Utils.getStrList(logContent.getLog(), maxSingleLogSizeInBytes);
                AtomicLong timeNs = new AtomicLong(logContent.getLogTimeNs());
                logContent.setLog(strList.get(0));
                for (int i = 1; i < strList.size(); ++i) {
                    newContents.add(new LogContent(timeNs.addAndGet(1L), strList.get(i)));
                }
            }
            logItem.getContents().addAll(newContents);
        }
    }

    private SettableFuture<Result> tryAppend(List<LogItem> items, int sizeInBytes, int maxSingleLogSizeInBytes, boolean giveUpExtraLongSingleLog, Callback callback) {
        this.overLimitSplitLog(items, maxSingleLogSizeInBytes, giveUpExtraLongSingleLog);
        AtomicInteger count = new AtomicInteger(0);
        for (LogItem logItem : items) {
            count.addAndGet(logItem.getContents().size());
        }
        if (!this.hasRoomFor(sizeInBytes, count.get())) {
            return null;
        }
        SettableFuture future = SettableFuture.create();
        this.logItems.addAll(items);
        this.thunks.add(new Thunk(callback, (SettableFuture<Result>)future));
        this.curBatchCount += count.get();
        this.curBatchSizeInBytes += sizeInBytes;
        return future;
    }

    public void appendAttempt(Attempt attempt) {
        this.reservedAttempts.add((Object)attempt);
        ++this.attemptCount;
    }

    public boolean isMeetSendCondition() {
        return this.curBatchSizeInBytes >= this.batchSizeThresholdInBytes || this.curBatchCount >= this.batchCountThreshold;
    }

    public long remainingMs(long nowMs, long lingerMs) {
        return lingerMs - this.createdTimeMs(nowMs);
    }

    public void fireCallbacksAndSetFutures() {
        ArrayList<Attempt> attempts = new ArrayList<Attempt>((Collection<Attempt>)this.reservedAttempts);
        Attempt attempt = (Attempt)Iterables.getLast(attempts);
        Result result = new Result(attempt.isSuccess(), attempts, this.attemptCount);
        this.fireCallbacks(result);
        this.setFutures(result);
    }

    public GroupKey getGroupKey() {
        return this.groupKey;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public List<LogItem> getLogItems() {
        return this.logItems;
    }

    public long getNextRetryMs() {
        return this.nextRetryMs;
    }

    public void setNextRetryMs(long nextRetryMs) {
        this.nextRetryMs = nextRetryMs;
    }

    public String getLogGroupId() {
        return this.groupKey.getLogGroupId();
    }

    public String getLogStreamId() {
        return this.groupKey.getLogStreamId();
    }

    public int getCurBatchSizeInBytes() {
        return this.curBatchSizeInBytes;
    }

    public int getRetries() {
        return Math.max(0, this.attemptCount - 1);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getPathFile() {
        return this.pathFile;
    }

    protected boolean hasRoomFor(int sizeInBytes, int count) {
        return this.curBatchSizeInBytes + sizeInBytes <= 0xA00000 && this.curBatchCount + count <= 40960;
    }

    private long createdTimeMs(long nowMs) {
        return Math.max(0L, nowMs - this.createdMs);
    }

    private void fireCallbacks(Result result) {
        for (Thunk thunk : this.thunks) {
            try {
                if (thunk.callback == null) continue;
                thunk.callback.onCompletion(result);
            }
            catch (Exception e) {
                LOGGER.error("Failed to execute user-provided callback, groupKey={}, e=", (Object)this.groupKey, (Object)e);
            }
        }
    }

    private void setFutures(Result result) {
        for (Thunk thunk : this.thunks) {
            try {
                if (result.isSuccessful()) {
                    thunk.future.set((Object)result);
                    continue;
                }
                thunk.future.setException((Throwable)new ResultFailedException(result));
            }
            catch (Exception e) {
                LOGGER.error("Failed to set future, groupKey={}, e=", (Object)this.groupKey, (Object)e);
            }
        }
    }

    @Override
    public long getDelay(@Nonnull TimeUnit unit) {
        return unit.convert(this.nextRetryMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(@Nonnull Delayed o) {
        return (int)(this.nextRetryMs - ((ProducerBatch)o).getNextRetryMs());
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "ProducerBatch{groupKey=" + this.groupKey + ", packageId='" + this.packageId + '\'' + ", batchSizeThresholdInBytes=" + this.batchSizeThresholdInBytes + ", batchCountThreshold=" + this.batchCountThreshold + ", logItems=" + this.logItems + ", thunks=" + this.thunks + ", createdMs=" + this.createdMs + ", nextRetryMs=" + this.nextRetryMs + ", curBatchSizeInBytes=" + this.curBatchSizeInBytes + ", curBatchCount=" + this.curBatchCount + ", reservedAttempts=" + this.reservedAttempts + ", attemptCount=" + this.attemptCount + '}';
    }

    protected static final class Thunk {
        final Callback callback;
        final SettableFuture<Result> future;

        Thunk(Callback callback, SettableFuture<Result> future) {
            this.callback = callback;
            this.future = future;
        }
    }
}

