/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.web.filter.AbstractWebFilter;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public final class HealthFilter
extends AbstractWebFilter {
    private final DispatcherHandler dispatcherHandler;
    private final Set<String> paths;

    public HealthFilter(DispatcherHandler dispatcherHandler, List<String> paths) {
        this.dispatcherHandler = dispatcherHandler;
        this.paths = CollectionUtils.isEmpty(paths) ? new HashSet<String>(Arrays.asList("/actuator", "/health_check")) : new HashSet<String>(paths);
    }

    @Override
    protected Mono<Boolean> doMatcher(ServerWebExchange exchange, WebFilterChain chain) {
        return Mono.just((Object)this.paths.stream().anyMatch(path -> exchange.getRequest().getURI().getRawPath().startsWith((String)path)));
    }

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange) {
        return this.dispatcherHandler.handle(exchange);
    }
}

