/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support.wrapper;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.protocol.dubbo.FutureAdapter;
import org.apache.dubbo.rpc.support.MockInvoker;
import org.apache.dubbo.rpc.support.RpcUtils;

public class MockClusterInvoker<T>
implements ClusterInvoker<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(MockClusterInvoker.class);
    private static final boolean setFutureWhenSync = Boolean.parseBoolean(System.getProperty("future.sync.set", "true"));
    private final Directory<T> directory;
    private final Invoker<T> invoker;

    public MockClusterInvoker(Directory<T> directory, Invoker<T> invoker) {
        this.directory = directory;
        this.invoker = invoker;
    }

    @Override
    public URL getUrl() {
        return this.directory.getConsumerUrl();
    }

    @Override
    public URL getRegistryUrl() {
        return this.directory.getUrl();
    }

    @Override
    public Directory<T> getDirectory() {
        return this.directory;
    }

    @Override
    public boolean isDestroyed() {
        return this.directory.isDestroyed();
    }

    @Override
    public boolean isAvailable() {
        return this.directory.isAvailable();
    }

    @Override
    public void destroy() {
        this.invoker.destroy();
    }

    @Override
    public Class<T> getInterface() {
        return this.directory.getInterface();
    }

    @Override
    public Result invoke(Invocation invocation) throws RpcException {
        Result result;
        String value = this.getUrl().getMethodParameter(RpcUtils.getMethodName(invocation), "mock", Boolean.FALSE.toString()).trim();
        if (ConfigUtils.isEmpty(value)) {
            result = this.invoker.invoke(invocation);
        } else if (value.startsWith("force")) {
            if (logger.isWarnEnabled()) {
                logger.warn("2-17", "force mock", "", "force-mock: " + RpcUtils.getMethodName(invocation) + " force-mock enabled , url : " + this.getUrl());
            }
            result = this.doMockInvoke(invocation, null);
        } else {
            try {
                result = this.invoker.invoke(invocation);
                if (result.getException() != null && result.getException() instanceof RpcException) {
                    RpcException rpcException = (RpcException)result.getException();
                    if (rpcException.isBiz()) {
                        throw rpcException;
                    }
                    result = this.doMockInvoke(invocation, rpcException);
                }
            }
            catch (RpcException e) {
                if (e.isBiz()) {
                    throw e;
                }
                if (logger.isWarnEnabled()) {
                    logger.warn("2-17", "failed to mock invoke", "", "fail-mock: " + RpcUtils.getMethodName(invocation) + " fail-mock enabled , url : " + this.getUrl(), e);
                }
                result = this.doMockInvoke(invocation, e);
            }
        }
        return result;
    }

    private Result doMockInvoke(Invocation invocation, RpcException e) {
        Result result;
        RpcInvocation rpcInvocation = (RpcInvocation)invocation;
        rpcInvocation.setInvokeMode(RpcUtils.getInvokeMode(this.getUrl(), invocation));
        List<Invoker<T>> mockInvokers = this.selectMockInvoker(invocation);
        Invoker<T> mockInvoker = CollectionUtils.isEmpty(mockInvokers) ? new MockInvoker<T>(this.getUrl(), this.directory.getInterface()) : mockInvokers.get(0);
        try {
            result = mockInvoker.invoke(invocation);
        }
        catch (RpcException mockException) {
            if (mockException.isBiz()) {
                result = AsyncRpcResult.newDefaultAsyncResult(mockException.getCause(), invocation);
            }
            throw new RpcException(mockException.getCode(), this.getMockExceptionMessage(e, mockException), mockException.getCause());
        }
        catch (Throwable me) {
            throw new RpcException(this.getMockExceptionMessage(e, me), me.getCause());
        }
        if (setFutureWhenSync || rpcInvocation.getInvokeMode() != InvokeMode.SYNC) {
            RpcContext.getServiceContext().setFuture(new FutureAdapter(((AsyncRpcResult)result).getResponseFuture()));
        }
        return result;
    }

    private String getMockExceptionMessage(Throwable t, Throwable mt) {
        String msg = "mock error : " + mt.getMessage();
        if (t != null) {
            msg = msg + ", invoke error is :" + StringUtils.toString(t);
        }
        return msg;
    }

    private List<Invoker<T>> selectMockInvoker(Invocation invocation) {
        List<Invoker<T>> invokers;
        block3: {
            invokers = null;
            if (invocation instanceof RpcInvocation) {
                invocation.setAttachment("invocation.need.mock", Boolean.TRUE.toString());
                try {
                    RpcContext.getServiceContext().setConsumerUrl(this.getUrl());
                    invokers = this.directory.list(invocation);
                }
                catch (RpcException e) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info("Exception when try to invoke mock. Get mock invokers error for service:" + this.getUrl().getServiceInterface() + ", method:" + RpcUtils.getMethodName(invocation) + ", will construct a new mock with 'new MockInvoker()'.", e);
                }
            }
        }
        return invokers;
    }

    public String toString() {
        return "invoker :" + this.invoker + ",directory: " + this.directory;
    }
}

