/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.registry.client.migration.model.MigrationStep;
import org.apache.dubbo.registry.client.migration.model.SubMigrationRule;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class MigrationRule {
    private String key;
    private MigrationStep step;
    private Float threshold;
    private Integer proportion;
    private Integer delay;
    private Boolean force;
    private List<SubMigrationRule> interfaces;
    private List<SubMigrationRule> applications;
    private transient Map<String, SubMigrationRule> interfaceRules;
    private transient Map<String, SubMigrationRule> applicationRules;

    public static MigrationRule getInitRule() {
        return new MigrationRule();
    }

    private static MigrationRule parseFromMap(Map<String, Object> map) {
        Object applications;
        Object interfaces;
        Object force;
        Object delay;
        Object proportion;
        Object threshold;
        MigrationRule migrationRule = new MigrationRule();
        migrationRule.setKey((String)map.get("key"));
        Object step = map.get("step");
        if (step != null) {
            migrationRule.setStep(MigrationStep.valueOf(step.toString()));
        }
        if ((threshold = map.get("threshold")) != null) {
            migrationRule.setThreshold(Float.valueOf(threshold.toString()));
        }
        if ((proportion = map.get("proportion")) != null) {
            migrationRule.setProportion(Integer.valueOf(proportion.toString()));
        }
        if ((delay = map.get("delay")) != null) {
            migrationRule.setDelay(Integer.valueOf(delay.toString()));
        }
        if ((force = map.get("force")) != null) {
            migrationRule.setForce(Boolean.valueOf(force.toString()));
        }
        if ((interfaces = map.get("interfaces")) != null && List.class.isAssignableFrom(interfaces.getClass())) {
            migrationRule.setInterfaces(((List)interfaces).stream().map(SubMigrationRule::parseFromMap).collect(Collectors.toList()));
        }
        if ((applications = map.get("applications")) != null && List.class.isAssignableFrom(applications.getClass())) {
            migrationRule.setApplications(((List)applications).stream().map(SubMigrationRule::parseFromMap).collect(Collectors.toList()));
        }
        return migrationRule;
    }

    public MigrationRule() {
    }

    public MigrationRule(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public MigrationStep getStep(URL consumerURL) {
        MigrationStep value = this.getValue(consumerURL, SubMigrationRule::getStep);
        if (value != null) {
            return value;
        }
        if (this.step == null) {
            return Enum.valueOf(MigrationStep.class, consumerURL.getParameter("migration.step", this.getDefaultStep(consumerURL, MigrationStep.APPLICATION_FIRST.name())));
        }
        return this.step;
    }

    private String getDefaultStep(URL consumerURL, String defaultStep) {
        String globalDefaultStep = ConfigurationUtils.getCachedDynamicProperty(consumerURL.getScopeModel(), "dubbo.application.migration.step", null);
        if (StringUtils.isEmpty(globalDefaultStep)) {
            globalDefaultStep = ConfigurationUtils.getCachedDynamicProperty(consumerURL.getScopeModel(), "dubbo.application.service-discovery.migration", defaultStep);
        }
        return globalDefaultStep;
    }

    public MigrationStep getStep() {
        return this.step;
    }

    public float getThreshold(URL consumerURL) {
        Float value = this.getValue(consumerURL, SubMigrationRule::getThreshold);
        if (value != null) {
            return value.floatValue();
        }
        return this.threshold == null ? consumerURL.getParameter("migration.threshold", -1.0f) : this.threshold.floatValue();
    }

    public Float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Float threshold) {
        this.threshold = threshold;
    }

    public Integer getProportion() {
        return this.proportion;
    }

    public int getProportion(URL consumerURL) {
        Integer value = this.getValue(consumerURL, SubMigrationRule::getProportion);
        if (value != null) {
            return value;
        }
        return this.proportion == null ? consumerURL.getParameter("migration.promotion", 100) : this.proportion.intValue();
    }

    public void setProportion(Integer proportion) {
        this.proportion = proportion;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public int getDelay(URL consumerURL) {
        Integer value = this.getValue(consumerURL, SubMigrationRule::getDelay);
        if (value != null) {
            return value;
        }
        return this.delay == null ? consumerURL.getParameter("migration.delay", 0) : this.delay.intValue();
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public void setStep(MigrationStep step) {
        this.step = step;
    }

    public Boolean getForce() {
        return this.force;
    }

    public boolean getForce(URL consumerURL) {
        Boolean value = this.getValue(consumerURL, SubMigrationRule::getForce);
        if (value != null) {
            return value;
        }
        return this.force == null ? consumerURL.getParameter("migration.force", false) : this.force.booleanValue();
    }

    public <T> T getValue(URL consumerURL, Function<SubMigrationRule, T> function) {
        ServiceNameMapping serviceNameMapping;
        Set<String> services;
        T value;
        SubMigrationRule rule;
        if (this.interfaceRules != null && (rule = this.interfaceRules.get(consumerURL.getDisplayServiceKey())) != null && (value = function.apply(rule)) != null) {
            return value;
        }
        if (this.applications != null && CollectionUtils.isNotEmpty(services = (serviceNameMapping = ServiceNameMapping.getDefaultExtension(consumerURL.getScopeModel())).getRemoteMapping(consumerURL))) {
            for (String service : services) {
                T value2;
                SubMigrationRule rule2 = this.applicationRules.get(service);
                if (rule2 == null || (value2 = function.apply(rule2)) == null) continue;
                return value2;
            }
        }
        return null;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public List<SubMigrationRule> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<SubMigrationRule> interfaces) {
        this.interfaces = interfaces;
        if (interfaces != null) {
            this.interfaceRules = new HashMap<String, SubMigrationRule>();
            interfaces.forEach(rule -> this.interfaceRules.put(rule.getServiceKey(), (SubMigrationRule)rule));
        }
    }

    public List<SubMigrationRule> getApplications() {
        return this.applications;
    }

    public void setApplications(List<SubMigrationRule> applications) {
        this.applications = applications;
        if (applications != null) {
            this.applicationRules = new HashMap<String, SubMigrationRule>();
            applications.forEach(rule -> this.applicationRules.put(rule.getServiceKey(), (SubMigrationRule)rule));
        }
    }

    public static MigrationRule parse(String rawRule) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        Map map = (Map)yaml.load(rawRule);
        return MigrationRule.parseFromMap(map);
    }

    public static String toYaml(MigrationRule rule) {
        Constructor constructor = new Constructor(MigrationRule.class, new LoaderOptions());
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        return yaml.dump((Object)rule);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationRule that = (MigrationRule)o;
        return Objects.equals(this.key, that.key) && this.step == that.step && Objects.equals(this.threshold, that.threshold) && Objects.equals(this.proportion, that.proportion) && Objects.equals(this.delay, that.delay) && Objects.equals(this.force, that.force) && Objects.equals(this.interfaces, that.interfaces) && Objects.equals(this.applications, that.applications) && Objects.equals(this.interfaceRules, that.interfaceRules) && Objects.equals(this.applicationRules, that.applicationRules);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.step, this.threshold, this.proportion, this.delay, this.force, this.interfaces, this.applications, this.interfaceRules, this.applicationRules});
    }
}

