/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.auth.utils;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignatureUtils {
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";

    public static String sign(String metadata, String key) throws RuntimeException {
        return SignatureUtils.sign(metadata.getBytes(StandardCharsets.UTF_8), key);
    }

    public static String sign(Object[] parameters, String metadata, String key) throws RuntimeException {
        byte[] includeMetadataBytes;
        if (parameters == null) {
            return SignatureUtils.sign(metadata, key);
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof Serializable) continue;
            throw new IllegalArgumentException("The parameter [" + i + "] to be signed was not serializable.");
        }
        Object[] includeMetadata = new Object[parameters.length + 1];
        System.arraycopy(parameters, 0, includeMetadata, 0, parameters.length);
        includeMetadata[parameters.length] = metadata;
        try {
            includeMetadataBytes = SignatureUtils.toByteArray(includeMetadata);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate HMAC: " + e.getMessage());
        }
        return SignatureUtils.sign(includeMetadataBytes, key);
    }

    private static String sign(byte[] data, String key) throws RuntimeException {
        byte[] rawHmac;
        Mac mac;
        try {
            mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to generate HMAC: no such algorithm exception HmacSHA256");
        }
        SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), HMAC_SHA256_ALGORITHM);
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Failed to generate HMAC: invalid key exception");
        }
        try {
            rawHmac = mac.doFinal(data);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("Failed to generate HMAC: " + e.getMessage());
        }
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    /*
     * Exception decompiling
     */
    private static byte[] toByteArray(Object[] parameters) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

