/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.core.nio;

import com.qq.tars.net.core.Session;
import com.qq.tars.net.core.SessionEvent;
import com.qq.tars.net.core.SessionListener;
import com.qq.tars.net.core.SessionManager;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SessionManagerImpl
extends SessionManager {
    private long timeout = 60000L;
    private long interval = 30000L;
    private List<SessionListener> listeners = new LinkedList<SessionListener>();
    private CopyOnWriteArrayList<Session> sessionList = new CopyOnWriteArrayList();
    private volatile boolean started = false;

    @Override
    public void registerSession(Session session) {
        this.sessionList.add(session);
        this.notifySessionCreated(session);
    }

    @Override
    public void unregisterSession(Session session) {
        this.sessionList.remove(session);
        this.notifySessionDestroy(session);
    }

    @Override
    public void addSessionListener(SessionListener listener) {
        this.listeners.add(listener);
    }

    private void notifySessionCreated(Session newSession) {
        for (SessionListener listener : this.listeners) {
            try {
                listener.onSessionCreated(new SessionEvent(newSession));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void notifySessionDestroy(Session oldSession) {
        for (SessionListener listener : this.listeners) {
            try {
                listener.onSessionDestroyed(new SessionEvent(oldSession));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("The session manager service started...");
                long lastUpdateOperationTime = -1L;
                while (true) {
                    try {
                        while (true) {
                            for (Session session : SessionManagerImpl.this.sessionList) {
                                lastUpdateOperationTime = session.getLastOperationTime();
                                if (System.currentTimeMillis() - lastUpdateOperationTime <= SessionManagerImpl.this.timeout) continue;
                                String s = "The session has timed out. [from ip: " + session.getRemoteIp() + " port: " + session.getRemotePort() + "]";
                                System.out.println(s);
                                session.asyncClose();
                            }
                            Thread.sleep(SessionManagerImpl.this.interval);
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }, "SessionManageImpl Thread").start();
        this.started = true;
    }

    @Override
    public void setCheckInterval(long interval) {
        this.interval = interval;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

