/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.core.nio;

import com.qq.tars.net.core.Session;
import com.qq.tars.net.core.nio.Acceptor;
import com.qq.tars.net.core.nio.SelectorManager;
import com.qq.tars.net.core.nio.TCPAcceptor;
import com.qq.tars.net.core.nio.TCPSession;
import com.qq.tars.net.core.nio.UDPAcceptor;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public final class Reactor
extends Thread {
    protected volatile Selector selector = null;
    private volatile boolean crashed = false;
    private final Queue<Object[]> register = new LinkedBlockingQueue<Object[]>();
    private final Queue<Session> unregister = new LinkedBlockingQueue<Session>();
    private Acceptor acceptor = null;

    public Reactor(SelectorManager selectorManager, String name) throws IOException {
        this(selectorManager, name, false);
    }

    public Reactor(SelectorManager selectorManager, String name, boolean udpMode) throws IOException {
        super(name);
        this.acceptor = udpMode ? new UDPAcceptor(selectorManager) : new TCPAcceptor(selectorManager);
        this.selector = Selector.open();
    }

    public void registerChannel(SelectableChannel channel, int ops) throws IOException {
        this.registerChannel(channel, ops, null);
    }

    public void unRegisterChannel(Session session) {
        if (this.unregister.contains(session)) {
            return;
        }
        this.unregister.add(session);
        this.selector.wakeup();
    }

    public void registerChannel(SelectableChannel channel, int ops, Object attachment) throws IOException {
        if (this.crashed) {
            throw new IOException("The reactor thread crashed.... ");
        }
        if (Thread.currentThread() == this) {
            SelectionKey key = channel.register(this.selector, ops, attachment);
            if (attachment instanceof TCPSession) {
                ((TCPSession)attachment).setKey(key);
            }
        } else {
            this.register.offer(new Object[]{channel, ops, attachment});
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                this.selector.select();
                this.processRegister();
                Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (!key.isValid()) continue;
                    try {
                        if (key.attachment() != null && key.attachment() instanceof Session) {
                            ((Session)key.attachment()).updateLastOperationTime();
                        }
                        this.dispatchEvent(key);
                    }
                    catch (Throwable ex) {
                        this.disConnectWithException(key, ex);
                    }
                }
                this.processUnRegister();
            }
        }
        catch (Throwable e) {
            this.crashed = true;
            e.printStackTrace();
        }
        finally {
            try {
                this.selector.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void disConnectWithException(SelectionKey key, Throwable ex) {
        try {
            Session session = (Session)key.attachment();
            if (session == null) {
                if (key.channel() instanceof SocketChannel) {
                    key.channel().close();
                }
            } else {
                session.close();
            }
            ex.printStackTrace();
        }
        catch (Throwable e2) {
            ex.printStackTrace();
        }
    }

    private void processUnRegister() {
        Session session = null;
        while ((session = this.unregister.poll()) != null) {
            try {
                ((TCPSession)session).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void processRegister() {
        Object[] object = null;
        SelectableChannel channel = null;
        int ops = -1;
        Object attachment = null;
        while ((object = this.register.poll()) != null) {
            try {
                channel = (SelectableChannel)object[0];
                ops = (Integer)object[1];
                attachment = object[2];
                if (!channel.isOpen()) continue;
                SelectionKey key = channel.register(this.selector, ops, attachment);
                if (!(attachment instanceof TCPSession)) continue;
                ((TCPSession)attachment).setKey(key);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void dispatchEvent(SelectionKey key) throws IOException {
        if (key.isConnectable()) {
            this.acceptor.handleConnectEvent(key);
        } else if (key.isAcceptable()) {
            this.acceptor.handleAcceptEvent(key);
        } else if (key.isReadable()) {
            this.acceptor.handleReadEvent(key);
        } else if (key.isValid() && key.isWritable()) {
            this.acceptor.handleWriteEvent(key);
        }
    }
}

