/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mcp.server.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.SchemaVersion;
import io.micrometer.common.util.StringUtils;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.plugin.mcp.server.model.McpServerToolParameter;
import org.springframework.ai.util.json.JsonParser;
import org.springframework.ai.util.json.schema.JsonSchemaGenerator;

public final class JsonSchemaUtil {
    public static String emptySchema(JsonSchemaGenerator.SchemaOption ... schemaOptions) {
        ObjectNode schema = JsonParser.getObjectMapper().createObjectNode();
        schema.put("$schema", SchemaVersion.DRAFT_2020_12.getIdentifier());
        schema.put("type", "object");
        JsonSchemaUtil.processSchemaOptions(schemaOptions, schema);
        return schema.toPrettyString();
    }

    public static String createParameterSchema(List<McpServerToolParameter> parameters, JsonSchemaGenerator.SchemaOption ... schemaOptions) {
        if (CollectionUtils.isEmpty(parameters)) {
            return JsonSchemaUtil.emptySchema(schemaOptions);
        }
        ObjectNode schema = JsonParser.getObjectMapper().createObjectNode();
        schema.put("$schema", SchemaVersion.DRAFT_2020_12.getIdentifier());
        schema.put("type", "object");
        ObjectNode properties = schema.putObject("properties");
        for (McpServerToolParameter parameter : parameters) {
            ObjectNode property = properties.putObject(parameter.getName());
            JsonSchemaUtil.recursionConstructPropertiesNodes(parameter, property);
        }
        JsonSchemaUtil.processSchemaOptions(schemaOptions, schema);
        return schema.toPrettyString();
    }

    public static void recursionConstructPropertiesNodes(McpServerToolParameter parameter, ObjectNode property) {
        property.put("type", parameter.getType());
        if (StringUtils.isNotBlank((String)parameter.getDescription())) {
            property.put("description", parameter.getDescription());
        }
        List<McpServerToolParameter> parameters = parameter.getParameters();
        if ("object".equals(parameter.getType()) && CollectionUtils.isNotEmpty(parameters)) {
            ObjectNode properties = property.putObject("properties");
            for (McpServerToolParameter itemParameter : parameters) {
                ObjectNode property1 = properties.putObject(itemParameter.getName());
                JsonSchemaUtil.recursionConstructPropertiesNodes(itemParameter, property1);
            }
        }
        if ("array".equals(parameter.getType()) && CollectionUtils.isNotEmpty(parameters)) {
            McpServerToolParameter itemParameter = parameters.get(0);
            ObjectNode items = property.putObject("items");
            JsonSchemaUtil.recursionConstructPropertiesNodes(itemParameter, items);
        }
    }

    private static void processSchemaOptions(JsonSchemaGenerator.SchemaOption[] schemaOptions, ObjectNode schema) {
        if (Stream.of(schemaOptions).noneMatch(option -> option == JsonSchemaGenerator.SchemaOption.ALLOW_ADDITIONAL_PROPERTIES_BY_DEFAULT)) {
            schema.put("additionalProperties", false);
        }
        if (Stream.of(schemaOptions).anyMatch(option -> option == JsonSchemaGenerator.SchemaOption.UPPER_CASE_TYPE_VALUES)) {
            JsonSchemaUtil.convertTypeValuesToUpperCase(schema);
        }
    }

    public static void convertTypeValuesToUpperCase(ObjectNode node) {
        if (node.isObject()) {
            node.fields().forEachRemaining(entry -> {
                JsonNode value = (JsonNode)entry.getValue();
                if (value.isObject()) {
                    JsonSchemaUtil.convertTypeValuesToUpperCase((ObjectNode)value);
                } else if (value.isArray()) {
                    value.elements().forEachRemaining(element -> {
                        if (element.isObject() || element.isArray()) {
                            JsonSchemaUtil.convertTypeValuesToUpperCase((ObjectNode)element);
                        }
                    });
                } else if (value.isTextual() && ((String)entry.getKey()).equals("type")) {
                    String oldValue = node.get("type").asText();
                    node.put("type", oldValue.toUpperCase());
                }
            });
        } else if (node.isArray()) {
            node.elements().forEachRemaining(element -> {
                if (element.isObject() || element.isArray()) {
                    JsonSchemaUtil.convertTypeValuesToUpperCase((ObjectNode)element);
                }
            });
        }
    }
}

