/*
 * Decompiled with CFR 0.152.
 */
package io.fury.memory;

import io.fury.memory.MemoryBuffer;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class MemoryUtils {
    public static MemoryBuffer buffer(int size) {
        return MemoryUtils.wrap(new byte[size]);
    }

    public static MemoryBuffer buffer(long address, int size) {
        return MemoryBuffer.fromNativeAddress(address, size);
    }

    public static MemoryBuffer wrap(byte[] buffer, int offset, int length) {
        return MemoryBuffer.fromByteArray(buffer, offset, length);
    }

    public static MemoryBuffer wrap(byte[] buffer) {
        return MemoryBuffer.fromByteArray(buffer);
    }

    public static MemoryBuffer wrap(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            return MemoryBuffer.fromByteBuffer(buffer);
        }
        int offset = buffer.arrayOffset() + buffer.position();
        return MemoryBuffer.fromByteArray(buffer.array(), offset, buffer.remaining());
    }

    public static void wrap(ByteArrayOutputStream stream, MemoryBuffer buffer) {
        Preconditions.checkNotNull(stream);
        byte[] buf = (byte[])Platform.getObject(stream, Offset.BAS_BUF_BUF);
        int count = Platform.getInt(stream, Offset.BAS_BUF_COUNT);
        buffer.pointTo(buf, 0, buf.length);
        buffer.writerIndex(count);
    }

    public static void wrap(MemoryBuffer buffer, ByteArrayOutputStream stream) {
        Preconditions.checkNotNull(stream);
        byte[] bytes = buffer.getHeapMemory();
        Preconditions.checkNotNull(bytes);
        Platform.putObject(stream, Offset.BAS_BUF_BUF, bytes);
        Platform.putInt(stream, Offset.BAS_BUF_COUNT, buffer.writerIndex());
    }

    public static void wrap(ByteArrayInputStream stream, MemoryBuffer buffer) {
        Preconditions.checkNotNull(stream);
        byte[] buf = (byte[])Platform.getObject(stream, Offset.BIS_BUF_BUF);
        int count = Platform.getInt(stream, Offset.BIS_BUF_COUNT);
        int pos = Platform.getInt(stream, Offset.BIS_BUF_POS);
        buffer.pointTo(buf, 0, count);
        buffer.readerIndex(pos);
    }

    public static int writePositiveVarInt(byte[] arr, int index, int v) {
        if (v >>> 7 == 0) {
            arr[index] = (byte)v;
            return 1;
        }
        if (v >>> 14 == 0) {
            arr[index++] = (byte)(v & 0x7F | 0x80);
            arr[index] = (byte)(v >>> 7);
            return 2;
        }
        if (v >>> 21 == 0) {
            arr[index++] = (byte)(v & 0x7F | 0x80);
            arr[index++] = (byte)(v >>> 7 | 0x80);
            arr[index] = (byte)(v >>> 14);
            return 3;
        }
        if (v >>> 28 == 0) {
            arr[index++] = (byte)(v & 0x7F | 0x80);
            arr[index++] = (byte)(v >>> 7 | 0x80);
            arr[index++] = (byte)(v >>> 14 | 0x80);
            arr[index] = (byte)(v >>> 21);
            return 4;
        }
        arr[index++] = (byte)(v & 0x7F | 0x80);
        arr[index++] = (byte)(v >>> 7 | 0x80);
        arr[index++] = (byte)(v >>> 14 | 0x80);
        arr[index++] = (byte)(v >>> 21 | 0x80);
        arr[index] = (byte)(v >>> 28);
        return 5;
    }

    private static class Offset {
        private static final long BAS_BUF_BUF;
        private static final long BAS_BUF_COUNT;
        private static final long BIS_BUF_BUF;
        private static final long BIS_BUF_POS;
        private static final long BIS_BUF_COUNT;

        private Offset() {
        }

        static {
            try {
                BAS_BUF_BUF = Platform.objectFieldOffset(ByteArrayOutputStream.class.getDeclaredField("buf"));
                BAS_BUF_COUNT = Platform.objectFieldOffset(ByteArrayOutputStream.class.getDeclaredField("count"));
                BIS_BUF_BUF = Platform.objectFieldOffset(ByteArrayInputStream.class.getDeclaredField("buf"));
                BIS_BUF_POS = Platform.objectFieldOffset(ByteArrayInputStream.class.getDeclaredField("pos"));
                BIS_BUF_COUNT = Platform.objectFieldOffset(ByteArrayInputStream.class.getDeclaredField("count"));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

