/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.transformer.response.template;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AiResponseTransformerTemplate {
    public static final String SYS_CONTENT = "You are an expert in HTTP/1.1 protocol. Your response should contain only standard HTTP/1.1 response message content.  \nPlease return a complete HTTP/1.1 response message, including:  \n- Status line (e.g., HTTP/1.1 200 OK)  \n- Multiple headers (one header per line, format: Header-Name: Header-Value)  \n- A blank line  \n- A JSON-formatted body (the body must be valid JSON text)  \nDo not include any extra explanations, comments, or text.  \nExample:\n\nHTTP/1.1 200 OK\nContent-Type: application/json\nCache-Control: no-cache\n\n{\"status\":\"success\",\"data\":{\"message\":\"Hello World\"}}";
    private static final Logger LOG = LoggerFactory.getLogger(AiResponseTransformerTemplate.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String userContent;
    private ServerHttpRequest originalRequest;

    public AiResponseTransformerTemplate(String userContent, ServerHttpRequest originalRequest) {
        this.userContent = userContent;
        this.originalRequest = originalRequest;
    }

    private JsonNode headersToJson(HttpHeaders headers) {
        ObjectNode headersNode = this.objectMapper.createObjectNode();
        for (Map.Entry entry : headers.entrySet()) {
            String joinedValues = String.join((CharSequence)",", (Iterable)entry.getValue());
            headersNode.put((String)entry.getKey(), joinedValues);
        }
        return headersNode;
    }

    private Mono<String> bodyToString(Flux<DataBuffer> body) {
        return DataBufferUtils.join(body).map(dataBuffer -> {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            DataBufferUtils.release((DataBuffer)dataBuffer);
            return new String(bytes, StandardCharsets.UTF_8);
        }).defaultIfEmpty((Object)"");
    }

    private Map<String, String> parseFormUrlEncoded(String body) {
        if (Objects.isNull(body) || body.isEmpty()) {
            return Map.of();
        }
        return Arrays.stream(body.split("&")).map(kv -> kv.split("=", 2)).filter(arr -> ((String[])arr).length == 2).collect(Collectors.toMap(arr -> this.urlDecode(arr[0]), arr -> this.urlDecode(arr[1]), (v1, v2) -> v2, LinkedHashMap::new));
    }

    private String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            return s;
        }
    }

    public Mono<String> assembleMessage(ServerWebExchange exchange) {
        JsonNode requestHeadersJson = this.headersToJson(this.originalRequest.getHeaders());
        JsonNode responseHeadersJson = this.headersToJson(exchange.getResponse().getHeaders());
        MediaType requestContentType = this.originalRequest.getHeaders().getContentType();
        return this.bodyToString((Flux<DataBuffer>)this.originalRequest.getBody()).flatMap(requestBodyString -> {
            ObjectNode rootNode = this.objectMapper.createObjectNode();
            rootNode.put("system_prompt", SYS_CONTENT);
            rootNode.put("user_prompt", this.userContent);
            ObjectNode requestNode = this.objectMapper.createObjectNode();
            requestNode.set("headers", requestHeadersJson);
            if (Objects.nonNull(requestContentType)) {
                if (MediaType.APPLICATION_JSON.isCompatibleWith(requestContentType)) {
                    try {
                        JsonNode bodyJsonNode = this.objectMapper.readTree(requestBodyString);
                        requestNode.set("body", bodyJsonNode);
                    }
                    catch (Exception e) {
                        requestNode.put("body", requestBodyString);
                    }
                } else if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(requestContentType)) {
                    Map<String, String> formMap = this.parseFormUrlEncoded((String)requestBodyString);
                    JsonNode formJson = this.objectMapper.valueToTree(formMap);
                    requestNode.set("body", formJson);
                } else {
                    requestNode.put("body", requestBodyString);
                }
            } else {
                requestNode.put("body", requestBodyString);
            }
            ObjectNode responseNode = this.objectMapper.createObjectNode();
            responseNode.set("headers", responseHeadersJson);
            responseNode.put("status", exchange.getResponse().getStatusCode().value());
            responseNode.put("body", "");
            rootNode.set("request", (JsonNode)requestNode);
            rootNode.set("response", (JsonNode)responseNode);
            try {
                String jsonString = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
                LOG.debug("Assembled message: {}", (Object)jsonString);
                return Mono.just((Object)jsonString);
            }
            catch (Exception e) {
                LOG.error("Failed to assemble message", (Throwable)e);
                return Mono.error((Throwable)e);
            }
        });
    }
}

