/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.message.Message;
import com.weibo.breeze.serializer.Serializer;
import com.weibo.breeze.type.BreezeType;

public class TypeMessage<T>
implements BreezeType<T> {
    private Message defaultMessage;
    private Serializer<T> serializer;
    private String name;

    public TypeMessage(Class<T> clz) throws BreezeException {
        if (clz == null) {
            throw new BreezeException("class must not null in TypeMessage");
        }
        if (Message.class.isAssignableFrom(clz)) {
            try {
                this.defaultMessage = (Message)clz.newInstance();
                this.name = this.defaultMessage.messageName();
            }
            catch (Exception e) {
                throw new BreezeException("create new default Message fail. Message must have a constructor without arguments. e:" + e.getMessage());
            }
        } else {
            this.serializer = Breeze.getSerializer(clz);
            if (this.serializer == null) {
                throw new BreezeException("can not find breeze serializer for class: " + clz.getName());
            }
            this.name = this.serializer.getNames()[0];
        }
    }

    public TypeMessage(Message defaultMessage) throws BreezeException {
        if (defaultMessage == null) {
            throw new BreezeException("default Message must not null in TypeMessage");
        }
        this.defaultMessage = defaultMessage;
        this.name = defaultMessage.messageName();
    }

    public TypeMessage(Serializer<T> serializer) throws BreezeException {
        if (serializer == null) {
            throw new BreezeException("serializer must not null in TypeMessage");
        }
        this.serializer = serializer;
        this.name = serializer.getNames()[0];
    }

    @Override
    public byte getType() {
        return -34;
    }

    @Override
    public void putType(BreezeBuffer buffer) throws BreezeException {
        BreezeWriter.putMessageType(buffer, this.name);
    }

    @Override
    public T read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        if (withType) {
            byte type = buffer.get();
            if (type == -103) {
                return null;
            }
            BreezeReader.readMessageName(buffer, type);
        }
        if (this.defaultMessage != null) {
            return (T)this.defaultMessage.defaultInstance().readFromBuf(buffer);
        }
        return this.serializer.readFromBuf(buffer);
    }

    @Override
    public void write(BreezeBuffer buffer, T value, boolean withType) throws BreezeException {
        BreezeWriter.checkWriteCount(buffer, value);
        if (withType) {
            BreezeWriter.putMessageType(buffer, this.name);
        }
        if (value instanceof Message) {
            ((Message)value).writeToBuf(buffer);
        } else {
            this.serializer.writeToBuf(value, buffer);
        }
    }
}

