/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.tcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;

public final class UpstreamProvider {
    private static final UpstreamProvider SINGLETON = new UpstreamProvider();
    private final Map<String, List<DiscoveryUpstreamData>> cache = new ConcurrentHashMap<String, List<DiscoveryUpstreamData>>();

    private UpstreamProvider() {
    }

    public static UpstreamProvider getSingleton() {
        return SINGLETON;
    }

    public List<DiscoveryUpstreamData> provide(String pluginSelectorName) {
        return this.cache.getOrDefault(pluginSelectorName, new ArrayList());
    }

    public void createUpstreams(String pluginSelectorName, List<DiscoveryUpstreamData> upstreams) {
        List discoveryUpstreamDataList = Optional.ofNullable(upstreams).orElseGet(ArrayList::new);
        this.cache.put(pluginSelectorName, discoveryUpstreamDataList);
    }

    public List<DiscoveryUpstreamData> refreshCache(String pluginSelectorName, List<DiscoveryUpstreamData> upstreams) {
        List<DiscoveryUpstreamData> remove = this.cache.remove(pluginSelectorName);
        if (Objects.isNull(remove)) {
            return Collections.emptyList();
        }
        List discoveryUpstreamDataList = Optional.ofNullable(upstreams).orElse(new ArrayList());
        this.cache.put(pluginSelectorName, discoveryUpstreamDataList);
        Set urlSet = discoveryUpstreamDataList.stream().map(DiscoveryUpstreamData::getUrl).collect(Collectors.toSet());
        return remove.stream().filter(r -> !urlSet.contains(r.getUrl())).collect(Collectors.toList());
    }
}

