/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.common.handler;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.logging.common.collector.LogCollector;
import org.apache.shenyu.plugin.logging.common.config.GenericApiConfig;
import org.apache.shenyu.plugin.logging.common.config.GenericGlobalConfig;
import org.apache.shenyu.plugin.logging.common.entity.CommonLoggingRuleHandle;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogPluginDataHandler<T extends GenericGlobalConfig, C extends GenericApiConfig>
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, CommonLoggingRuleHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractLogPluginDataHandler.class);
    private static final String EMPTY_JSON = "{}";
    private static final Map<String, GenericApiConfig> SELECT_API_CONFIG_MAP = new ConcurrentHashMap<String, GenericApiConfig>();
    private static final Map<String, GenericGlobalConfig> PLUGIN_GLOBAL_CONFIG_MAP = new ConcurrentHashMap<String, GenericGlobalConfig>();

    public static Map<String, GenericApiConfig> getSelectApiConfigMap() {
        return SELECT_API_CONFIG_MAP;
    }

    public static Map<String, GenericGlobalConfig> getPluginGlobalConfigMap() {
        return PLUGIN_GLOBAL_CONFIG_MAP;
    }

    protected abstract LogCollector logCollector();

    protected abstract void doRefreshConfig(T var1);

    public void handlerPlugin(PluginData pluginData) {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Class globalLogConfigClass = (Class)actualTypeArguments[0];
        LOG.info("handler {} Plugin data:  {}", (Object)this.pluginNamed(), (Object)GsonUtils.getGson().toJson((Object)pluginData));
        if (Objects.nonNull(pluginData) && Boolean.TRUE.equals(pluginData.getEnabled())) {
            GenericGlobalConfig globalLogConfig = (GenericGlobalConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), globalLogConfigClass);
            GenericGlobalConfig exist = (GenericGlobalConfig)Singleton.INST.get(globalLogConfigClass);
            if (Objects.isNull(globalLogConfig)) {
                return;
            }
            if (Objects.isNull(exist) || !globalLogConfig.equals(exist)) {
                this.doRefreshConfig(globalLogConfig);
                this.logCollector().start();
            }
            Singleton.INST.single(globalLogConfigClass, (Object)globalLogConfig);
            globalLogConfig.setSampler(LogCollectConfigUtils.setSampler(globalLogConfig.getSampleRate()));
            PLUGIN_GLOBAL_CONFIG_MAP.put(pluginData.getId(), globalLogConfig);
        } else {
            try {
                this.logCollector().close();
                PLUGIN_GLOBAL_CONFIG_MAP.remove(pluginData.getId());
            }
            catch (Exception e) {
                LOG.error("{} close log collector error", (Object)this.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    public void handlerSelector(SelectorData selectorData) {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Class genericApiConfigClass = (Class)actualTypeArguments[1];
        LOG.info("handler {} selector data:{}", (Object)this.pluginNamed(), (Object)GsonUtils.getGson().toJson((Object)selectorData));
        String handleJson = selectorData.getHandle();
        if (StringUtils.isEmpty((CharSequence)handleJson) || EMPTY_JSON.equals(handleJson.trim())) {
            return;
        }
        GenericApiConfig logApiConfig = (GenericApiConfig)GsonUtils.getInstance().fromJson(handleJson, genericApiConfigClass);
        if (StringUtils.isNotEmpty((CharSequence)logApiConfig.getSampleRate())) {
            logApiConfig.setSampler(LogCollectConfigUtils.setSampler(logApiConfig.getSampleRate()));
        }
        SELECT_API_CONFIG_MAP.put(selectorData.getId(), logApiConfig);
    }

    public void removeSelector(SelectorData selectorData) {
        LOG.info("handler remove {} selector data:{}", (Object)this.pluginNamed(), (Object)GsonUtils.getGson().toJson((Object)selectorData));
        SELECT_API_CONFIG_MAP.remove(selectorData.getId());
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            CommonLoggingRuleHandle commonLoggingRuleHandle = (CommonLoggingRuleHandle)GsonUtils.getInstance().fromJson(s, CommonLoggingRuleHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)commonLoggingRuleHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }
}

