/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.rpc.loadbalance;

import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.util.Pair;
import com.qq.tars.rpc.common.Invoker;
import com.qq.tars.support.log.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;

public class LoadBalanceHelper {
    private static final Logger logger = LoggerFactory.getClientLogger();

    /*
     * WARNING - void declaration
     */
    public static <T> List<Invoker<T>> buildStaticWeightList(Collection<Invoker<T>> invokers, ServantProxyConfig config) {
        void var11_18;
        ArrayList<Invoker<T>> weightInvokers = new ArrayList<Invoker<T>>();
        for (Invoker<T> invoker : invokers) {
            if (invoker.getUrl().getParameter("weightType", 0) != 1) {
                return null;
            }
            if (invoker.getUrl().getParameter("weight", 0) <= 0) continue;
            weightInvokers.add(invoker);
        }
        if (weightInvokers.isEmpty()) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[buildStaticWeightList]: weightInvokers size: " + weightInvokers.size());
        }
        int minWeight = Integer.MAX_VALUE;
        int maxWeight = Integer.MIN_VALUE;
        for (Invoker invoker : weightInvokers) {
            int tmpWeight = invoker.getUrl().getParameter("weight", 0);
            if (tmpWeight > maxWeight) {
                maxWeight = tmpWeight;
            }
            if (tmpWeight >= minWeight) continue;
            minWeight = tmpWeight;
        }
        int maxRange = maxWeight / minWeight;
        if (maxRange < config.getMinStaticWeightLimit()) {
            maxRange = config.getMinStaticWeightLimit();
        }
        if (maxRange > config.getMaxStaticWeightLimit()) {
            maxRange = config.getMaxStaticWeightLimit();
        }
        WeightToInvokerComparator weightToInvokerComparator = new WeightToInvokerComparator();
        TreeSet weightToInvoker = new TreeSet(weightToInvokerComparator);
        HashMap<Invoker, Integer> invokerToWeight = new HashMap<Invoker, Integer>();
        int totalWeight = 0;
        for (Invoker invoker : weightInvokers) {
            int weight = invoker.getUrl().getParameter("weight", 0) * maxRange / maxWeight;
            totalWeight += weight;
            weightToInvoker.add(new Pair<Integer, Invoker>(weight, invoker));
            invokerToWeight.put(invoker, weight);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("[buildStaticWeightList]: invoker: " + invoker.hashCode() + ", weight: " + weight + ", host: " + invoker.getUrl().getHost() + ", port: " + invoker.getUrl().getPort());
        }
        ArrayList<Invoker<T>> result = new ArrayList<Invoker<T>>();
        boolean bl = false;
        while (var11_18 < totalWeight) {
            boolean first = true;
            TreeSet weightToInvokerTmp = new TreeSet(weightToInvokerComparator);
            Iterator it = weightToInvoker.descendingIterator();
            while (it.hasNext()) {
                Pair pair = (Pair)it.next();
                if (first) {
                    first = false;
                    result.add((Invoker<T>)pair.second);
                    weightToInvokerTmp.add(new Pair((Integer)pair.first - totalWeight + (Integer)invokerToWeight.get(pair.second), pair.second));
                    continue;
                }
                weightToInvokerTmp.add(new Pair((Integer)pair.first + (Integer)invokerToWeight.get(pair.second), pair.second));
            }
            weightToInvoker = weightToInvokerTmp;
            ++var11_18;
        }
        return result;
    }

    public static <T> TreeMap<Long, Invoker<T>> buildConsistentHashCircle(Collection<Invoker<T>> invokers, ServantProxyConfig config) {
        ArrayList<Invoker<T>> weightInvokers = new ArrayList<Invoker<T>>();
        for (Invoker<T> invoker : invokers) {
            if (invoker.getUrl().getParameter("weightType", 0) != 1) {
                weightInvokers.clear();
                break;
            }
            if (invoker.getUrl().getParameter("weight", 0) <= 0) continue;
            weightInvokers.add(invoker);
        }
        TreeMap<Long, Invoker<T>> result = new TreeMap<Long, Invoker<T>>();
        try {
            boolean staticWeight = !weightInvokers.isEmpty();
            Collection<Object> srcInvokers = staticWeight ? weightInvokers : invokers;
            for (Invoker invoker : srcInvokers) {
                int replicaNumber;
                int n = replicaNumber = staticWeight ? invoker.getUrl().getParameter("weight", 0) : config.getDefaultConHashVirtualNodes();
                if (replicaNumber > config.getDefaultConHashVirtualNodes()) {
                    replicaNumber = config.getDefaultConHashVirtualNodes();
                }
                replicaNumber = replicaNumber / 4 <= 0 ? 1 : replicaNumber / 4;
                for (int i = 0; i < replicaNumber; ++i) {
                    byte[] digest = LoadBalanceHelper.md5(invoker.getUrl().toIdentityString() + i);
                    for (int h = 0; h < 4; ++h) {
                        long m = LoadBalanceHelper.hash(digest, h);
                        result.put(m, invoker);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("build consistent hash circle err. ", (Throwable)e);
            return null;
        }
        return result;
    }

    private static byte[] md5(String value) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        md5.reset();
        byte[] bytes = null;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        md5.update(bytes);
        return md5.digest();
    }

    private static long hash(byte[] digest, int number) {
        return ((long)(digest[3 + number * 4] & 0xFF) << 24 | (long)(digest[2 + number * 4] & 0xFF) << 16 | (long)(digest[1 + number * 4] & 0xFF) << 8 | (long)(digest[0 + number * 4] & 0xFF)) & 0xFFFFFFFFL;
    }

    private static class WeightToInvokerComparator<T>
    implements Comparator<Pair<Integer, Invoker<T>>> {
        private WeightToInvokerComparator() {
        }

        @Override
        public int compare(Pair<Integer, Invoker<T>> o1, Pair<Integer, Invoker<T>> o2) {
            if (o1.first == o2.first) {
                return ((Invoker)o1.second).hashCode() - ((Invoker)o2.second).hashCode();
            }
            return ((Integer)o1.first).compareTo((Integer)o2.first);
        }
    }
}

