/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.metric.HystrixCommandCompletion;
import com.netflix.hystrix.metric.HystrixCommandCompletionStream;
import com.netflix.hystrix.metric.consumer.BucketedCumulativeCounterStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import rx.functions.Func2;

public class CumulativeCommandEventCounterStream
extends BucketedCumulativeCounterStream<HystrixCommandCompletion, long[], long[]> {
    private static final ConcurrentMap<String, CumulativeCommandEventCounterStream> streams = new ConcurrentHashMap<String, CumulativeCommandEventCounterStream>();
    private static final int NUM_EVENT_TYPES = HystrixEventType.values().length;

    public static CumulativeCommandEventCounterStream getInstance(HystrixCommandKey commandKey, HystrixCommandProperties properties) {
        int counterMetricWindow = properties.metricsRollingStatisticalWindowInMilliseconds().get();
        int numCounterBuckets = properties.metricsRollingStatisticalWindowBuckets().get();
        int counterBucketSizeInMs = counterMetricWindow / numCounterBuckets;
        return CumulativeCommandEventCounterStream.getInstance(commandKey, numCounterBuckets, counterBucketSizeInMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CumulativeCommandEventCounterStream getInstance(HystrixCommandKey commandKey, int numBuckets, int bucketSizeInMs) {
        CumulativeCommandEventCounterStream initialStream = (CumulativeCommandEventCounterStream)streams.get(commandKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<CumulativeCommandEventCounterStream> clazz = CumulativeCommandEventCounterStream.class;
        synchronized (CumulativeCommandEventCounterStream.class) {
            CumulativeCommandEventCounterStream existingStream = (CumulativeCommandEventCounterStream)streams.get(commandKey.name());
            if (existingStream == null) {
                CumulativeCommandEventCounterStream newStream = new CumulativeCommandEventCounterStream(commandKey, numBuckets, bucketSizeInMs, HystrixCommandMetrics.appendEventToBucket, HystrixCommandMetrics.bucketAggregator);
                streams.putIfAbsent(commandKey.name(), newStream);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return existingStream;
        }
    }

    public static void reset() {
        streams.clear();
    }

    private CumulativeCommandEventCounterStream(HystrixCommandKey commandKey, int numCounterBuckets, int counterBucketSizeInMs, Func2<long[], HystrixCommandCompletion, long[]> reduceCommandCompletion, Func2<long[], long[], long[]> reduceBucket) {
        super(HystrixCommandCompletionStream.getInstance(commandKey), numCounterBuckets, counterBucketSizeInMs, reduceCommandCompletion, reduceBucket);
    }

    @Override
    long[] getEmptyBucketSummary() {
        return new long[NUM_EVENT_TYPES];
    }

    @Override
    long[] getEmptyOutputValue() {
        return new long[NUM_EVENT_TYPES];
    }

    public long getLatest(HystrixEventType eventType) {
        return ((long[])this.getLatest())[eventType.ordinal()];
    }
}

