/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.desensitize.api.utils;

import java.util.List;
import java.util.Map;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.logging.desensitize.api.factory.DataDesensitizeFactory;
import org.apache.shenyu.plugin.logging.desensitize.api.matcher.KeyWordMatch;
import org.springframework.util.StringUtils;

public final class DataDesensitizeUtils {
    public static String desensitizeForSingleWord(String keyWord, String source, KeyWordMatch keyWordMatch, String desensitizeAlg) {
        return DataDesensitizeUtils.desensitizeSingleKeyword(true, keyWord, source, keyWordMatch, desensitizeAlg);
    }

    public static String desensitizeForBody(String source, KeyWordMatch keyWordMatch, String desensitizeAlg) {
        return DataDesensitizeUtils.desensitizeBody(true, source, keyWordMatch, desensitizeAlg);
    }

    public static String desensitizeSingleKeyword(boolean desensitized, String keyWord, String source, KeyWordMatch keyWordMatch, String desensitizedAlg) {
        if (StringUtils.hasLength((String)source) && desensitized && keyWordMatch.matches(keyWord)) {
            return DataDesensitizeFactory.selectDesensitize(source, desensitizedAlg);
        }
        return source;
    }

    public static String desensitizeBody(boolean desensitized, String source, KeyWordMatch keyWordMatch, String dataDesensitizeAlg) {
        if (StringUtils.hasLength((String)source) && desensitized) {
            Map bodyMap = JsonUtils.jsonToMap((String)source, String.class);
            bodyMap.forEach((key, value) -> {
                if (keyWordMatch.matches((String)key)) {
                    bodyMap.put(key, DataDesensitizeFactory.selectDesensitize(value, dataDesensitizeAlg));
                }
            });
            return JsonUtils.toJson((Object)bodyMap);
        }
        return source;
    }

    public static void desensitizeList(boolean desensitized, String keyword, List<String> source, KeyWordMatch keyWordMatch, String dataDesensitizeAlg) {
        if (desensitized && keyWordMatch.matches(keyword)) {
            for (int i = 0; i < source.size(); ++i) {
                String ret = DataDesensitizeFactory.selectDesensitize(source.get(i), dataDesensitizeAlg);
                source.set(i, ret);
            }
        }
    }
}

