/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.sql.Timestamp;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;

public class TimestampSchema
extends AbstractSchema<Timestamp> {
    private static final TimestampSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static TimestampSchema of() {
        return INSTANCE;
    }

    public byte[] encode(Timestamp message) {
        if (null == message) {
            return null;
        }
        Long timestamp = message.getTime();
        return LongSchema.of().encode(timestamp);
    }

    public Timestamp decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        Long decode = LongSchema.of().decode(bytes);
        return new Timestamp(decode);
    }

    @Override
    public Timestamp decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        Long decode = LongSchema.of().decode(byteBuf);
        return new Timestamp(decode);
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = SchemaInfoImpl.builder().name("Timestamp").type(SchemaType.TIMESTAMP).schema(new byte[0]).build();
        INSTANCE = new TimestampSchema();
    }
}

