/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.InternalChannelz;
import io.grpc.InternalInstrumented;
import io.grpc.InternalLogId;
import io.grpc.ServerStreamTracer;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerTransport;
import io.grpc.okhttp.OkHttpServerBuilder;
import io.grpc.okhttp.OkHttpServerTransport;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;

final class OkHttpServer
implements InternalServer {
    private static final Logger log = Logger.getLogger(OkHttpServer.class.getName());
    private final SocketAddress originalListenAddress;
    private final ServerSocketFactory socketFactory;
    private final ObjectPool<Executor> transportExecutorPool;
    private final ObjectPool<ScheduledExecutorService> scheduledExecutorServicePool;
    private final OkHttpServerTransport.Config transportConfig;
    private final InternalChannelz channelz;
    private ServerSocket serverSocket;
    private SocketAddress actualListenAddress;
    private InternalInstrumented<InternalChannelz.SocketStats> listenInstrumented;
    private Executor transportExecutor;
    private ScheduledExecutorService scheduledExecutorService;
    private ServerListener listener;
    private boolean shutdown;

    public OkHttpServer(OkHttpServerBuilder builder, List<? extends ServerStreamTracer.Factory> streamTracerFactories, InternalChannelz channelz) {
        this.originalListenAddress = (SocketAddress)Preconditions.checkNotNull((Object)builder.listenAddress, (Object)"listenAddress");
        this.socketFactory = (ServerSocketFactory)Preconditions.checkNotNull((Object)builder.socketFactory, (Object)"socketFactory");
        this.transportExecutorPool = (ObjectPool)Preconditions.checkNotNull(builder.transportExecutorPool, (Object)"transportExecutorPool");
        this.scheduledExecutorServicePool = (ObjectPool)Preconditions.checkNotNull(builder.scheduledExecutorServicePool, (Object)"scheduledExecutorServicePool");
        this.transportConfig = new OkHttpServerTransport.Config(builder, streamTracerFactories);
        this.channelz = (InternalChannelz)Preconditions.checkNotNull((Object)channelz, (Object)"channelz");
    }

    public void start(ServerListener listener) throws IOException {
        this.listener = (ServerListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        ServerSocket serverSocket = this.socketFactory.createServerSocket();
        try {
            serverSocket.bind(this.originalListenAddress);
        }
        catch (IOException t) {
            serverSocket.close();
            throw t;
        }
        this.serverSocket = serverSocket;
        this.actualListenAddress = serverSocket.getLocalSocketAddress();
        this.listenInstrumented = new ListenSocket(serverSocket);
        this.transportExecutor = (Executor)this.transportExecutorPool.getObject();
        this.scheduledExecutorService = (ScheduledExecutorService)this.scheduledExecutorServicePool.getObject();
        this.channelz.addListenSocket(this.listenInstrumented);
        this.transportExecutor.execute(this::acceptConnections);
    }

    private void acceptConnections() {
        try {
            while (true) {
                Socket socket;
                try {
                    socket = this.serverSocket.accept();
                }
                catch (IOException ex) {
                    if (!this.shutdown) {
                        throw ex;
                    }
                    break;
                }
                OkHttpServerTransport transport = new OkHttpServerTransport(this.transportConfig, socket);
                transport.start(this.listener.transportCreated((ServerTransport)transport));
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Accept loop failed", t);
        }
        this.listener.serverShutdown();
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.serverSocket == null) {
            return;
        }
        this.channelz.removeListenSocket(this.listenInstrumented);
        try {
            this.serverSocket.close();
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Failed closing server socket", this.serverSocket);
        }
        this.transportExecutor = (Executor)this.transportExecutorPool.returnObject((Object)this.transportExecutor);
        this.scheduledExecutorService = (ScheduledExecutorService)this.scheduledExecutorServicePool.returnObject((Object)this.scheduledExecutorService);
    }

    public SocketAddress getListenSocketAddress() {
        return this.actualListenAddress;
    }

    public InternalInstrumented<InternalChannelz.SocketStats> getListenSocketStats() {
        return this.listenInstrumented;
    }

    public List<? extends SocketAddress> getListenSocketAddresses() {
        return Collections.singletonList(this.getListenSocketAddress());
    }

    public List<InternalInstrumented<InternalChannelz.SocketStats>> getListenSocketStatsList() {
        return Collections.singletonList(this.getListenSocketStats());
    }

    private static final class ListenSocket
    implements InternalInstrumented<InternalChannelz.SocketStats> {
        private final InternalLogId id;
        private final ServerSocket socket;

        public ListenSocket(ServerSocket socket) {
            this.socket = socket;
            this.id = InternalLogId.allocate(this.getClass(), (String)String.valueOf(socket.getLocalSocketAddress()));
        }

        public ListenableFuture<InternalChannelz.SocketStats> getStats() {
            return Futures.immediateFuture((Object)new InternalChannelz.SocketStats(null, this.socket.getLocalSocketAddress(), null, new InternalChannelz.SocketOptions.Builder().build(), null));
        }

        public InternalLogId getLogId() {
            return this.id;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("logId", this.id.getId()).add("socket", (Object)this.socket).toString();
        }
    }
}

